/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.core.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import github.thelawf.gensokyoontology.common.world.structure.AliceHouse;
import github.thelawf.gensokyoontology.common.world.structure.BeastPathStructure;
import github.thelawf.gensokyoontology.common.world.structure.ChireidenStructure;
import github.thelawf.gensokyoontology.common.world.structure.CirnoIceHouseStructure;
import github.thelawf.gensokyoontology.common.world.structure.HakureiShrineStructure;
import github.thelawf.gensokyoontology.common.world.structure.HumanVillageStructure;
import github.thelawf.gensokyoontology.common.world.structure.MystiaIzakayaStructure;
import github.thelawf.gensokyoontology.common.world.structure.ScarletDevilMansion;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class StructureRegistry {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"gensokyoontology");
    public static final RegistryObject<Structure<NoFeatureConfig>> ALICE_HOUSE = STRUCTURES.register("alice_house", () -> new AliceHouse((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> SCARLET_DEVIL_MANSION = STRUCTURES.register("scarlet_devil_mansion", () -> new ScarletDevilMansion((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> MYSTIA_IZAKAYA = STRUCTURES.register("mystia_izakaya", () -> new MystiaIzakayaStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> HAKUREI_SHRINE = STRUCTURES.register("hakurei_shrine", () -> new HakureiShrineStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> CHIREIDEN = STRUCTURES.register("chireiden", () -> new ChireidenStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> BEAST_PATHWAY = STRUCTURES.register("beast_pathway", () -> new BeastPathStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> CIRNO_ICE_HOUSE = STRUCTURES.register("cirno_ice_house", () -> new CirnoIceHouseStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<NoFeatureConfig>> HUMAN_VILLAGE = STRUCTURES.register("human_village", () -> new HumanVillageStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static void setupStructures() {
        StructureRegistry.setupMapSpacingAndLand((Structure)ALICE_HOUSE.get(), new StructureSeparationSettings(30, 15, 19298474), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)SCARLET_DEVIL_MANSION.get(), new StructureSeparationSettings(80, 50, 745264516), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)MYSTIA_IZAKAYA.get(), new StructureSeparationSettings(20, 10, 1023567897), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)HAKUREI_SHRINE.get(), new StructureSeparationSettings(30, 20, 51392147), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)CHIREIDEN.get(), new StructureSeparationSettings(80, 50, 413054656), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)CIRNO_ICE_HOUSE.get(), new StructureSeparationSettings(25, 15, 64916420), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)BEAST_PATHWAY.get(), new StructureSeparationSettings(8, 3, 994251466), true);
        StructureRegistry.setupMapSpacingAndLand((Structure)HUMAN_VILLAGE.get(), new StructureSeparationSettings(20, 10, 854694869), true);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

