/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.data.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import github.thelawf.gensokyoontology.core.RecipeRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class DanmakuRecipe
extends ShapedRecipe {
    public static final ResourceLocation RECIPE_ID = new ResourceLocation("gensokyoontology", "danmaku_craft");
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;

    public DanmakuRecipe(String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(RECIPE_ID, groupIn, 5, 5, recipeItemsIn, recipeOutputIn);
        this.recipeItems = recipeItemsIn;
        this.recipeOutput = recipeOutputIn;
        DanmakuRecipe.setCraftingSize((int)5, (int)5);
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeRegistry.DANMAKU_CRAFT_SERIALIZER.get();
    }

    private static NonNullList<Ingredient> func_192402_a(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    private static Map<String, Ingredient> func_192408_a(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    @VisibleForTesting
    static String[] func_194134_a(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, DanmakuRecipe.func_194135_a(s));
            int j1 = DanmakuRecipe.func_194136_b(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int func_194135_a(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int func_194136_b(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] func_192407_a(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > 5) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 5 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 5) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 5 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DanmakuRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        @NotNull
        public DanmakuRecipe read(ResourceLocation recipeId, @NotNull JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = DanmakuRecipe.func_192408_a(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = DanmakuRecipe.func_194134_a(DanmakuRecipe.func_192407_a(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = DanmakuRecipe.func_192402_a(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new DanmakuRecipe(recipeId.toString(), (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public DanmakuRecipe read(@NotNull ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            nonnulllist.replaceAll(ignored -> Ingredient.func_199566_b((PacketBuffer)buffer));
            ItemStack itemstack = buffer.func_150791_c();
            return new DanmakuRecipe(recipeId.toString(), (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void write(PacketBuffer buffer, DanmakuRecipe recipe) {
            buffer.func_150787_b(recipe.getRecipeWidth());
            buffer.func_150787_b(recipe.getRecipeHeight());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }

    public static class Type
    implements IRecipeType<DanmakuRecipe> {
        public String toString() {
            return RECIPE_ID.toString();
        }
    }
}

