/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import github.thelawf.gensokyoontology.core.RecipeRegistry;
import github.thelawf.gensokyoontology.data.recipe.ISorceryExtractorRecipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SorceryExtractorRecipe
implements ISorceryExtractorRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;

    public SorceryExtractorRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> inputs) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
    }

    public boolean func_77569_a(@NotNull IInventory inv, @NotNull World worldIn) {
        int matches = 0;
        for (int i = 0; i < 4; ++i) {
            if (i >= this.inputs.size() || !((Ingredient)this.inputs.get(i)).test(inv.func_70301_a(i))) continue;
            ++matches;
        }
        return matches == this.inputs.size();
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull IInventory inv) {
        return this.output;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeRegistry.SORCERY_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SorceryExtractorRecipe> {
        @NotNull
        public SorceryExtractorRecipe read(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.func_191196_a();
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.func_199802_a((JsonElement)ingredients.get(i)));
            }
            return new SorceryExtractorRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        @Nullable
        public SorceryExtractorRecipe read(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            ItemStack output = buffer.func_150791_c();
            int i = buffer.func_150792_a();
            NonNullList inputs = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            inputs.replaceAll(ignored -> Ingredient.func_199566_b((PacketBuffer)buffer));
            return new SorceryExtractorRecipe(recipeId, output, (NonNullList<Ingredient>)inputs);
        }

        public void write(PacketBuffer buffer, SorceryExtractorRecipe recipe) {
            buffer.writeItemStack(recipe.func_77571_b(), false);
            buffer.func_150787_b(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.func_199564_a(buffer);
            }
        }
    }

    public static class SorceryRecipeType
    implements IRecipeType<SorceryExtractorRecipe> {
        public String toString() {
            return RECIPE_ID.toString();
        }
    }
}

