/*
 * Decompiled with CFR 0.152.
 */
package github.thelawf.gensokyoontology.data.world;

import github.thelawf.gensokyoontology.GensokyoOntology;
import github.thelawf.gensokyoontology.data.world.GensokyoSeason;
import java.util.Stack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import org.jetbrains.annotations.NotNull;

public class GSKOWorldSavedData
extends WorldSavedData {
    private static final String NAME = "GSKOWorldSavedData";
    private GensokyoSeason season = GensokyoSeason.SPRING;
    private final Stack<ResourceLocation> incidents = new Stack();

    public GSKOWorldSavedData() {
        super(NAME);
    }

    public GSKOWorldSavedData(String name) {
        super(name);
    }

    public static GSKOWorldSavedData getInstance(World worldIn) {
        if (!(worldIn instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld serverWorld = (ServerWorld)worldIn;
        DimensionSavedDataManager storage = serverWorld.func_217481_x();
        return (GSKOWorldSavedData)storage.func_215752_a(GSKOWorldSavedData::new, NAME);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.season = GensokyoSeason.valueOf(nbt.func_74779_i("season"));
        ListNBT listNBT = (ListNBT)nbt.func_74781_a("incidents");
        if (listNBT != null) {
            for (INBT inbt : listNBT) {
                if (!(inbt instanceof StringNBT)) continue;
                StringNBT value = (StringNBT)inbt;
                this.incidents.push(GensokyoOntology.withRL(value.func_150285_a_()));
            }
        }
    }

    @NotNull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT listNBT = new ListNBT();
        this.incidents.forEach(location -> {
            StringNBT stringNBT = StringNBT.func_229705_a_((String)location.toString());
            listNBT.add((Object)stringNBT);
        });
        compound.func_74778_a("season", this.season.name());
        compound.func_218657_a("incidents", (INBT)listNBT);
        return compound;
    }

    public GensokyoSeason getSeason() {
        return this.season;
    }

    public void setSeason(GensokyoSeason season) {
        this.season = season;
    }

    public Stack<ResourceLocation> getIncidents() {
        return this.incidents;
    }
}

