/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamabnormals.caverns_and_chasms.common.block.ToolboxBlock;
import com.teamabnormals.caverns_and_chasms.common.block.entity.ToolboxBlockEntity;
import com.teamabnormals.caverns_and_chasms.core.other.CCModelLayers;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ToolboxRenderer<T extends ToolboxBlockEntity>
implements BlockEntityRenderer<T> {
    public static Block itemBlock = null;
    public static final ResourceLocation[] TOOLBOX_TEXTURES = new ResourceLocation[]{new ResourceLocation("caverns_and_chasms", "entity/toolbox/toolbox"), new ResourceLocation("caverns_and_chasms", "entity/toolbox/exposed_toolbox"), new ResourceLocation("caverns_and_chasms", "entity/toolbox/weathered_toolbox"), new ResourceLocation("caverns_and_chasms", "entity/toolbox/oxidized_toolbox")};
    public static final Map<WeatheringCopper.WeatherState, Material> TOOLBOX_MATERIALS = Map.of(WeatheringCopper.WeatherState.UNAFFECTED, ToolboxRenderer.createToolboxMaterial(TOOLBOX_TEXTURES[0]), WeatheringCopper.WeatherState.EXPOSED, ToolboxRenderer.createToolboxMaterial(TOOLBOX_TEXTURES[1]), WeatheringCopper.WeatherState.WEATHERED, ToolboxRenderer.createToolboxMaterial(TOOLBOX_TEXTURES[2]), WeatheringCopper.WeatherState.OXIDIZED, ToolboxRenderer.createToolboxMaterial(TOOLBOX_TEXTURES[3]));
    private final ModelPart base;
    private final ModelPart lid;

    private static Material createToolboxMaterial(ResourceLocation texture) {
        return new Material(InventoryMenu.f_39692_, texture);
    }

    public ToolboxRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(CCModelLayers.TOOLBOX);
        this.lid = root.m_171324_("lid");
        this.base = root.m_171324_("base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, 0.0f, -8.0f, 16.0f, 6.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)4.0f));
        root.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-8.0f, -2.0f, -8.0f, 16.0f, 2.0f, 8.0f).m_171514_(0, 29).m_171481_(-4.0f, -5.0f, -4.0f, 8.0f, 3.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void render(T toolbox, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Block block;
        Block inventoryBlock = itemBlock;
        BlockState state = toolbox.m_58904_() != null ? toolbox.m_58900_() : (BlockState)((Block)CCBlocks.TOOLBOX.get()).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        Block block2 = block = inventoryBlock == null ? state.m_60734_() : inventoryBlock;
        if (block instanceof ToolboxBlock) {
            ToolboxBlock toolboxBlock = (ToolboxBlock)block;
            boolean hanging = (Boolean)state.m_61143_((Property)ToolboxBlock.HANGING);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85837_(0.5, !hanging ? -1.5 : -1.8125, -0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((Direction)state.m_61143_(ToolboxBlock.FACING)).m_122435_()));
            float openness = 1.0f - ((ToolboxBlockEntity)((Object)toolbox)).getProgress(partialTicks);
            float xRot = -((1.0f - openness * openness * openness) * 1.5707964f);
            if (!hanging) {
                this.base.f_104203_ = 0.0f;
                this.lid.f_104203_ = xRot;
            } else {
                this.lid.f_104203_ = 0.0f;
                this.base.f_104203_ = -xRot * 5.0f / 12.0f;
            }
            VertexConsumer vertexConsumer = TOOLBOX_MATERIALS.get(toolboxBlock.getWeatherState()).m_119194_(buffer, RenderType::m_110452_);
            this.lid.m_104301_(poseStack, vertexConsumer, combinedLight, combinedOverlay);
            this.base.m_104301_(poseStack, vertexConsumer, combinedLight, combinedOverlay);
            poseStack.m_85849_();
        }
    }
}

