/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.caverns_and_chasms.client.model.CopperGolemModel;
import com.teamabnormals.caverns_and_chasms.common.entity.decoration.OxidizedCopperGolem;
import com.teamabnormals.caverns_and_chasms.core.other.CCModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OxidizedCopperGolemRenderer
extends LivingEntityRenderer<OxidizedCopperGolem, CopperGolemModel<OxidizedCopperGolem>> {
    private static final ResourceLocation OXIDIZED_GOLEM_TEXTURE = new ResourceLocation("caverns_and_chasms", "textures/entity/copper_golem/copper_golem_oxidized.png");
    private static final ResourceLocation DAMAGED_OXIDIZED_GOLEM_TEXTURE = new ResourceLocation("caverns_and_chasms", "textures/entity/copper_golem/copper_golem_oxidized_damaged.png");

    public OxidizedCopperGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new CopperGolemModel(context.m_174023_(CCModelLayers.COPPER_GOLEM)), 0.0f);
    }

    public ResourceLocation getTextureLocation(OxidizedCopperGolem copperGolem) {
        return copperGolem.isDamaged() ? DAMAGED_OXIDIZED_GOLEM_TEXTURE : OXIDIZED_GOLEM_TEXTURE;
    }

    protected void setupRotations(OxidizedCopperGolem copperGolem, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        float f = (float)(copperGolem.f_19853_.m_46467_() - copperGolem.lastHit) + partialTicks;
        if (f < 5.0f) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14031_((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(OxidizedCopperGolem Override) {
        return super.m_6512_((LivingEntity)Override) && (Override.m_6052_() || Override.m_8077_() && Override == this.f_114476_.f_114359_);
    }
}

