/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block;

import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBlockTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class BrazierBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape GROUNDED_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0));
    protected static final VoxelShape HANGING_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    private final float fireDamage;

    public BrazierBlock(float fireDamage, BlockBehaviour.Properties properties) {
        super(properties);
        this.fireDamage = fireDamage;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (!entityIn.m_5825_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(DamageSource.f_19305_, this.fireDamage);
        }
        super.m_7892_(state, level, pos, entityIn);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            boolean water = fluidstate.m_76152_() == Fluids.f_76193_;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!water));
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return BrazierBlock.getBlockConnected(stateIn).m_122424_() == facing && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : GROUNDED_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static BlockState extinguish(Entity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        BlockState extinguishedsstate = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        if (level.m_5776_()) {
            for (int i = 0; i < 20; ++i) {
                BrazierBlock.spawnSmokeParticles((Level)level, pos.m_7637_(0.5, 0.0, 0.5));
            }
        }
        level.m_142346_(entity, GameEvent.f_157792_, pos);
        return extinguishedsstate;
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                BrazierBlock.extinguish(null, level, pos, state);
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            level.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)level));
            return true;
        }
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.f_46443_ && projectile.m_6060_()) {
            boolean flag;
            Entity entity = projectile.m_37282_();
            boolean bl = flag = entity == null || entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity);
            if (flag && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.m_82425_();
                level.m_7731_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    public static void spawnSmokeParticles(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = BrazierBlock.getBlockConnected(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public static boolean isLit(BlockState state) {
        return state.m_61138_((Property)LIT) && state.m_204336_(CCBlockTags.BRAZIERS) && (Boolean)state.m_61143_((Property)LIT) != false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, HANGING, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static boolean canBeLit(BlockState state) {
        return state.m_204338_(CCBlockTags.BRAZIERS, stateIn -> stateIn.m_61138_((Property)BlockStateProperties.f_61362_) && stateIn.m_61138_((Property)BlockStateProperties.f_61443_)) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) == false;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return BrazierBlock.isLit(state) ? BlockPathTypes.DAMAGE_FIRE : super.getBlockPathType(state, level, pos, entity);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

