/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block;

import com.teamabnormals.blueprint.core.util.NetworkUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public interface FragileBlock {
    @Nonnull
    public String getDustParticle();

    @Nonnull
    public String getChipParticle();

    default public void breakNeighbors(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.m_121945_(direction);
            Block block = level.m_8055_(blockpos).m_60734_();
            if (!(block instanceof FragileBlock)) continue;
            level.m_186460_(blockpos, block, 4 + level.m_213780_().m_188503_(4));
        }
    }

    default public void crack(Level level, BlockState state, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.m_123341_() + random.m_188500_() * 0.8 + 0.1;
        double d1 = (double)pos.m_123342_() + random.m_188500_() * 0.8 + 0.1;
        double d2 = (double)pos.m_123343_() + random.m_188500_() * 0.8 + 0.1;
        double d3 = random.m_188583_() * 0.04;
        double d4 = random.m_188583_() * 0.04;
        double d5 = random.m_188583_() * 0.04;
        NetworkUtil.spawnParticle((String)this.getDustParticle(), (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5);
        int i = random.m_188503_(2) + 1;
        for (int j = 0; j < i; ++j) {
            double d6 = (double)pos.m_123341_() + random.m_188500_() * 0.8 + 0.1;
            double d7 = (double)pos.m_123342_() + random.m_188500_() * 0.8 + 0.1;
            double d8 = (double)pos.m_123343_() + random.m_188500_() * 0.8 + 0.1;
            double d9 = ((double)random.m_188501_() - 0.5) * 0.02;
            double d10 = ((double)random.m_188501_() - 0.5) * 0.02;
            NetworkUtil.spawnParticle((String)this.getChipParticle(), (double)d6, (double)d7, (double)d8, (double)d9, (double)-0.4, (double)d10);
        }
        SoundType soundtype = state.getSoundType((LevelReader)level, pos, null);
        level.m_5594_(null, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        level.m_7471_(pos, true);
        level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
    }

    default public boolean shouldBreakNeighbors(Player player, ItemStack stack) {
        return !player.m_7500_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0;
    }
}

