/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.item;

import com.teamabnormals.caverns_and_chasms.common.item.GoldenBucketItem;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class GoldenSolidBucketItem
extends BlockItem
implements DispensibleContainerItem {
    private final SoundEvent placeSound;

    public GoldenSolidBucketItem(Block block, SoundEvent placeSound, Item.Properties properties) {
        super(block, properties);
        this.placeSound = placeSound;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result;
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        int fluidLevel = stack.m_41784_().m_128451_("FluidLevel");
        Block block = state.m_60734_();
        if (block instanceof PowderSnowBlock) {
            PowderSnowBlock powderSnowBlock = (PowderSnowBlock)block;
            if (player != null && !player.m_6047_() && fluidLevel < 2) {
                powderSnowBlock.m_142598_((LevelAccessor)level, pos, state);
                player.m_5496_(SoundEvents.f_144089_, 1.0f, 1.0f);
                stack.m_41784_().m_128405_("FluidLevel", fluidLevel + 1);
                if (!level.f_46443_) {
                    CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, stack);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        if ((result = super.m_6225_(new UseOnContext(level, player, hand, stack.m_41777_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, context.m_43721_())))).m_19077_() && player != null && !player.m_7500_()) {
            if (fluidLevel > 0) {
                stack.m_41784_().m_128405_("FluidLevel", fluidLevel - 1);
            } else {
                stack = GoldenBucketItem.getEmptyBucket();
            }
            player.m_21008_(hand, stack);
        }
        return result;
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    protected SoundEvent m_40587_(BlockState state) {
        return this.placeSound;
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult result) {
        if (level.m_46739_(pos) && level.m_46859_(pos)) {
            if (!level.f_46443_) {
                level.m_7731_(pos, this.m_40614_().m_49966_(), 3);
            }
            level.m_5594_(player, pos, this.placeSound, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        int level = stack.m_41784_().m_128451_("FluidLevel");
        if (level > 0) {
            ItemStack newStack = new ItemStack((ItemLike)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get());
            newStack.m_41784_().m_128405_("FluidLevel", level - 1);
            return newStack;
        }
        return GoldenBucketItem.getEmptyBucket();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            items.add((Object)this.m_7968_());
        }
    }
}

