/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.data.client;

import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CCItemModelProvider
extends ItemModelProvider {
    public CCItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "caverns_and_chasms", existingFileHelper);
    }

    protected void registerModels() {
        this.generatedItem((ItemLike)CCBlocks.CUPRIC_CANDLE.get());
        this.animatedModel((ItemLike)CCItems.DEPTH_GAUGE.get(), 48);
        this.animatedModel((ItemLike)CCItems.BAROMETER.get(), 21);
        this.generatedItem((ItemLike)CCItems.ABNORMALS_BANNER_PATTERN.get(), (ItemLike)CCItems.COPPER_NUGGET.get(), (ItemLike)CCItems.OXIDIZED_COPPER_GOLEM.get(), (ItemLike)CCItems.RAW_SILVER.get(), (ItemLike)CCItems.LARGE_ARROW.get(), (ItemLike)CCItems.BEJEWELED_APPLE.get(), (ItemLike)CCItems.BLUNT_ARROW.get(), (ItemLike)((RegistryObject)CCItems.AZALEA_BOAT.getFirst()).get(), (ItemLike)((RegistryObject)CCItems.AZALEA_BOAT.getSecond()).get(), (ItemLike)CCItems.AZALEA_FURNACE_BOAT.get(), (ItemLike)CCItems.LARGE_AZALEA_BOAT.get());
        this.item((ItemLike)CCItems.WAXED_OXIDIZED_COPPER_GOLEM.get(), "oxidized_copper_golem", "generated");
        this.handheldItem((ItemLike)CCItems.KUNAI.get());
        this.spawnEggItem((ItemLike)CCItems.PEEPER_SPAWN_EGG.get());
    }

    private void generatedItem(ItemLike ... items) {
        for (ItemLike item : items) {
            this.item(item, "generated");
        }
    }

    private void handheldItem(ItemLike ... items) {
        for (ItemLike item : items) {
            this.item(item, "handheld");
        }
    }

    private void spawnEggItem(ItemLike ... items) {
        for (ItemLike item : items) {
            ResourceLocation name = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
            if (name == null) continue;
            this.withExistingParent(name.m_135815_(), "item/template_spawn_egg");
        }
    }

    private void item(ItemLike item, String type) {
        ResourceLocation itemName = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        ((ItemModelBuilder)this.withExistingParent(itemName.m_135815_(), "item/" + type)).texture("layer0", new ResourceLocation(this.modid, "item/" + itemName.m_135815_()));
    }

    private void item(ItemLike item, String path, String type) {
        ResourceLocation itemName = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        ((ItemModelBuilder)this.withExistingParent(itemName.m_135815_(), "item/" + type)).texture("layer0", new ResourceLocation(this.modid, "item/" + path));
    }

    private void blockItem(Block block) {
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)block);
        ((ItemModelBuilder)this.getBuilder(name.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(this.modid, "block/" + name.m_135815_())));
    }

    private void animatedModel(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            String path = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_() + "_" + String.format("%02d", i);
            ((ItemModelBuilder)this.withExistingParent(path, "item/generated")).texture("layer0", new ResourceLocation(this.modid, "item/" + path));
        }
    }
}

