/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.data.server.modifiers;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.DisplayInfoModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.ParentModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCBlockTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import com.teamabnormals.caverns_and_chasms.core.registry.CCMobEffects;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemInteractWithBlockTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CCAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] BREEDABLE_ANIMALS = new EntityType[0];
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)CCEntityTypes.DEEPER.get(), (EntityType)CCEntityTypes.MIME.get(), (EntityType)CCEntityTypes.PEEPER.get()};

    public CCAdvancementModifierProvider(DataGenerator dataGenerator) {
        super(dataGenerator, "caverns_and_chasms");
    }

    protected void registerEntries() {
        this.entry("story/lava_bucket").selects(new String[]{"story/lava_bucket"}).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("golden_lava_bucket", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)CCItems.GOLDEN_LAVA_BUCKET.get()})).addIndexedRequirements(0, false, new String[]{"golden_lava_bucket"}).build(), new ICondition[0]);
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_((MobEffect)CCMobEffects.REWIND.get())), new ICondition[0]);
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, MobEffectsPredicate.m_56552_().m_56553_((MobEffect)CCMobEffects.REWIND.get())), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        Collection items = CCItems.HELPER.getDeferredRegister().getEntries();
        items.forEach(item -> {
            if (((Item)item.get()).m_41472_()) {
                balancedDiet.addCriterion(ForgeRegistries.ITEMS.getKey((Object)((Item)item.get())).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)item.get())));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("husbandry/wax_on").selects(new String[]{"husbandry/wax_on"}).addModifier((ObjectModifier)DisplayInfoModifier.builder().description((Component)Component.m_237115_((String)("advancements." + this.modId + ".husbandry.wax_on.description"))).build(), new ICondition[0]).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("wax_on_blocks", (CriterionTriggerInstance)ItemInteractWithBlockTrigger.TriggerInstance.m_220065_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_204027_(CCBlockTags.WAXABLE_COPPER_BLOCKS).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)ButtonBlock.f_51045_, false).m_67706_()).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42784_}))).addCriterion("wax_on_golem", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42784_}), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)CCEntityTypes.COPPER_GOLEM.get()).m_36662_()))).addCriterion("wax_on_oxidized_golem", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42784_}), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)CCEntityTypes.OXIDIZED_COPPER_GOLEM.get()).m_36662_()))).addIndexedRequirements(0, false, new String[]{"wax_on_blocks", "wax_on_golem", "wax_on_oxidized_golem"}).build(), new ICondition[0]);
        this.entry("husbandry/wax_off").selects(new String[]{"husbandry/wax_off"}).addModifier((ObjectModifier)DisplayInfoModifier.builder().description((Component)Component.m_237115_((String)("advancements." + this.modId + ".husbandry.wax_off.description"))).build(), new ICondition[0]).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("wax_off_blocks", (CriterionTriggerInstance)ItemInteractWithBlockTrigger.TriggerInstance.m_220065_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_204027_(CCBlockTags.WAXED_COPPER_BLOCKS).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)ButtonBlock.f_51045_, false).m_67706_()).m_17931_()), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.TOOLS_AXES))).addCriterion("wax_off_golem", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.TOOLS_AXES), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)CCEntityTypes.COPPER_GOLEM.get()).m_36662_()))).addCriterion("wax_off_oxidized_golem", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_222015_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.TOOLS_AXES), (EntityPredicate.Composite)EntityPredicate.Composite.m_36673_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)CCEntityTypes.OXIDIZED_COPPER_GOLEM.get()).m_36662_()))).addIndexedRequirements(0, false, new String[]{"wax_off_blocks", "wax_off_golem", "wax_off_oxidized_golem"}).build(), new ICondition[0]);
        this.entry("husbandry/obtain_netherite_hoe").selects(new String[]{"husbandry/obtain_netherite_hoe"}).addModifier((ObjectModifier)DisplayInfoModifier.builder().description((Component)Component.m_237115_((String)("advancements." + this.modId + ".husbandry.netherite_hoe.description"))).build(), new ICondition[0]).addModifier((ObjectModifier)CriteriaModifier.builder((String)this.modId).addCriterion("necromium_hoe", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)CCItems.NECROMIUM_HOE.get()})).addIndexedRequirements(0, false, new String[]{"necromium_hoe"}).build(), new ICondition[0]);
        this.entry("adventure/smelt_copper_parent").selects(new String[]{"adventure/spyglass_at_parrot", "adventure/lightning_rod_with_villager_no_fire"}).addModifier((ObjectModifier)new ParentModifier(new ResourceLocation(this.modId, "adventure/smelt_copper")), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList names = Lists.newArrayList();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            String name = ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_();
            KilledTrigger.TriggerInstance triggerInstance = KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
            killAMob.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            killAllMobs.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            names.add(name);
        }
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
    }
}

