/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.other;

import com.teamabnormals.blueprint.core.api.BlueprintCauldronInteraction;
import com.teamabnormals.caverns_and_chasms.common.item.GoldenBucketItem;
import com.teamabnormals.caverns_and_chasms.core.registry.CCItems;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CCCauldronInteractions {
    public static final CauldronInteraction FILL_WATER = (state, level, pos, player, hand, stack) -> CCCauldronInteractions.emptyBucket(level, pos, player, hand, stack, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11778_, SoundEvents.f_11781_);
    public static final CauldronInteraction FILL_LAVA = (state, level, pos, player, hand, stack) -> CCCauldronInteractions.emptyBucket(level, pos, player, hand, stack, Blocks.f_152477_.m_49966_(), blockState -> true, SoundEvents.f_11780_, SoundEvents.f_11783_);
    public static final CauldronInteraction FILL_POWDER_SNOW = (state, level, pos, player, hand, stack) -> CCCauldronInteractions.emptyBucket(level, pos, player, hand, stack, (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144076_, SoundEvents.f_144089_);
    public static final CauldronInteraction FILL_MILK = (state, level, pos, player, hand, stack) -> CCCauldronInteractions.emptyBucket(level, pos, player, hand, stack, (BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("neapolitan", "milk_cauldron"))).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11778_, SoundEvents.f_11781_);
    public static final ResourceLocation MILK = new ResourceLocation("neapolitan", "milk");
    public static final ResourceLocation MILK_CAULDRON = new ResourceLocation("neapolitan", "milk_cauldron");

    public static void registerCauldronInteractions() {
        CauldronInteraction.f_175607_.put(Items.f_151058_, CauldronInteraction.f_175615_);
        CCCauldronInteractions.addFillBucketInteractions();
        BlueprintCauldronInteraction.addMoreDefaultInteractions((Item)((Item)CCItems.GOLDEN_LAVA_BUCKET.get()), (CauldronInteraction)FILL_LAVA);
        BlueprintCauldronInteraction.addMoreDefaultInteractions((Item)((Item)CCItems.GOLDEN_WATER_BUCKET.get()), (CauldronInteraction)FILL_WATER);
        BlueprintCauldronInteraction.addMoreDefaultInteractions((Item)((Item)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get()), (CauldronInteraction)FILL_POWDER_SNOW);
        if (ForgeRegistries.BLOCKS.containsKey(MILK_CAULDRON) && BlueprintCauldronInteraction.getTypeFromLocation((ResourceLocation)MILK) != null) {
            BlueprintCauldronInteraction.addMoreDefaultInteractions((Item)((Item)CCItems.GOLDEN_MILK_BUCKET.get()), (CauldronInteraction)FILL_MILK);
        }
    }

    private static void addFillBucketInteractions() {
        CauldronInteraction.f_175607_.put((Item)CCItems.GOLDEN_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)CCItems.GOLDEN_WATER_BUCKET.get()), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        CauldronInteraction.f_175608_.put((Item)CCItems.GOLDEN_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)CCItems.GOLDEN_LAVA_BUCKET.get()), blockState -> true, SoundEvents.f_11783_));
        CauldronInteraction.f_175609_.put((Item)CCItems.GOLDEN_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get()), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144089_));
        CauldronInteraction.f_175607_.put((Item)CCItems.GOLDEN_WATER_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillFilledBucket(state, level, pos, player, hand, stack, blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        CauldronInteraction.f_175608_.put((Item)CCItems.GOLDEN_LAVA_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillFilledBucket(state, level, pos, player, hand, stack, blockState -> true, SoundEvents.f_11783_));
        CauldronInteraction.f_175609_.put((Item)CCItems.GOLDEN_POWDER_SNOW_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillFilledBucket(state, level, pos, player, hand, stack, blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144089_));
        BlueprintCauldronInteraction milk = BlueprintCauldronInteraction.getTypeFromLocation((ResourceLocation)MILK);
        if (milk != null) {
            milk.map().put((Item)CCItems.GOLDEN_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillBucket(state, level, pos, player, hand, stack, new ItemStack((ItemLike)CCItems.GOLDEN_MILK_BUCKET.get()), blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
            milk.map().put((Item)CCItems.GOLDEN_MILK_BUCKET.get(), (state, level, pos, player, hand, stack) -> CCCauldronInteractions.fillFilledBucket(state, level, pos, player, hand, stack, blockState -> (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        }
    }

    public static InteractionResult fillBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack output, Predicate<BlockState> statePredicate, SoundEvent soundEvent) {
        if (!statePredicate.test(state)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)output));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult fillFilledBucket(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, Predicate<BlockState> statePredicate, SoundEvent soundEvent) {
        if (stack.m_41784_().m_128451_("FluidLevel") == 3 || !statePredicate.test(state)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, GoldenBucketItem.increaseFluidLevel(stack));
            player.m_36220_(Stats.f_12944_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, Blocks.f_50256_.m_49966_());
            level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult emptyBucket(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, Predicate<BlockState> statePredicate, SoundEvent soundEvent, SoundEvent fillSoundEvent) {
        if (state.equals(level.m_8055_(pos)) && stack.m_41784_().m_128451_("FluidLevel") < 2 && statePredicate.test(state)) {
            return CCCauldronInteractions.fillFilledBucket(state, level, pos, player, hand, stack, statePredicate, fillSoundEvent);
        }
        if (!level.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, GoldenBucketItem.getEmptySuccessItem(stack, player));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(pos, state);
            level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

