/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.other;

import com.teamabnormals.blueprint.common.world.storage.tracking.DataProcessors;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataProcessor;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CCDataProcessors {
    public static final IDataProcessor<Optional<UUID>> OPTIONAL_UUID = new IDataProcessor<Optional<UUID>>(){

        public CompoundTag write(Optional<UUID> optionalUUID) {
            CompoundTag compound = new CompoundTag();
            if (optionalUUID.isPresent()) {
                compound.m_128362_("OptionalUUID", optionalUUID.get());
            }
            return compound;
        }

        public Optional<UUID> read(CompoundTag nbt) {
            return nbt.m_128403_("OptionalUUID") ? Optional.of(nbt.m_128342_("OptionalUUID")) : Optional.empty();
        }
    };
    public static final IDataProcessor<Optional<BlockPos>> OPTIONAL_POS = new IDataProcessor<Optional<BlockPos>>(){

        public CompoundTag write(Optional<BlockPos> optionalPos) {
            CompoundTag compound = new CompoundTag();
            if (optionalPos.isPresent()) {
                compound.m_128356_("OptionalPos", optionalPos.get().m_121878_());
            }
            return compound;
        }

        public Optional<BlockPos> read(CompoundTag nbt) {
            try {
                return nbt.m_128425_("OptionalPos", 99) ? Optional.of(BlockPos.m_122022_((long)nbt.m_128454_("OptionalPos"))) : Optional.empty();
            }
            catch (ClassCastException classCastException) {
                return Optional.empty();
            }
        }
    };
    public static final TrackedData<Optional<UUID>> CONTROLLED_GOLEM_UUID = TrackedData.Builder.create(OPTIONAL_UUID, () -> Optional.empty()).build();
    public static final TrackedData<Boolean> IS_BEING_CONTROLLED = TrackedData.Builder.create((IDataProcessor)DataProcessors.BOOLEAN, () -> false).build();
    public static final TrackedData<Integer> FORGET_GOLEM_TIME = TrackedData.Builder.create((IDataProcessor)DataProcessors.INT, () -> 0).build();
    public static final TrackedData<Optional<BlockPos>> TUNING_FORK_POS = TrackedData.Builder.create(OPTIONAL_POS, () -> Optional.empty()).build();
    public static final TrackedData<Optional<UUID>> TUNING_FORK_TARGET_UUID = TrackedData.Builder.create(OPTIONAL_UUID, () -> Optional.empty()).build();
    public static final TrackedData<ResourceLocation> REWIND_DIMENSION = TrackedData.Builder.create((IDataProcessor)DataProcessors.RESOURCE_LOCATION, () -> Level.f_46428_.m_135782_()).enableSaving().build();
    public static final TrackedData<Double> REWIND_X = TrackedData.Builder.create((IDataProcessor)DataProcessors.DOUBLE, () -> 0.0).enableSaving().build();
    public static final TrackedData<Double> REWIND_Y = TrackedData.Builder.create((IDataProcessor)DataProcessors.DOUBLE, () -> 0.0).enableSaving().build();
    public static final TrackedData<Double> REWIND_Z = TrackedData.Builder.create((IDataProcessor)DataProcessors.DOUBLE, () -> 0.0).enableSaving().build();

    public static void registerTrackedData() {
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "controlled_golem_uuid"), CONTROLLED_GOLEM_UUID);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "is_being_controlled"), IS_BEING_CONTROLLED);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "forget_golem_time"), FORGET_GOLEM_TIME);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "tuning_fork_pos"), TUNING_FORK_POS);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "tuning_fork_target_uuid"), TUNING_FORK_TARGET_UUID);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "rewind_dimension"), REWIND_DIMENSION);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "rewind_x"), REWIND_X);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "rewind_y"), REWIND_Y);
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation("caverns_and_chasms", "rewind_z"), REWIND_Z);
    }
}

