/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.core.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamabnormals.caverns_and_chasms.common.levelgen.feature.OreWithDirtFeature;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlocks;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="caverns_and_chasms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"caverns_and_chasms");
    public static final RegistryObject<Feature<OreConfiguration>> ORE_WITH_DIRT = FEATURES.register("ore_with_dirt", () -> new OreWithDirtFeature((Codec<OreConfiguration>)OreConfiguration.f_67837_));

    public static final class CCPlacedFeatures {
        public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"caverns_and_chasms");
        private static final RegistryObject<PlacedFeature> ORE_GOLD_BURIED = CCPlacedFeatures.register("ore_gold_buried", CCConfiguredFeatures.ORE_GOLD_BURIED, List.of());
        private static final RegistryObject<PlacedFeature> ORE_SILVER_BURIED = CCPlacedFeatures.register("ore_silver_buried", CCConfiguredFeatures.ORE_SILVER_BURIED, List.of());
        public static final RegistryObject<PlacedFeature> ORE_SILVER_BURIED_WITH_GOLD = CCPlacedFeatures.register("ore_silver_buried_with_gold", CCConfiguredFeatures.ORE_SILVER_BURIED_WITH_GOLD, CCPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)32))));
        public static final RegistryObject<PlacedFeature> ORE_GOLD_BURIED_WITH_SILVER = CCPlacedFeatures.register("ore_gold_buried_with_silver", CCConfiguredFeatures.ORE_GOLD_BURIED_WITH_SILVER, CCPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)32))));
        public static final RegistryObject<PlacedFeature> ORE_GOLD_AND_SILVER_LOWER = CCPlacedFeatures.register("ore_gold_and_silver_lower", CCConfiguredFeatures.ORE_GOLD_AND_SILVER_BURIED, CCPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)0, (int)1)), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)-48))));
        public static final RegistryObject<PlacedFeature> ORE_SILVER_EXTRA = CCPlacedFeatures.register("ore_silver_extra", CCConfiguredFeatures.ORE_SILVER, CCPlacedFeatures.commonOrePlacement(50, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)32), (VerticalAnchor)VerticalAnchor.m_158922_((int)256))));
        public static final RegistryObject<PlacedFeature> ORE_SILVER_SOUL = CCPlacedFeatures.register("ore_silver_soul", CCConfiguredFeatures.ORE_SOUL_SILVER, CCPlacedFeatures.commonOrePlacement(45, PlacementUtils.f_195357_));
        public static final RegistryObject<PlacedFeature> ORE_SPINEL = CCPlacedFeatures.register("ore_spinel", CCConfiguredFeatures.ORE_SPINEL, CCPlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-32), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        public static final RegistryObject<PlacedFeature> ORE_SPINEL_BURIED = CCPlacedFeatures.register("ore_spinel_buried", CCConfiguredFeatures.ORE_SPINEL_BURIED, CCPlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16), (VerticalAnchor)VerticalAnchor.m_158922_((int)48))));
        public static final RegistryObject<PlacedFeature> ORE_ROCKY_DIRT = CCPlacedFeatures.register("ore_rocky_dirt", CCConfiguredFeatures.ORE_ROCKY_DIRT, CCPlacedFeatures.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)160))));
        public static final RegistryObject<PlacedFeature> ORE_FRAGILE_STONE = CCPlacedFeatures.register("ore_fragile_stone", CCConfiguredFeatures.ORE_FRAGILE_STONE, CCPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));
        public static final RegistryObject<PlacedFeature> ORE_FRAGILE_STONE_BURIED = CCPlacedFeatures.register("ore_fragile_stone_buried", CCConfiguredFeatures.ORE_FRAGILE_STONE_BURIED, CCPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)64))));

        private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
            return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
        }

        private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
            return CCPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), modifier);
        }

        private static RegistryObject<PlacedFeature> register(String name, RegistryObject<? extends ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
            return PLACED_FEATURES.register(name, () -> new PlacedFeature((Holder)feature.getHolder().get(), (List)ImmutableList.copyOf((Collection)placementModifiers)));
        }
    }

    public static final class CCConfiguredFeatures {
        public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"caverns_and_chasms");
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_GOLD_BURIED = CCConfiguredFeatures.register("ore_gold_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(OreFeatures.f_195077_, 9, 0.5f)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_SILVER = CCConfiguredFeatures.register("ore_silver", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CCConfiguredFeatures.getOreSilverTargetList(), 9)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_SILVER_BURIED = CCConfiguredFeatures.register("ore_silver_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CCConfiguredFeatures.getOreSilverTargetList(), 9, 0.5f)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_SOUL_SILVER = CCConfiguredFeatures.register("ore_soul_silver", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13071_), ((Block)CCBlocks.SOUL_SILVER_ORE.get()).m_49966_(), 17, 1.0f)));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> ORE_SILVER_BURIED_WITH_GOLD = CCConfiguredFeatures.register("ore_silver_buried_with_gold", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(CCConfiguredFeatures.weighted(CCPlacedFeatures.ORE_SILVER_BURIED, 0.8f)), (Holder)CCPlacedFeatures.ORE_GOLD_BURIED.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> ORE_GOLD_BURIED_WITH_SILVER = CCConfiguredFeatures.register("ore_gold_buried_with_silver", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(CCConfiguredFeatures.weighted(CCPlacedFeatures.ORE_GOLD_BURIED, 0.8f)), (Holder)CCPlacedFeatures.ORE_SILVER_BURIED.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<RandomFeatureConfiguration, ?>> ORE_GOLD_AND_SILVER_BURIED = CCConfiguredFeatures.register("ore_gold_and_silver_buried", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(CCConfiguredFeatures.weighted(CCPlacedFeatures.ORE_SILVER_BURIED, 0.5f)), (Holder)CCPlacedFeatures.ORE_GOLD_BURIED.getHolder().get())));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_SPINEL = CCConfiguredFeatures.register("ore_spinel", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CCConfiguredFeatures.getOreSpinelTargetList(), 6)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_SPINEL_BURIED = CCConfiguredFeatures.register("ore_spinel_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(CCConfiguredFeatures.getOreSpinelTargetList(), 12, 0.5f)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_ROCKY_DIRT = CCConfiguredFeatures.register("ore_rocky_dirt", () -> new ConfiguredFeature((Feature)ORE_WITH_DIRT.get(), (FeatureConfiguration)new OreConfiguration(OreFeatures.f_195071_, ((Block)CCBlocks.ROCKY_DIRT.get()).m_49966_(), 33)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_FRAGILE_STONE = CCConfiguredFeatures.register("ore_fragile_stone", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)CCBlocks.FRAGILE_STONE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)CCBlocks.FRAGILE_DEEPSLATE.get()).m_49966_())), 48, 0.1f)));
        public static final RegistryObject<ConfiguredFeature<OreConfiguration, ?>> ORE_FRAGILE_STONE_BURIED = CCConfiguredFeatures.register("ore_fragile_stone_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)CCBlocks.FRAGILE_STONE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)CCBlocks.FRAGILE_DEEPSLATE.get()).m_49966_())), 48, 1.0f)));
        public static final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> AZALEA_TREE = CCConfiguredFeatures.register("azalea_tree", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)CCBlocks.AZALEA_LOG.get())), (TrunkPlacer)new BendingTrunkPlacer(4, 2, 0, 3, (IntProvider)UniformInt.m_146622_((int)1, (int)2)), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_152470_.m_49966_(), 3).m_146271_((Object)Blocks.f_152471_.m_49966_(), 1)), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 50), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152549_)).m_161262_().m_68251_()));

        private static WeightedPlacedFeature weighted(RegistryObject<PlacedFeature> feature, float weight) {
            return new WeightedPlacedFeature((Holder)feature.getHolder().get(), weight);
        }

        private static List<OreConfiguration.TargetBlockState> getOreSilverTargetList() {
            return List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)CCBlocks.SILVER_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)CCBlocks.DEEPSLATE_SILVER_ORE.get()).m_49966_()));
        }

        private static List<OreConfiguration.TargetBlockState> getOreSpinelTargetList() {
            return List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)CCBlocks.SPINEL_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)CCBlocks.DEEPSLATE_SPINEL_ORE.get()).m_49966_()));
        }

        private static <FC extends FeatureConfiguration, F extends Feature<FC>> RegistryObject<ConfiguredFeature<FC, ?>> register(String name, Supplier<ConfiguredFeature<FC, F>> feature) {
            return CONFIGURED_FEATURES.register(name, feature);
        }
    }
}

