/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableInt;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;

public class AnimationClip {
    public static final AnimationClip EMPTY_CLIP = new AnimationClip();
    protected Map<String, TransformSheet> jointTransforms = new HashMap<String, TransformSheet>();
    protected float clipTime;
    protected float[] bakedTimes;

    public void addJointTransform(String jointName, TransformSheet sheet) {
        this.jointTransforms.put(jointName, sheet);
        this.bakedTimes = null;
    }

    public boolean hasJointTransform(String jointName) {
        return this.jointTransforms.containsKey(jointName);
    }

    public void bakeKeyframes() {
        HashSet timestamps = new HashSet();
        this.jointTransforms.values().forEach(transformSheet -> transformSheet.forEach((i, keyframe) -> timestamps.add(Float.valueOf(keyframe.time()))));
        float[] bakedTimestamps = new float[timestamps.size()];
        MutableInt mi = new MutableInt(0);
        timestamps.stream().sorted().toList().forEach(f -> {
            bakedTimestamps[mi.getAndAdd((int)1)] = f.floatValue();
        });
        HashMap<String, TransformSheet> bakedJointTransforms = new HashMap<String, TransformSheet>();
        this.jointTransforms.forEach((jointName, transformSheet) -> bakedJointTransforms.put((String)jointName, transformSheet.createInterpolated(bakedTimestamps)));
        this.jointTransforms = bakedJointTransforms;
        this.bakedTimes = bakedTimestamps;
    }

    public void setBaked() {
        TransformSheet transformSheet = this.jointTransforms.get("Root");
        if (transformSheet != null) {
            this.bakedTimes = new float[transformSheet.getKeyframes().length];
            for (int i = 0; i < transformSheet.getKeyframes().length; ++i) {
                this.bakedTimes[i] = transformSheet.getKeyframes()[i].time();
            }
        }
    }

    public TransformSheet getJointTransform(String jointName) {
        return this.jointTransforms.get(jointName);
    }

    public final Pose getPoseInTime(float time) {
        Pose pose = new Pose();
        if (this.bakedTimes != null && this.bakedTimes.length > 0) {
            int begin = 0;
            int end = this.bakedTimes.length - 1;
            while (end - begin > 1) {
                int i = begin + (end - begin) / 2;
                if (this.bakedTimes[i] <= time && this.bakedTimes[i + 1] > time) {
                    begin = i;
                    end = i + 1;
                    break;
                }
                if (this.bakedTimes[i] > time) {
                    end = i;
                    continue;
                }
                if (!(this.bakedTimes[i + 1] <= time)) continue;
                begin = i;
            }
            float delta = Mth.clamp((float)((time - this.bakedTimes[begin]) / (this.bakedTimes[end] - this.bakedTimes[begin])), (float)0.0f, (float)1.0f);
            TransformSheet.InterpolationInfo iInfo = new TransformSheet.InterpolationInfo(begin, end, delta);
            for (String jointName : this.jointTransforms.keySet()) {
                pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(iInfo));
            }
        } else {
            for (String jointName : this.jointTransforms.keySet()) {
                pose.putJointData(jointName, this.jointTransforms.get(jointName).getInterpolatedTransform(time));
            }
        }
        return pose;
    }

    public Map<String, TransformSheet> getJointTransforms() {
        return Collections.unmodifiableMap(this.jointTransforms);
    }

    public void reset() {
        this.jointTransforms.clear();
        this.bakedTimes = null;
    }

    public void setClipTime(float clipTime) {
        this.clipTime = clipTime;
    }

    public float getClipTime() {
        return this.clipTime;
    }
}

