/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import yesman.epicfight.api.animation.JointTransform;

public class Pose {
    public static final Pose EMPTY_POSE = new Pose();
    protected final Map<String, JointTransform> jointTransformData;

    public static Pose interpolatePose(Pose pose1, Pose pose2, float pregression) {
        Pose pose = new Pose();
        HashSet<String> mergedSet = new HashSet<String>(pose1.jointTransformData.keySet());
        mergedSet.addAll(pose2.jointTransformData.keySet());
        for (String jointName : mergedSet) {
            pose.putJointData(jointName, JointTransform.interpolate(pose1.orElseEmpty(jointName), pose2.orElseEmpty(jointName), pregression));
        }
        return pose;
    }

    public Pose() {
        this(Maps.newHashMap());
    }

    public Pose(Map<String, JointTransform> jointTransforms) {
        this.jointTransformData = jointTransforms;
    }

    public void putJointData(String name, JointTransform transform) {
        this.jointTransformData.put(name, transform);
    }

    public Map<String, JointTransform> getJointTransformData() {
        return this.jointTransformData;
    }

    public void disableJoint(com.google.common.base.Predicate<? super Map.Entry<String, JointTransform>> predicate) {
        this.jointTransformData.entrySet().removeIf((Predicate<Map.Entry<String, JointTransform>>)predicate);
    }

    public void disableAllJoints() {
        this.jointTransformData.clear();
    }

    public boolean hasTransform(String jointName) {
        return this.jointTransformData.containsKey(jointName);
    }

    public JointTransform get(String jointName) {
        return this.jointTransformData.get(jointName);
    }

    public JointTransform orElseEmpty(String jointName) {
        return this.jointTransformData.getOrDefault(jointName, JointTransform.empty());
    }

    public JointTransform orElse(String jointName, JointTransform orElse) {
        return this.jointTransformData.getOrDefault(jointName, orElse);
    }

    public void forEachEnabledTransforms(BiConsumer<String, JointTransform> task) {
        this.jointTransformData.forEach(task);
    }

    public void load(Pose pose, LoadOperation operation) {
        switch (operation.ordinal()) {
            case 0: {
                this.disableAllJoints();
                pose.forEachEnabledTransforms(this::putJointData);
                break;
            }
            case 1: {
                pose.forEachEnabledTransforms(this::putJointData);
                break;
            }
            case 2: {
                pose.forEachEnabledTransforms((name, transform) -> {
                    if (!this.hasTransform((String)name)) {
                        this.putJointData((String)name, (JointTransform)transform);
                    }
                });
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pose: ");
        for (Map.Entry<String, JointTransform> entry : this.jointTransformData.entrySet()) {
            sb.append(String.format("%s{%s, %s}, ", entry.getKey(), entry.getValue().translation().toString(), entry.getValue().rotation().toString()) + "\n");
        }
        return sb.toString();
    }

    public static enum LoadOperation {
        SET,
        OVERWRITE,
        APPEND_ABSENT;

    }
}

