/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class ControlEngine
implements IEventBasedEngine {
    private static final ControlEngine INSTANCE = new ControlEngine();
    private final Set<CustomPacketPayload> packetsToSend = new HashSet<CustomPacketPayload>();
    private final Minecraft minecraft = Minecraft.getInstance();
    private LocalPlayer player;
    private LocalPlayerPatch playerpatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int tickSinceLastJump = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean holdingFinished;
    private int reserveCounter;
    private KeyMapping reservedKey;
    private SkillSlot reservedOrHoldingSkillSlot;
    private KeyMapping currentHoldingKey;
    public Options options;

    public static ControlEngine getInstance() {
        return INSTANCE;
    }

    private ControlEngine() {
        if (this.minecraft != null) {
            this.options = this.minecraft.options;
        }
    }

    public void reloadPlayerPatch(LocalPlayerPatch playerpatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerpatch.getOriginal();
        this.playerpatch = playerpatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerpatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.jumpableVehicle() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.jumpableVehicle() != null;
    }

    public void handleEpicFightKeyMappings() {
        SkillContainer container;
        Object skillCastEvent;
        SkillContainer skill;
        if (this.playerpatch == null) {
            return;
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.SKILL_EDIT, false) && this.playerpatch.getPlayerSkills() != null) {
            Minecraft.getInstance().setScreen((Screen)new SkillEditScreen((Player)this.player, this.playerpatch.getPlayerSkills()));
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.OPEN_CONFIG_SCREEN, false)) {
            Minecraft.getInstance().setScreen((Screen)new IngameConfigurationScreen(null, null));
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING, false)) {
            boolean flag = ClientEngine.getInstance().switchVanillaModelDebuggingMode();
            this.minecraft.keyboardHandler.debugFeedbackTranslated(flag ? "debug.vanilla_model_debugging.on" : "debug.vanilla_model_debugging.off", new Object[0]);
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.ATTACK, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.ATTACK) continue;
            boolean shouldPlayAttackAnimation = this.playerpatch.canPlayAttackAnimation();
            if (this.options.keyAttack.getKey() == EpicFightKeyMappings.ATTACK.getKey() && this.minecraft.hitResult != null && shouldPlayAttackAnimation) {
                ControlEngine.makeUnpressed(this.options.keyAttack);
            }
            if (!shouldPlayAttackAnimation) continue;
            if (!EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
                SkillContainer airSlash = this.playerpatch.getSkill(SkillSlots.AIR_SLASH);
                SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_SLASH : SkillSlots.COMBO_ATTACKS;
                SkillCastEvent skillCastEvent2 = this.playerpatch.getSkill(slot).sendCastRequest(this.playerpatch, this);
                if (skillCastEvent2.isExecutable()) {
                    this.player.resetAttackStrengthTicker();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.isSpectator() && slot == SkillSlots.COMBO_ATTACKS) {
                    this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
                continue;
            }
            if (this.weaponInnatePressToggle) continue;
            this.weaponInnatePressToggle = true;
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.DODGE, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.DODGE) continue;
            if (EpicFightKeyMappings.DODGE.getKey().getValue() == this.options.keyShift.getKey().getValue()) {
                if (this.player.getVehicle() != null || this.sneakPressToggle) continue;
                this.sneakPressToggle = true;
                continue;
            }
            SkillSlots skillCategory = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            skill = this.playerpatch.getSkill(skillCategory);
            if (skill.isEmpty() || !skill.sendCastRequest(this.playerpatch, this).shouldReserveKey()) continue;
            this.reserveKey(SkillSlots.DODGE, EpicFightKeyMappings.DODGE);
        }
        if (ControlEngine.isKeyDown(EpicFightKeyMappings.GUARD) && this.playerpatch.isEpicFightMode() && this.currentHoldingKey != EpicFightKeyMappings.GUARD && !this.playerpatch.isHoldingAny()) {
            boolean hasUseAction = false;
            if (EpicFightKeyMappings.GUARD.getKey().equals((Object)this.options.keyUse.getKey()) && this.player.getMainHandItem().getUseAnimation() != UseAnim.NONE) {
                hasUseAction = true;
            }
            if (!hasUseAction) {
                SkillCastEvent skillCastEvent3 = this.playerpatch.getSkill(SkillSlots.GUARD).sendCastRequest(this.playerpatch, this);
                if (skillCastEvent3.shouldReserveKey()) {
                    if (!this.player.isSpectator()) {
                        this.reserveKey(SkillSlots.GUARD, EpicFightKeyMappings.GUARD);
                    }
                } else {
                    this.lockHotkeys();
                }
            }
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.WEAPON_INNATE_SKILL, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.WEAPON_INNATE_SKILL || EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) continue;
            if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                if (this.player.isSpectator()) continue;
                this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                continue;
            }
            this.lockHotkeys();
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.MOVER_SKILL, true)) {
            if (!this.playerpatch.isEpicFightMode() || this.playerpatch.isHoldingAny()) continue;
            if (EpicFightKeyMappings.MOVER_SKILL.getKey().getValue() == this.options.keyJump.getKey().getValue()) {
                SkillCastEvent event;
                SkillContainer skillContainer = this.playerpatch.getSkill(SkillSlots.MOVER);
                if (!skillContainer.canUse(this.playerpatch, event = new SkillCastEvent(this.playerpatch, skillContainer, null)) || this.player.getVehicle() != null || this.moverPressToggle) continue;
                this.moverPressToggle = true;
                continue;
            }
            SkillContainer skill2 = this.playerpatch.getSkill(SkillSlots.MOVER);
            skill2.sendCastRequest(this.playerpatch, this);
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_MODE, false)) {
            if (EpicFightGameRules.CAN_SWITCH_PLAYER_MODE.getRuleValue(((LocalPlayer)this.playerpatch.getOriginal()).level()).booleanValue()) {
                this.playerpatch.toggleMode();
                continue;
            }
            this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"epicfight.messages.mode_switching_disabled").withStyle(ChatFormatting.RED));
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.LOCK_ON, false)) {
            this.playerpatch.toggleLockOn();
        }
        if (this.playerpatch.getEntityState().inaction() || !this.playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            ControlEngine.makeUnpressed(this.minecraft.options.keySwapOffhand);
        }
        if (!this.playerpatch.isEpicFightMode() || Minecraft.getInstance().isPaused()) {
            return;
        }
        if (this.player.tickCount - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!ControlEngine.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().equals((Object)EpicFightKeyMappings.ATTACK.getKey())) {
                if (this.weaponInnatePressCounter > ClientConfig.longPressCounter) {
                    if (this.playerpatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                        if (!this.player.isSpectator()) {
                            this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillContainer airSlash = this.playerpatch.getSkill(SkillSlots.AIR_SLASH);
            SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_SLASH : SkillSlots.COMBO_ATTACKS;
            skillCastEvent = this.playerpatch.getSkill(slot).sendCastRequest(this.playerpatch, this);
            if (skillCastEvent.isExecutable()) {
                this.player.resetAttackStrengthTicker();
                this.releaseAllServedKeys();
            } else if (!this.player.isSpectator() && slot == SkillSlots.COMBO_ATTACKS) {
                this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!ControlEngine.isKeyDown(this.options.keyShift)) {
                SkillSlots skillSlot = this.playerpatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                skill = this.playerpatch.getSkill(skillSlot);
                if (skill.sendCastRequest(this.playerpatch, this).shouldReserveKey()) {
                    this.reserveKey(skillSlot, this.options.keyShift);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ClientConfig.longPressCounter) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentHoldingKey != null && !(container = this.playerpatch.getSkill(this.reservedOrHoldingSkillSlot)).isEmpty()) {
            if (container.getSkill() instanceof HoldableSkill) {
                if (!ControlEngine.isKeyDown(this.currentHoldingKey)) {
                    this.holdingFinished = true;
                }
                if ((skillCastEvent = container.getSkill()) instanceof ChargeableSkill) {
                    ChargeableSkill chargingSkill = (ChargeableSkill)skillCastEvent;
                    if (this.holdingFinished) {
                        if (this.playerpatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                            container.sendCastRequest(this.playerpatch, this);
                            this.releaseAllServedKeys();
                        }
                    } else if (this.playerpatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                        this.releaseAllServedKeys();
                    }
                } else if (this.holdingFinished) {
                    this.playerpatch.resetHolding();
                    CompoundTag arguments = new CompoundTag();
                    container.getSkill().gatherArguments(container, this, arguments);
                    container.getSkill().cancelOnClient(container, arguments);
                    container.sendCancelRequest(this.playerpatch, this);
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                SkillContainer skill3 = this.playerpatch.getSkill(this.reservedOrHoldingSkillSlot);
                --this.reserveCounter;
                if (skill3.getSkill() != null && skill3.sendCastRequest(this.playerpatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (!this.playerpatch.getEntityState().canSwitchHoldingItem() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.keyHotbarSlots[i].consumeClick()) {
                }
            }
            while (this.options.keyDrop.consumeClick()) {
            }
        }
    }

    private void inputTick(Input input) {
        if (this.moverPressToggle) {
            if (!ControlEngine.isKeyDown(this.options.keyJump)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.onGround()) {
                    this.player.noJumpDelay = 0;
                    input.jumping = true;
                }
            } else if (this.moverPressCounter > ClientConfig.longPressCounter) {
                SkillContainer skill = this.playerpatch.getSkill(SkillSlots.MOVER);
                skill.sendCastRequest(this.playerpatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                this.player.noJumpDelay = 2;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerpatch.getEntityState())) {
            input.forwardImpulse = 0.0f;
            input.leftImpulse = 0.0f;
            input.up = false;
            input.down = false;
            input.left = false;
            input.right = false;
            input.jumping = false;
            input.shiftKeyDown = false;
            this.player.sprintTriggerTime = -1;
            this.player.setSprinting(false);
        }
        if (this.tickSinceLastJump > 0) {
            --this.tickSinceLastJump;
        }
    }

    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrHoldingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    public void releaseAllServedKeys() {
        this.holdingFinished = true;
        this.currentHoldingKey = null;
        this.reservedOrHoldingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setHoldingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.holdingFinished = false;
        this.currentHoldingKey = keyMapping;
        this.reservedOrHoldingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.tickCount;
        for (int i = 0; i < 9; ++i) {
            while (this.options.keyHotbarSlots[i].consumeClick()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(CustomPacketPayload packet) {
        this.packetsToSend.add(packet);
    }

    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().getType() == InputConstants.Type.KEYSYM) {
            return key.isDown() || GLFW.glfwGetKey((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getKey().getValue()) > 0;
        }
        if (key.getKey().getType() == InputConstants.Type.MOUSE) {
            return key.isDown() || GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getKey().getValue()) > 0;
        }
        return false;
    }

    private static boolean isKeyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.consumeClick();
        if (consumes && eventCheck && (inputEvent = ClientHooks.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().getType() ? key.getKey().getValue() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    public static void makeUnpressed(KeyMapping keyMapping) {
        while (keyMapping.consumeClick()) {
        }
        ControlEngine.setKeyBind(keyMapping, false);
    }

    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.set((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public boolean moverToggling() {
        return this.moverPressToggle;
    }

    public boolean sneakToggling() {
        return this.sneakPressToggle;
    }

    public boolean attackToggling() {
        return this.attackLightPressToggle;
    }

    public boolean weaponInnateToggling() {
        return this.weaponInnatePressToggle;
    }

    private void epicfight$mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
        if (this.player != null && this.playerpatch != null && !this.playerpatch.getEntityState().canSwitchHoldingItem() && this.minecraft.screen == null) {
            event.setCanceled(true);
        }
    }

    private void epicfight$moveInputEvent(MovementInputUpdateEvent event) {
        if (this.playerpatch == null) {
            return;
        }
        this.inputTick(event.getInput());
        this.playerpatch.getPlayerSkills().fireSkillEvents("epicfight", event);
    }

    private void epicfight$clientTickEndEvent(ClientTickEvent.Post event) {
        if (this.player == null) {
            return;
        }
        this.packetsToSend.forEach(x$0 -> EpicFightNetworkManager.sendToServer(x$0, new CustomPacketPayload[0]));
        this.packetsToSend.clear();
    }

    private void epicfight$interactionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (this.player == null) {
            return;
        }
        if (event.getKeyMapping() == this.minecraft.options.keyAttack && EpicFightKeyMappings.ATTACK.getKey() == this.minecraft.options.keyAttack.getKey() && this.minecraft.hitResult.getType() == HitResult.Type.BLOCK && ClientConfig.combatPreferredItems.contains(this.player.getMainHandItem().getItem())) {
            BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
            BlockState bs = this.minecraft.level.getBlockState(bp);
            if (!this.player.getMainHandItem().getItem().canAttackBlock(bs, this.player.level(), bp, (Player)this.player) || this.player.getMainHandItem().getDestroySpeed(bs) <= 1.0f) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }
    }

    private void epicfight$livingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() == this.player) {
            this.tickSinceLastJump = 5;
        }
    }

    @Override
    public void gameEventBus(IEventBus forgeEventBus) {
        forgeEventBus.addListener(this::epicfight$mouseScrollEvent);
        forgeEventBus.addListener(this::epicfight$moveInputEvent);
        forgeEventBus.addListener(this::epicfight$clientTickEndEvent);
        forgeEventBus.addListener(this::epicfight$interactionKeyMappingTriggered);
        forgeEventBus.addListener(this::epicfight$livingJumpEvent);
    }

    @Override
    public void modEventBus(IEventBus modEventBus) {
    }
}

