/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.HitAnimation;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.DatapackAnimation;
import yesman.epicfight.api.animation.types.datapack.EditorAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.asset.SelfAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.InstantiateInvoker;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.CombatBehaviorScreen;
import yesman.epicfight.client.gui.datapack.screen.HumanoidCombatBehaviorScreen;
import yesman.epicfight.client.gui.datapack.screen.HumanoidWeaponMotionScreen;
import yesman.epicfight.client.gui.datapack.screen.LivingAnimationsScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.OffhandValidatorScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen;
import yesman.epicfight.client.gui.datapack.screen.StylesScreen;
import yesman.epicfight.client.gui.datapack.screen.WeaponAttributeScreen;
import yesman.epicfight.client.gui.datapack.screen.WeaponComboScreen;
import yesman.epicfight.client.gui.datapack.widgets.CheckBox;
import yesman.epicfight.client.gui.datapack.widgets.ColorPreviewWidget;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.InputComponentList;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.client.gui.datapack.widgets.SubScreenOpenButton;
import yesman.epicfight.client.gui.datapack.widgets.TickableComponent;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.damagesource.StunType;

@OnlyIn(value=Dist.CLIENT)
public class DatapackEditScreen
extends Screen {
    public static final Component GUI_EXPORT = Component.translatable((String)"gui.epicfight.export");
    private static DatapackEditScreen workingPackScreen;
    private GridLayout bottomButtons;
    private TabNavigationBar tabNavigationBar;
    private final Screen parentScreen;
    private final WeaponTypeTab weaponTypeTab;
    private final ItemCapabilityTab itemCapabilityTab;
    private final MobCapabilityTab mobCapabilityTab;
    private final Map<ResourceLocation, PackEntry<EditorAnimation, DatapackAnimation<? extends StaticAnimation>>> userAnimations = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, AssetAccessor<? extends SkinnedMesh>> userMeshes = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, AssetAccessor<? extends Armature>> userArmatures = Maps.newLinkedHashMap();
    private final Map<ResourceLocation, Function<Item, ? extends CapabilityItem.Builder<?>>> userWeaponTypes = Maps.newLinkedHashMap();
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
    }, p_267853_ -> this.removeWidget((GuiEventListener)p_267853_)){

        public void setCurrentTab(Tab tab, boolean playSound) {
            DatapackTab datapackTab;
            Tab tab2 = this.getCurrentTab();
            if (tab2 instanceof DatapackTab) {
                datapackTab = (DatapackTab)tab2;
                DatapackEditScreen.this.removeWidget(datapackTab.packListGrid);
                DatapackEditScreen.this.removeWidget(datapackTab.inputComponentsList);
            }
            super.setCurrentTab(tab, playSound);
            if (tab instanceof DatapackTab) {
                datapackTab = (DatapackTab)tab;
                DatapackEditScreen.this.addRenderableWidget(datapackTab.packListGrid);
                DatapackEditScreen.this.addRenderableWidget(datapackTab.inputComponentsList);
            }
        }
    };

    public static DatapackEditScreen getCurrentScreen() {
        return workingPackScreen;
    }

    public static boolean hasEditingScreen() {
        return workingPackScreen != null;
    }

    public static AssetAccessor<? extends StaticAnimation> animationByKey(String path) {
        ResourceLocation rl = ResourceLocation.parse((String)path);
        if (DatapackEditScreen.workingPackScreen.userAnimations.containsKey(rl)) {
            return DatapackEditScreen.workingPackScreen.userAnimations.get(rl).getValue();
        }
        return AnimationManager.byKey(rl);
    }

    public static AssetAccessor<? extends SkinnedMesh> getMesh(String path) {
        ResourceLocation rl = ResourceLocation.parse((String)path);
        if (workingPackScreen != null && DatapackEditScreen.workingPackScreen.userMeshes.containsKey(rl)) {
            return DatapackEditScreen.workingPackScreen.userMeshes.get(rl);
        }
        return Meshes.get(rl);
    }

    public static AssetAccessor<? extends Armature> getArmature(String path) {
        ResourceLocation rl = ResourceLocation.parse((String)path);
        if (workingPackScreen != null && DatapackEditScreen.workingPackScreen.userArmatures.containsKey(rl)) {
            return DatapackEditScreen.workingPackScreen.userArmatures.get(rl);
        }
        return Armatures.get(rl);
    }

    public static Function<Item, ? extends CapabilityItem.Builder<?>> getWeaponType(String typeName) {
        ResourceLocation typeId = ResourceLocation.parse((String)typeName);
        if (DatapackEditScreen.workingPackScreen.userWeaponTypes.containsKey(typeId)) {
            return DatapackEditScreen.workingPackScreen.userWeaponTypes.get(typeId);
        }
        return WeaponTypeReloadListener.get(typeName);
    }

    public static Set<Map.Entry<ResourceLocation, Function<Item, ? extends CapabilityItem.Builder<?>>>> getSerializableWeaponTypes() {
        return DatapackEditScreen.workingPackScreen.weaponTypeTab.packList.stream().reduce(Sets.newHashSet(), (set, entry) -> {
            try {
                WeaponCapability.Builder builder = WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder((ResourceLocation)entry.getKey(), (CompoundTag)entry.getValue());
                Function<Item, CapabilityItem.Builder> provider = itemstack -> builder;
                if (!DatapackEditScreen.workingPackScreen.userWeaponTypes.containsKey(entry.getKey())) {
                    DatapackEditScreen.workingPackScreen.userWeaponTypes.put((ResourceLocation)entry.getKey(), provider);
                }
                set.add(PackEntry.ofValue((ResourceLocation)entry.getKey(), provider));
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.error("Can not deserialize weapon type " + String.valueOf(entry.getKey()));
                return set;
            }
            return set;
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        });
    }

    public DatapackEditScreen(Screen parentScreen) {
        super((Component)Component.translatable((String)"gui.epicfight.datapack_edit"));
        this.parentScreen = parentScreen;
        this.minecraft = parentScreen.getMinecraft();
        this.font = parentScreen.getMinecraft().font;
        this.weaponTypeTab = new WeaponTypeTab();
        this.itemCapabilityTab = new ItemCapabilityTab();
        this.mobCapabilityTab = new MobCapabilityTab();
        if (workingPackScreen == null) {
            workingPackScreen = this;
        }
    }

    public boolean importDataPack(Path path) {
        FolderRepositorySource.FolderPackDetector packDetector = new FolderRepositorySource.FolderPackDetector(new DirectoryValidator(path$2 -> true));
        Pack.ResourcesSupplier pack$resourcessupplier = null;
        try {
            pack$resourcessupplier = (Pack.ResourcesSupplier)packDetector.detectPackResources(path, new ArrayList());
        }
        catch (IOException e) {
            this.minecraft.setScreen(new MessageScreen("Invalid datapack", e.getMessage(), this, button2 -> this.minecraft.setScreen((Screen)this), 160, 60));
        }
        if (pack$resourcessupplier != null) {
            String s = path.getFileName().toString();
            PackLocationInfo packlocationinfo = new PackLocationInfo("file/" + s, (Component)Component.literal((String)s), PackSource.WORLD, Optional.empty());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packlocationinfo, (Pack.ResourcesSupplier)pack$resourcessupplier, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)FolderRepositorySource.DISCOVERED_PACK_SELECTION_CONFIG);
            PackResources packResources = pack.open();
            this.importUserData(packResources);
            this.weaponTypeTab.importEntries(packResources);
            this.itemCapabilityTab.importEntries(packResources);
            this.mobCapabilityTab.importEntries(packResources);
            packResources.close();
            return true;
        }
        this.minecraft.setScreen(new MessageScreen("Invalid datapack", "", this, button2 -> this.minecraft.setScreen((Screen)this), 160, 60));
        return false;
    }

    public boolean exportDataPack(String packName) {
        ZipOutputStream out = null;
        File zipFile = null;
        try {
            File resourcePackDirectory = Minecraft.getInstance().getResourcePackDirectory().toFile();
            zipFile = new File(resourcePackDirectory, packName + ".zip");
            int duplicateCount = 1;
            while (zipFile.exists()) {
                zipFile = new File(resourcePackDirectory, packName + String.format(" (%d).zip", duplicateCount));
                ++duplicateCount;
            }
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            this.weaponTypeTab.exportEntries(out);
            this.itemCapabilityTab.exportEntries(out);
            this.mobCapabilityTab.exportEntries(out);
            this.exportUserData(out);
            ZipEntry zipEntry = new ZipEntry("pack.mcmeta");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject root = new JsonObject();
            JsonObject pack = new JsonObject();
            int datapackVersion = SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA);
            int resourcepackVersion = SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES);
            if (datapackVersion != resourcepackVersion) {
                EpicFightMod.LOGGER.warn("Pack version is not matching in " + SharedConstants.getCurrentVersion().getId());
            }
            pack.addProperty("description", packName);
            pack.addProperty("pack_format", (Number)datapackVersion);
            root.add("pack", (JsonElement)pack);
            out.putNextEntry(zipEntry);
            out.write(gson.toJson((JsonElement)root).getBytes());
            out.closeEntry();
            out.close();
            Util.getPlatform().openFile(resourcePackDirectory);
            return true;
        }
        catch (Exception e) {
            this.minecraft.setScreen(new MessageScreen("Failed to export datapack", e.getMessage(), this, button2 -> this.minecraft.setScreen((Screen)this), 400, 110).autoCalculateHeight());
            e.printStackTrace();
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            zipFile.delete();
            return false;
        }
    }

    public void onFilesDrop(List<Path> filePath) {
        boolean isJsonFiles = true;
        for (Path path : filePath) {
            isJsonFiles &= path.getFileName().toString().indexOf(".json") > -1;
        }
        if (isJsonFiles) {
            this.minecraft.setScreen(new MessageScreen<String>("", "Enter the mod id", this, modid -> {
                StringBuilder sb = new StringBuilder();
                boolean hasException = false;
                for (Path path : filePath) {
                    try {
                        InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                        ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)modid, (String)path.getFileName().toString().replaceAll(".json", ""));
                        if (this.tabManager.getCurrentTab() == this.weaponTypeTab) {
                            this.weaponTypeTab.importJson(registryName, stream);
                            continue;
                        }
                        if (this.tabManager.getCurrentTab() == this.itemCapabilityTab) {
                            this.itemCapabilityTab.importJson(registryName, null, stream);
                            continue;
                        }
                        if (this.tabManager.getCurrentTab() != this.mobCapabilityTab) continue;
                        this.mobCapabilityTab.importJson(registryName, stream);
                    }
                    catch (Exception e) {
                        hasException = true;
                        sb.append(String.format("%s : %s\n", path.getFileName().toString(), e.getMessage()));
                        e.printStackTrace();
                    }
                }
                if (hasException) {
                    this.minecraft.setScreen(new MessageScreen("Failed to import these items", sb.toString(), this, button2 -> this.minecraft.setScreen((Screen)this), 300, 70).autoCalculateHeight());
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, button -> this.minecraft.setScreen((Screen)this), new ResizableEditBox(this.minecraft.font, 0, 0, 0, 16, (Component)Component.literal((String)"datapack_edit.input"), null, null), 120, 80));
        } else {
            if (filePath.size() > 1) {
                this.minecraft.setScreen(new MessageScreen("", "Please drop only one file", this, button -> this.minecraft.setScreen((Screen)this), 160, 50));
            }
            Path path = filePath.get(0);
            if (this.weaponTypeTab.packList.size() > 0 || this.itemCapabilityTab.packList.size() > 0 || this.mobCapabilityTab.packList.size() > 0) {
                this.minecraft.setScreen(new MessageScreen("", "The current entries will be removed if you import the new data pack. Do you want to proceed?", this, button -> {
                    DatapackEditScreen newScreen;
                    workingPackScreen = newScreen = new DatapackEditScreen(this.parentScreen);
                    if (newScreen.importDataPack(path)) {
                        this.minecraft.setScreen((Screen)newScreen);
                    }
                }, button -> this.minecraft.setScreen((Screen)this), 200, 90));
            } else {
                workingPackScreen = this;
                this.importDataPack(path);
            }
        }
    }

    protected void init() {
        Minecraft.getInstance().getMainRenderTarget().enableStencil();
        this.tabNavigationBar = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(new Tab[]{this.weaponTypeTab, this.itemCapabilityTab, this.mobCapabilityTab}).build();
        this.tabNavigationBar.selectTab(0, false);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.bottomButtons = new GridLayout().columnSpacing(10);
        GridLayout.RowHelper gridlayout$rowhelper = this.bottomButtons.createRowHelper(2);
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder((Component)GUI_EXPORT, button -> {
            try {
                this.weaponTypeTab.validateBeforeExport();
                this.itemCapabilityTab.validateBeforeExport();
                this.mobCapabilityTab.validateBeforeExport();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.minecraft.setScreen(new MessageScreen("", e.getMessage(), this, button2 -> this.minecraft.setScreen(this.createExportScreen()), button3 -> this.minecraft.setScreen((Screen)this), 400, 110).autoCalculateHeight().withOkTitle((Component)Component.translatable((String)"datapack_edit.export_with_exceptions")));
                return;
            }
            this.minecraft.setScreen(this.createExportScreen());
        }).build());
        gridlayout$rowhelper.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).build());
        this.bottomButtons.visitWidgets(button -> {
            button.setTabOrderGroup(1);
            this.addRenderableWidget((GuiEventListener)button);
        });
        this.repositionElements();
        if (!this.initialized && workingPackScreen != null && workingPackScreen != this) {
            this.initialized = true;
            this.minecraft.setScreen(new MessageScreen("", "Would you like to load the previous pack?", this, button -> this.minecraft.setScreen((Screen)workingPackScreen), button -> {
                if (workingPackScreen != null) {
                    workingPackScreen.destroyUserData();
                }
                this.minecraft.setScreen((Screen)this);
                workingPackScreen = this;
            }, 180, 70));
        }
    }

    public void repositionElements() {
        if (this.tabNavigationBar != null && this.bottomButtons != null) {
            this.tabNavigationBar.setWidth(this.width);
            this.tabNavigationBar.arrangeElements();
            this.bottomButtons.arrangeElements();
            FrameLayout.centerInRectangle((LayoutElement)this.bottomButtons, (int)0, (int)(this.height - 36), (int)this.width, (int)36);
            int i = this.tabNavigationBar.getRectangle().bottom();
            ScreenRectangle screenrectangle = new ScreenRectangle(0, i, this.width, this.bottomButtons.getY() - i);
            this.tabManager.setTabArea(screenrectangle);
        }
    }

    public void tick() {
        Tab tab = this.tabManager.getCurrentTab();
        if (tab instanceof TickableComponent) {
            TickableComponent tickableComponent = (TickableComponent)tab;
            tickableComponent._tick();
        }
    }

    public void onClose() {
        workingPackScreen = this.weaponTypeTab.packList.size() > 0 || this.itemCapabilityTab.packList.size() > 0 || this.mobCapabilityTab.packList.size() > 0 || !this.userMeshes.isEmpty() || !this.userArmatures.isEmpty() || !this.userAnimations.isEmpty() ? this : null;
        this.weaponTypeTab.modelPreviewer.onDestroy();
        this.itemCapabilityTab.modelPreviewer.onDestroy();
        this.minecraft.setScreen(this.parentScreen);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.getFocused() != null && this.getFocused().mouseClicked(x, y, button)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int keycode, int p_100876_, int p_100877_) {
        if (this.tabNavigationBar.keyPressed(keycode)) {
            return true;
        }
        if (super.keyPressed(keycode, p_100876_, p_100877_)) {
            return true;
        }
        return keycode == 257 || keycode == 335;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.getChildAt(mouseX, mouseY).filter(listener -> listener.mouseDragged(mouseX, mouseY, button, dx, dy)).isPresent();
    }

    public void setFocused(@Nullable GuiEventListener target) {
        if (this.getFocused() == target) {
            return;
        }
        super.setFocused(target);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(Screen.FOOTER_SEPARATOR, 0, Mth.roundToward((int)(this.height - 36 - 2), (int)2), 0.0f, 0.0f, this.width, 2, 32, 2);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private <T> MessageScreen<T> createExportScreen() {
        return new MessageScreen<T>("", "Enter the pack title", this, null, 180, 70){

            @Override
            protected void init() {
                this.parentScreen.init(this.minecraft, this.width, this.height);
                int height = this.messageBoxHeight / 2;
                EditBox titleEditBox = new EditBox(this.font, this.width / 2 - 72, this.height / 2 - 6, 144, 16, (Component)Component.literal((String)"pack_title_input_box"));
                this.addRenderableWidget((GuiEventListener)titleEditBox);
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_OK, button$2 -> {
                    if (DatapackEditScreen.this.exportDataPack(titleEditBox.getValue())) {
                        DatapackEditScreen.this.minecraft.setScreen((Screen)DatapackEditScreen.this);
                    }
                }).bounds(this.width / 2 - 56, this.height / 2 + height - 20, 55, 16).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button$2 -> this.minecraft.setScreen((Screen)DatapackEditScreen.this)).bounds(this.width / 2 + 1, this.height / 2 + height - 20, 55, 16).build());
            }
        };
    }

    private void importUserData(PackResources packResources) {
        packResources.getNamespaces(PackType.CLIENT_RESOURCES).stream().distinct().forEach(namespace -> {
            packResources.listResources(PackType.CLIENT_RESOURCES, namespace, "animmodels/entity", (resourceLocation, stream) -> {
                try {
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)stream.get(), StandardCharsets.UTF_8));
                    jsonReader.setLenient(true);
                    JsonObject jsonObject = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceAll("animmodels/", "").replaceAll(".json", ""));
                    JsonAssetLoader modelLoader = new JsonAssetLoader(jsonObject, (ResourceLocation)resourceLocation);
                    SkinnedMesh mesh = null;
                    Armature armature = null;
                    try {
                        mesh = modelLoader.loadSkinnedMesh(SkinnedMesh::new);
                        armature = modelLoader.loadArmature(Armature::new);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (mesh != null) {
                        this.userMeshes.put(rl, SelfAccessor.create(rl, mesh));
                    }
                    if (armature != null) {
                        this.userArmatures.put(rl, SelfAccessor.create(rl, armature));
                    }
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.error("Failed to read model " + String.valueOf(resourceLocation));
                    e.printStackTrace();
                }
            });
            packResources.listResources(PackType.CLIENT_RESOURCES, namespace, "animmodels/animations", (resourceLocation, stream) -> {
                if (resourceLocation.getPath().contains("/data/")) {
                    return;
                }
                try {
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)stream.get(), StandardCharsets.UTF_8));
                    jsonReader.setLenient(true);
                    JsonObject jsonObject = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceAll("animmodels/animations/", "").replaceAll(".json", ""));
                    ResourceLocation datapath = AnimationManager.getSubAnimationFileLocation(resourceLocation, AnimationSubFileReader.SUBFILE_CLIENT_PROPERTY);
                    IoSupplier streamSupplier = packResources.getResource(PackType.CLIENT_RESOURCES, datapath);
                    JsonElement constructorElement = jsonObject.getAsJsonObject().get("constructor");
                    if (constructorElement == null) {
                        throw new IllegalStateException(String.format("No constructor information has provided in User animation %s", rl));
                    }
                    JsonObject constructorObject = constructorElement.getAsJsonObject();
                    String invocationCommand = constructorObject.get("invocation_command").getAsString();
                    if (invocationCommand.lastIndexOf(35) == -1) {
                        throw new IllegalStateException(String.format("Invocation command exception: Missing separator %s in animation %s", invocationCommand, rl));
                    }
                    String className = invocationCommand.substring(invocationCommand.lastIndexOf(35) + 1);
                    Class<? extends DatapackAnimation<? extends StaticAnimation>> animationClass = EditorAnimation.switchType(Class.forName(className));
                    DatapackAnimation<? extends StaticAnimation> animation = InstantiateInvoker.invoke(invocationCommand, animationClass).getResult();
                    if (!animation.registryName().equals((Object)rl)) {
                        throw new IllegalArgumentException("Initializer registry name " + String.valueOf(animation.registryName()) + " is not matching with file path " + String.valueOf(rl));
                    }
                    if (streamSupplier != null) {
                        AnimationSubFileReader.SUBFILE_CLIENT_PROPERTY.apply((InputStream)streamSupplier.get(), (StaticAnimation)animation.get());
                    }
                    JsonAssetLoader modelLoader = new JsonAssetLoader(jsonObject, (ResourceLocation)resourceLocation);
                    animation.setAnimationClip(modelLoader.loadAnimationClip(((StaticAnimation)animation.get()).getArmature().get()));
                    this.userAnimations.put(animation.registryName(), PackEntry.ofValue(animation.readAnimationFromJson(modelLoader.getRootJson().get("animation").getAsJsonArray()), animation));
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.error("Failed to read animation " + String.valueOf(resourceLocation));
                    e.printStackTrace();
                }
            });
        });
    }

    private void exportUserData(ZipOutputStream out) throws Exception {
        Gson gson;
        ZipEntry zipEntry;
        String exportPath;
        HashMap models = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, AssetAccessor<? extends SkinnedMesh>> entry : this.userMeshes.entrySet()) {
            models.put(entry.getKey(), entry.getValue().get().toJsonObject());
        }
        for (Map.Entry<ResourceLocation, AssetAccessor<Object>> entry : this.userArmatures.entrySet()) {
            exportPath = String.format("data/%s/animmodels/%s.json", entry.getKey().getNamespace(), entry.getKey().getPath());
            zipEntry = new ZipEntry(exportPath);
            gson = new GsonBuilder().setPrettyPrinting().create();
            JsonObject armatureJson = ((Armature)entry.getValue().get()).toJsonObject();
            out.putNextEntry(zipEntry);
            out.write(gson.toJson((JsonElement)armatureJson).getBytes());
            out.closeEntry();
            models.computeIfAbsent(entry.getKey(), k -> armatureJson);
            models.computeIfPresent(entry.getKey(), (k, oldVal) -> {
                oldVal.add("armature", armatureJson.get("armature"));
                return oldVal;
            });
        }
        for (Map.Entry<Object, AssetAccessor<Object>> entry : models.entrySet()) {
            exportPath = String.format("assets/%s/animmodels/%s.json", ((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath());
            zipEntry = new ZipEntry(exportPath);
            gson = new GsonBuilder().setPrettyPrinting().create();
            out.putNextEntry(zipEntry);
            out.write(gson.toJson((JsonElement)entry.getValue()).getBytes());
            out.closeEntry();
        }
        for (Map.Entry<Object, Object> entry : this.userAnimations.entrySet()) {
            exportPath = String.format("assets/%s/animmodels/animations/%s.json", ((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath());
            ResourceLocation clientData = AnimationManager.getSubAnimationFileLocation(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)exportPath), AnimationSubFileReader.SUBFILE_CLIENT_PROPERTY);
            ZipEntry asResource = new ZipEntry(exportPath);
            ZipEntry asResourceClientData = new ZipEntry(clientData.getPath());
            ZipEntry asData = new ZipEntry(String.format("data/%s/animmodels/animations/%s.json", ((ResourceLocation)entry.getKey()).getNamespace(), ((ResourceLocation)entry.getKey()).getPath()));
            Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
            EditorAnimation animation = ((DatapackAnimation)((PackEntry)entry.getValue()).getValue()).getCreator();
            JsonObject root = new JsonObject();
            JsonObject constructorInfo = new JsonObject();
            constructorInfo.addProperty("invocation_command", animation.getInvocationCommand());
            root.add("constructor", (JsonElement)constructorInfo);
            root.add("animation", (JsonElement)animation.getRawAnimationJson());
            out.putNextEntry(asResource);
            out.write(gson2.toJson((JsonElement)root).getBytes());
            out.closeEntry();
            if (animation.getPropertiesJson().size() > 0) {
                out.putNextEntry(asResourceClientData);
                out.write(gson2.toJson((JsonElement)animation.getPropertiesJson()).getBytes());
                out.closeEntry();
            }
            out.putNextEntry(asData);
            out.write(gson2.toJson((JsonElement)root).getBytes());
            out.closeEntry();
        }
    }

    public void destroyUserData() {
        this.userMeshes.values().forEach(accessor -> ((SkinnedMesh)accessor.get()).destroy());
    }

    public Map<ResourceLocation, AssetAccessor<? extends SkinnedMesh>> getUserMeshes() {
        return this.userMeshes;
    }

    public Map<ResourceLocation, AssetAccessor<? extends Armature>> getUserArmatures() {
        return this.userArmatures;
    }

    public Map<ResourceLocation, PackEntry<EditorAnimation, DatapackAnimation<? extends StaticAnimation>>> getUserAniamtions() {
        return this.userAnimations;
    }

    @OnlyIn(value=Dist.CLIENT)
    class WeaponTypeTab
    extends DatapackTab<ResourceLocation> {
        private final ModelPreviewer modelPreviewer;

        public WeaponTypeTab() {
            super((Component)Component.translatable((String)"gui.epicfight.tab.datapack.weapon_type"), "capabilities/weapons/types", null);
            DatapackEditScreen parentScreen = DatapackEditScreen.this;
            Font font = DatapackEditScreen.this.font;
            ScreenRectangle rect = DatapackEditScreen.this.getRectangle();
            this.modelPreviewer = new ModelPreviewer(9, 15, 0, 140, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, Armatures.BIPED, Meshes.BIPED);
            this.modelPreviewer.setColliderJoint(((HumanoidArmature)Armatures.BIPED.get()).searchJointByName("Tool_R"));
            this.inputComponentsList = new InputComponentList<CompoundTag>(this, (Screen)DatapackEditScreen.this, 0, 0, 0, 30){

                @Override
                public void importTag(CompoundTag tag) {
                    ListTag list;
                    CompoundTag colliderTag = ParseUtil.getOrSupply(tag, "collider", CompoundTag::new);
                    boolean centerInit = colliderTag.contains("center");
                    boolean sizeInit = colliderTag.contains("size");
                    if (!centerInit) {
                        list = new ListTag();
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        colliderTag.put("center", (Tag)list);
                    }
                    if (!sizeInit) {
                        list = new ListTag();
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        colliderTag.put("size", (Tag)list);
                    }
                    this.setComponentsActive(true);
                    Grid.PackImporter packImporter = new Grid.PackImporter();
                    for (String key : tag.getCompound("innate_skills").getAllKeys()) {
                        packImporter.newRow();
                        packImporter.newValue("style", Style.ENUM_MANAGER.get(key));
                        packImporter.newValue("skill", SkillReloadListener.getSkill(tag.getCompound("innate_skills").getString(key)));
                    }
                    this.setDataBindingComponenets(new Object[]{WeaponCategory.ENUM_MANAGER.get(tag.getString("category")), BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)tag.getString("hit_particle"))), BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("hit_sound"))), BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("swing_sound"))), tag.contains("usable_in_offhand") ? tag.getBoolean("usable_in_offhand") : true, null, ParseUtil.nullOrToString(colliderTag.get("number"), Tag::getAsString), centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(0), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(1), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(2), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(0), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(1), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(2), Tag::getAsString)) : "", packImporter});
                }
            };
            this.inputComponentsList.setX(164);
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.category"));
            this.inputComponentsList.addComponentCurrentRow(new ComboBox<WeaponCategory>(parentScreen, parentScreen.getMinecraft().font, this.inputComponentsList.nextStart(5), 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.translatable((String)"datapack_edit.weapon_type.category"), new ArrayList<WeaponCategory>(WeaponCategory.ENUM_MANAGER.universalValues()), ParseUtil::snakeToSpacedCamel, weaponCategory -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("category", ParseUtil.nullParam(weaponCategory).toLowerCase(Locale.ROOT))));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.hit_particle"));
            this.inputComponentsList.addComponentCurrentRow(new PopupBox.RegistryPopupBox((Screen)parentScreen, font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.hit_particle"), BuiltInRegistries.PARTICLE_TYPE, pair -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("hit_particle", ParseUtil.getRegistryName((ParticleType)pair.getSecond(), BuiltInRegistries.PARTICLE_TYPE))));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.hit_sound"));
            this.inputComponentsList.addComponentCurrentRow(new PopupBox.SoundPopupBox(parentScreen, font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.hit_sound"), pair -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("hit_sound", ParseUtil.getRegistryName((SoundEvent)pair.getSecond(), BuiltInRegistries.SOUND_EVENT))));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.swing_sound"));
            this.inputComponentsList.addComponentCurrentRow(new PopupBox.SoundPopupBox(parentScreen, font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.swing_sound"), pair -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("swing_sound", ParseUtil.getRegistryName((SoundEvent)pair.getSecond(), BuiltInRegistries.SOUND_EVENT))));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.styles"));
            this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new StylesScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue())).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.offhand_usability"));
            this.inputComponentsList.addComponentCurrentRow(new CheckBox(font, this.inputComponentsList.nextStart(4), 60, 0, 10, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, null, (Component)Component.literal((String)""), val -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putBoolean("usable_in_offhand", val.booleanValue())));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.offhand_visibility"));
            this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new OffhandValidatorScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue())).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            ResizableEditBox colliderCount = new ResizableEditBox(font, 0, 40, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.count"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderCenterX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderCenterY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderCenterZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderSizeX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderSizeY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            ResizableEditBox colliderSizeZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
            Runnable setColliderToPreviewer = () -> {
                CompoundTag comp = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                Collider collider = null;
                if (comp.contains("collider")) {
                    try {
                        collider = ColliderPreset.deserializeSimpleCollider(comp.getCompound("collider"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.modelPreviewer.setCollider(collider);
            };
            colliderCount.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                if (StringUtil.isNullOrEmpty((String)input)) {
                    collider.remove("number");
                } else {
                    collider.put("number", (Tag)IntTag.valueOf((int)Integer.valueOf(input)));
                }
                setColliderToPreviewer.run();
            });
            colliderCenterX.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("center", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                centerVec.remove(0);
                centerVec.add(0, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderCenterY.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("center", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                centerVec.remove(1);
                centerVec.add(1, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderCenterZ.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("center", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                centerVec.remove(2);
                centerVec.add(2, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderSizeX.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("size", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                centerVec.remove(0);
                centerVec.add(0, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderSizeY.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("size", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                centerVec.remove(1);
                centerVec.add(1, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderSizeZ.setResponder(input -> {
                CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                ListTag centerVec = collider.getList("size", 6);
                double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                centerVec.remove(2);
                centerVec.add(2, (Tag)DoubleTag.valueOf((double)i));
                setColliderToPreviewer.run();
            });
            colliderCount.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
            colliderCenterX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            colliderCenterY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            colliderCenterZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            colliderSizeX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
            colliderSizeY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
            colliderSizeZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider"));
            this.inputComponentsList.addComponentCurrentRow(new PopupBox.ColliderPopupBox(parentScreen, font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.collider"), pair -> {
                if (pair.getSecond() != null) {
                    CompoundTag colliderTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ((Collider)pair.getSecond()).serialize(colliderTag);
                    colliderCount.setValue(String.valueOf(colliderTag.getInt("number")));
                    ListTag centerVec = colliderTag.getList("center", 6);
                    colliderCenterX.setValue(String.valueOf(centerVec.getDouble(0)));
                    colliderCenterY.setValue(String.valueOf(centerVec.getDouble(1)));
                    colliderCenterZ.setValue(String.valueOf(centerVec.getDouble(2)));
                    ListTag sizeVec = colliderTag.getList("size", 6);
                    colliderSizeX.setValue(String.valueOf(sizeVec.getDouble(0)));
                    colliderSizeY.setValue(String.valueOf(sizeVec.getDouble(1)));
                    colliderSizeZ.setValue(String.valueOf(sizeVec.getDouble(2)));
                } else if (((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).contains("collider")) {
                    colliderCount.setValue("");
                    colliderCenterX.setValue("");
                    colliderCenterY.setValue("");
                    colliderCenterZ.setValue("");
                    colliderSizeX.setValue("");
                    colliderSizeY.setValue("");
                    colliderSizeZ.setValue("");
                }
                this.modelPreviewer.setCollider((Collider)pair.getSecond());
            }).applyFilter(collider -> collider instanceof OBBCollider || collider instanceof MultiOBBCollider));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.count"));
            this.inputComponentsList.addComponentCurrentRow(colliderCount.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.center"));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderCenterX.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderCenterY.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderCenterZ.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.size"));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderSizeX.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderSizeY.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
            this.inputComponentsList.addComponentCurrentRow(colliderSizeZ.relocateX(rect, this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(this.modelPreviewer);
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.combos"));
            this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new WeaponComboScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue())).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.innate_skill"));
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(Grid.builder(DatapackEditScreen.this).xy1(this.inputComponentsList.nextStart(5), 0).xy2(15, 90).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("style", Style.ENUM_MANAGER.universalValues()).valueChanged(event -> {
                CompoundTag innateSkillsTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "innate_skills", new CompoundTag());
                innateSkillsTag.remove(ParseUtil.nullParam(event.prevValue).toLowerCase(Locale.ROOT));
                innateSkillsTag.putString(ParseUtil.nullParam(event.postValue).toLowerCase(Locale.ROOT), ParseUtil.nullParam(event.grid.getValue(event.rowposition, "skill")));
            }).editable(true).width(100)).addColumn(Grid.registryPopup("skill", EpicFightRegistries.SKILL).filter(skill -> skill.getCategory() == SkillCategories.WEAPON_INNATE).valueChanged(event -> {
                CompoundTag innateSkillsTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "innate_skills", new CompoundTag());
                innateSkillsTag.putString(ParseUtil.nullParam(event.grid.getValue(event.rowposition, "style")).toLowerCase(Locale.ROOT), ParseUtil.nullParam(event.postValue));
            }).toDisplayText(item -> item == null ? "" : item.getRegistryName().toString()).width(150)).pressAdd((grid, button) -> {
                grid.setValueChangeEnabled(false);
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "style");
                grid.setValueChangeEnabled(true);
            }).pressRemove((grid, button) -> {
                int rowposition = grid.getRowposition();
                if (rowposition > -1) {
                    CompoundTag innateSkillsTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "innate_skills", new CompoundTag());
                    innateSkillsTag.remove(ParseUtil.nullParam(grid.getValue(rowposition, "style")).toLowerCase(Locale.ROOT));
                    grid.removeRow(rowposition);
                }
            }).build());
            this.inputComponentsList.newRow();
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 80, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.weapon_type.living_animations"));
            this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new LivingAnimationsScreen(DatapackEditScreen.this, ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "livingmotion_modifier", new CompoundTag()))).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            this.inputComponentsList.setComponentsActive(false);
        }

        @Override
        public void packGridRowpositionChanged(int rowposition, Map<String, Object> values) {
            super.packGridRowpositionChanged(rowposition, values);
            try {
                CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(rowposition)).getValue();
                Collider collider = ColliderPreset.deserializeSimpleCollider(tag.getCompound("collider"));
                this.modelPreviewer.setCollider(collider);
            }
            catch (IllegalArgumentException e) {
                this.modelPreviewer.setCollider(null);
            }
        }

        @Override
        public void validateBeforeExport() {
            for (PackEntry packEntry : this.packList) {
                try {
                    WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder((ResourceLocation)packEntry.getKey(), (CompoundTag)packEntry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to export weapon type " + String.valueOf(packEntry.getKey()) + " :\n" + e.getMessage());
                }
            }
        }

        @Override
        public void importEntries(PackResources packResources) {
            packResources.getNamespaces(PackType.SERVER_DATA).stream().distinct().forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, this.directory, (resourceLocation, streamSupplier) -> {
                try {
                    ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceAll(this.directory + "/", "").replaceAll(".json", ""));
                    this.importJson(rl, (InputStream)streamSupplier.get());
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.info("Failed to import " + String.valueOf(resourceLocation) + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }));
        }

        public void importJson(ResourceLocation registryName, InputStream inputStream) throws Exception {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                jsonReader.setLenient(true);
                JsonObject jsonObject = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                CompoundTag compTag = TagParser.parseTag((String)jsonObject.toString());
                try {
                    WeaponCapability.Builder builder = WeaponTypeReloadListener.deserializeWeaponCapabilityBuilder(registryName, compTag);
                    DatapackEditScreen.this.userWeaponTypes.put(registryName, item -> builder);
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.warn("Failed to deserialize weapon type from datapack." + String.valueOf(registryName) + ": " + e.getMessage());
                    e.printStackTrace();
                }
                this.packList.add(PackEntry.ofValue(registryName, compTag));
                this.packListGrid.addRowWithDefaultValues("pack_item", registryName.toString());
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.info("Failed to import " + String.valueOf(registryName) + ": " + e.getMessage());
                throw e;
            }
            finally {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void exportEntries(ZipOutputStream out) throws Exception {
            for (PackEntry packEntry : this.packList) {
                try {
                    ZipEntry zipEntry = new ZipEntry(String.format("data/%s/" + this.directory + "/%s.json", ((ResourceLocation)packEntry.getKey()).getNamespace(), ((ResourceLocation)packEntry.getKey()).getPath()));
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    out.putNextEntry(zipEntry);
                    out.write(gson.toJson((JsonElement)ParseUtil.convertToJsonObject((CompoundTag)packEntry.getValue())).getBytes());
                    out.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failded to export " + String.valueOf(packEntry.getKey()) + ". " + e.getMessage());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ItemCapabilityTab
    extends DatapackTab<Item> {
        private ModelPreviewer modelPreviewer;
        private ComboBox<ItemType> itemTypeCombo;
        private Consumer<ItemType> responder;

        public ItemCapabilityTab() {
            super((Component)Component.translatable((String)"gui.epicfight.tab.datapack.item_capability"), "capabilities", BuiltInRegistries.ITEM);
            DatapackEditScreen parentScreen = DatapackEditScreen.this;
            this.modelPreviewer = new ModelPreviewer(20, 15, 0, 150, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, Armatures.BIPED, Meshes.BIPED);
            this.modelPreviewer.setColliderJoint(((HumanoidArmature)Armatures.BIPED.get()).searchJointByName("Tool_R"));
            this.responder = itemType -> {
                CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                tag.tags.clear();
                tag.putString("item_type", ParseUtil.nullParam(itemType));
                this.rearrangeElements((ItemType)((Object)itemType), tag);
                if (itemType == ItemType.WEAPON) {
                    CompoundTag trailTag = ParseUtil.getOrSupply(tag, "trail", CompoundTag::new);
                    CompoundTag colliderTag = ParseUtil.getOrSupply(tag, "collider", CompoundTag::new);
                    boolean centerInit = colliderTag.contains("center");
                    boolean sizeInit = colliderTag.contains("size");
                    boolean colorInit = trailTag.contains("color");
                    boolean beginInit = trailTag.contains("begin_pos");
                    boolean endInit = trailTag.contains("end_pos");
                    this.itemTypeCombo._setResponder((Consumer<ItemType>)null);
                    this.inputComponentsList.setDataBindingComponenets(new Object[]{itemType, DatapackEditScreen.getWeaponType(tag.getString("type")), null, ParseUtil.nullParam(colliderTag.get("number")), centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(0), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(1), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(2), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(0), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(1), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(2), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(0), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(1), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(2), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(0), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(1), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(2), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(0), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(1), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(2), Tag::getAsString)) : "", ParseUtil.nullParam(trailTag.get("lifetime")), ParseUtil.nullParam(trailTag.get("interpolations")), ParseUtil.nullParam(trailTag.getString("texture_path")), BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)trailTag.getString("particle_type")))});
                    this.itemTypeCombo._setResponder(this.responder);
                } else {
                    this.itemTypeCombo._setResponder((Consumer<ItemType>)null);
                    this.inputComponentsList.setDataBindingComponenets(new Object[]{itemType});
                    this.itemTypeCombo._setResponder(this.responder);
                }
            };
            this.itemTypeCombo = new ComboBox<ItemType>(parentScreen, parentScreen.getMinecraft().font, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.translatable((String)"datapack_edit.item_capability.item_type"), List.of(ItemType.values()), ParseUtil::snakeToSpacedCamel, this.responder);
            this.inputComponentsList = new InputComponentList<CompoundTag>((Screen)DatapackEditScreen.this, 0, 0, 0, 30){

                @Override
                public void importTag(CompoundTag tag) {
                    ItemType itemType = null;
                    try {
                        itemType = ItemType.valueOf(tag.getString("item_type"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ItemCapabilityTab.this.rearrangeElements(itemType, tag);
                    this.setComponentsActive(true);
                    if (itemType == ItemType.WEAPON) {
                        CompoundTag trailTag = ParseUtil.getOrSupply(tag, "trail", CompoundTag::new);
                        CompoundTag colliderTag = ParseUtil.getOrSupply(tag, "collider", CompoundTag::new);
                        boolean centerInit = colliderTag.contains("center");
                        boolean sizeInit = colliderTag.contains("size");
                        boolean colorInit = trailTag.contains("color");
                        boolean beginInit = trailTag.contains("begin_pos");
                        boolean endInit = trailTag.contains("end_pos");
                        ItemCapabilityTab.this.itemTypeCombo._setResponder((Consumer<ItemType>)null);
                        this.setDataBindingComponenets(new Object[]{itemType, DatapackEditScreen.getWeaponType(tag.getString("type")), null, ParseUtil.nullParam(colliderTag.get("number")), centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(0), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(1), Tag::getAsString)) : "", centerInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("center", 6).get(2), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(0), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(1), Tag::getAsString)) : "", sizeInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(colliderTag.getList("size", 6).get(2), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(0), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(1), Tag::getAsString)) : "", colorInit ? ParseUtil.nullParam(ParseUtil.nullOrToString(trailTag.getList("color", 3).get(2), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(0), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(1), Tag::getAsString)) : "", beginInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("begin_pos", 6).get(2), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(0), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(1), Tag::getAsString)) : "", endInit ? ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(trailTag.getList("end_pos", 6).get(2), Tag::getAsString)) : "", ParseUtil.nullParam(trailTag.get("lifetime")), ParseUtil.nullParam(trailTag.get("interpolations")), ParseUtil.nullParam(trailTag.getString("texture_path")), BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)trailTag.getString("particle_type")))});
                        ItemCapabilityTab.this.itemTypeCombo._setResponder(ItemCapabilityTab.this.responder);
                    } else {
                        ItemCapabilityTab.this.itemTypeCombo._setResponder((Consumer<ItemType>)null);
                        this.setDataBindingComponenets(new Object[]{itemType});
                        ItemCapabilityTab.this.itemTypeCombo._setResponder(ItemCapabilityTab.this.responder);
                    }
                }
            };
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.item_type"));
            this.inputComponentsList.addComponentCurrentRow(this.itemTypeCombo.relocateX(DatapackEditScreen.this.getRectangle(), this.inputComponentsList.nextStart(5)));
            this.inputComponentsList.setComponentsActive(false);
        }

        private void rearrangeElements(ItemType itemType, CompoundTag tag) {
            this.inputComponentsList.clearComponents();
            Font font = DatapackEditScreen.this.font;
            ScreenRectangle rect = DatapackEditScreen.this.getRectangle();
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.item_type"));
            this.inputComponentsList.addComponentCurrentRow(this.itemTypeCombo.relocateX(rect, this.inputComponentsList.nextStart(5)));
            if (itemType == ItemType.WEAPON) {
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.attributes"));
                this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new WeaponAttributeScreen(DatapackEditScreen.this, ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", new CompoundTag()), itemType)).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.type"));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.WeaponTypePopupBox(DatapackEditScreen.this, font, this.inputComponentsList.nextStart(5), 15, 15, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.item_capability.type"), pair -> {
                    CapabilityItem.Builder builder;
                    CompoundTag currentTag = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                    currentTag.putString("type", (String)pair.getFirst());
                    if (pair.getSecond() != null && (builder = (CapabilityItem.Builder)((Function)pair.getSecond()).apply((Item)this.registry.get((ResourceLocation)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getKey()))) instanceof WeaponCapability.Builder) {
                        WeaponCapability.Builder weaponBuilder = (WeaponCapability.Builder)builder;
                        this.modelPreviewer.clearAnimations();
                        List allAnimations = weaponBuilder.getComboAnimations().entrySet().stream().reduce(Lists.newArrayList(), (list, entry) -> {
                            list.addAll((Collection)entry.getValue());
                            return list;
                        }, (list1, list2) -> {
                            list1.addAll(list2);
                            return list1;
                        });
                        allAnimations.stream().forEach(this.modelPreviewer::addAnimationToPlay);
                        boolean hasCustomCollider = false;
                        if (currentTag.contains("collider")) {
                            try {
                                ColliderPreset.deserializeSimpleCollider(currentTag.getCompound("collider"));
                                hasCustomCollider = true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        if (!hasCustomCollider) {
                            this.modelPreviewer.setCollider(weaponBuilder.getCollider());
                        }
                    }
                }));
                ResizableEditBox colliderCount = new ResizableEditBox(font, 0, 40, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.count"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderCenterX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderCenterY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderCenterZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.center.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderSizeX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderSizeY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colliderSizeZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.collider.size.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                colliderCount.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    if (StringUtil.isNullOrEmpty((String)input)) {
                        collider.remove("number");
                    } else {
                        collider.put("number", (Tag)IntTag.valueOf((int)Integer.valueOf(input)));
                    }
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderCenterX.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag centerVec = ParseUtil.getOrDefaultTag(collider, "center", new ListTag());
                    if (centerVec.isEmpty()) {
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    centerVec.set(0, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderCenterY.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag centerVec = ParseUtil.getOrDefaultTag(collider, "center", new ListTag());
                    if (centerVec.isEmpty()) {
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    centerVec.set(1, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderCenterZ.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag centerVec = ParseUtil.getOrDefaultTag(collider, "center", new ListTag());
                    if (centerVec.isEmpty()) {
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                        centerVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    centerVec.set(2, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderSizeX.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag sizeVec = ParseUtil.getOrDefaultTag(collider, "size", new ListTag());
                    if (sizeVec.isEmpty()) {
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                    sizeVec.set(0, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderSizeY.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag sizeVec = ParseUtil.getOrDefaultTag(collider, "size", new ListTag());
                    if (sizeVec.isEmpty()) {
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                    sizeVec.set(1, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderSizeZ.setResponder(input -> {
                    CompoundTag collider = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                    ListTag sizeVec = ParseUtil.getOrDefaultTag(collider, "size", new ListTag());
                    if (sizeVec.isEmpty()) {
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                        sizeVec.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double i = StringUtil.isNullOrEmpty((String)input) ? 0.0 : Double.valueOf(input);
                    sizeVec.set(2, (Tag)DoubleTag.valueOf((double)i));
                    try {
                        this.modelPreviewer.setCollider(ColliderPreset.deserializeSimpleCollider(collider));
                    }
                    catch (IllegalArgumentException e) {
                        this.modelPreviewer.setCollider(null);
                    }
                });
                colliderCount.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
                colliderCenterX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                colliderCenterY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                colliderCenterZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                colliderSizeX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                colliderSizeY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                colliderSizeZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.translatable((String)"datapack_edit.collider"), (Component)Component.translatable((String)"datapack_edit.item_capability.collider.tooltip")));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.ColliderPopupBox(DatapackEditScreen.this, font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.collider"), pair -> {
                    if (pair.getSecond() != null) {
                        CompoundTag colliderTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "collider", new CompoundTag());
                        ((Collider)pair.getSecond()).serialize(colliderTag);
                        colliderCount.setValue(String.valueOf(colliderTag.getInt("number")));
                        ListTag centerVec = colliderTag.getList("center", 6);
                        colliderCenterX.setValue(String.valueOf(centerVec.getDouble(0)));
                        colliderCenterY.setValue(String.valueOf(centerVec.getDouble(1)));
                        colliderCenterZ.setValue(String.valueOf(centerVec.getDouble(2)));
                        ListTag sizeVec = colliderTag.getList("size", 6);
                        colliderSizeX.setValue(String.valueOf(sizeVec.getDouble(0)));
                        colliderSizeY.setValue(String.valueOf(sizeVec.getDouble(1)));
                        colliderSizeZ.setValue(String.valueOf(sizeVec.getDouble(2)));
                    } else if (((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).contains("collider")) {
                        colliderCount.setValue("");
                        colliderCenterX.setValue("");
                        colliderCenterY.setValue("");
                        colliderCenterZ.setValue("");
                        colliderSizeX.setValue("");
                        colliderSizeY.setValue("");
                        colliderSizeZ.setValue("");
                    }
                    this.modelPreviewer.setCollider((Collider)pair.getSecond());
                }).applyFilter(collider -> collider instanceof OBBCollider || collider instanceof MultiOBBCollider));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.count"));
                this.inputComponentsList.addComponentCurrentRow(colliderCount.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.center"));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderCenterX.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderCenterY.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderCenterZ.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.size"));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderSizeX.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderSizeY.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
                this.inputComponentsList.addComponentCurrentRow(colliderSizeZ.relocateX(rect, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 90, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.trail"));
                ResizableEditBox colorR = new ResizableEditBox(font, 0, 30, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.color.r"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colorG = new ResizableEditBox(font, 0, 30, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.color.g"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox colorB = new ResizableEditBox(font, 0, 30, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.color.b"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ColorPreviewWidget colorWidget = new ColorPreviewWidget(0, 12, 0, 12, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.translatable((String)"datapack_edit.item_capability.color"));
                colorR.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "color", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                    }
                    int i = StringUtil.isNullOrEmpty((String)input) ? 0 : Integer.valueOf(input);
                    list.set(0, (Tag)IntTag.valueOf((int)i));
                    colorWidget.setColor(ParseUtil.parseOrGet(input, Integer::valueOf, 0), ParseUtil.parseOrGet(colorG.getValue(), Integer::valueOf, 0), ParseUtil.parseOrGet(colorB.getValue(), Integer::valueOf, 0));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                colorG.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "color", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                    }
                    int i = StringUtil.isNullOrEmpty((String)input) ? 0 : Integer.valueOf(input);
                    list.set(1, (Tag)IntTag.valueOf((int)i));
                    colorWidget.setColor(ParseUtil.parseOrGet(colorR.getValue(), Integer::valueOf, 0), ParseUtil.parseOrGet(input, Integer::valueOf, 0), ParseUtil.parseOrGet(colorB.getValue(), Integer::valueOf, 0));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                colorB.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "color", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                        list.add((Object)IntTag.valueOf((int)0));
                    }
                    int i = StringUtil.isNullOrEmpty((String)input) ? 0 : Integer.valueOf(input);
                    list.set(2, (Tag)IntTag.valueOf((int)i));
                    colorWidget.setColor(ParseUtil.parseOrGet(colorR.getValue(), Integer::valueOf, 0), ParseUtil.parseOrGet(colorG.getValue(), Integer::valueOf, 0), ParseUtil.parseOrGet(input, Integer::valueOf, 0));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                colorR.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt) && ParseUtil.parseOrGet(context, Integer::parseInt, 0) < 256);
                colorG.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt) && ParseUtil.parseOrGet(context, Integer::parseInt, 0) < 256);
                colorB.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt) && ParseUtil.parseOrGet(context, Integer::parseInt, 0) < 256);
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 28, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.color"));
                this.inputComponentsList.addComponentCurrentRow(colorWidget.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(41), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"R: ")));
                this.inputComponentsList.addComponentCurrentRow(colorR.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"G: ")));
                this.inputComponentsList.addComponentCurrentRow(colorG.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"B: ")));
                this.inputComponentsList.addComponentCurrentRow(colorB.relocateX(rect, this.inputComponentsList.nextStart(4)));
                ResizableEditBox beginX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.begin_pos.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox beginY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.begin_pos.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox beginZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.begin_pos.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                beginX.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "begin_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.set(0, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                beginY.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "begin_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.set(1, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                beginZ.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "begin_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.set(2, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                beginX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                beginY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                beginZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.begin_pos"));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(5), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
                this.inputComponentsList.addComponentCurrentRow(beginX.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
                this.inputComponentsList.addComponentCurrentRow(beginY.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
                this.inputComponentsList.addComponentCurrentRow(beginZ.relocateX(rect, this.inputComponentsList.nextStart(4)));
                ResizableEditBox endX = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.end_pos.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox endY = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.end_pos.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox endZ = new ResizableEditBox(font, 0, 35, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.end_pos.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                endX.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "end_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.remove(0);
                    list.add(0, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                endY.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "end_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.remove(1);
                    list.add(1, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                endZ.setResponder(input -> {
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    ListTag list = ParseUtil.getOrDefaultTag(trailTag, "end_pos", new ListTag());
                    if (list.isEmpty()) {
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                        list.add((Object)DoubleTag.valueOf((double)0.0));
                    }
                    double d = StringUtil.isNullOrEmpty((String)input) ? 0.0 : ParseUtil.parseOrGet(input, Double::valueOf, 0.0);
                    list.remove(2);
                    list.add(2, (Tag)DoubleTag.valueOf((double)d));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                endX.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                endY.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                endZ.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.end_pos"));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(5), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"X: ")));
                this.inputComponentsList.addComponentCurrentRow(endX.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Y: ")));
                this.inputComponentsList.addComponentCurrentRow(endY.relocateX(rect, this.inputComponentsList.nextStart(4)));
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(8), 8, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.literal((String)"Z: ")));
                this.inputComponentsList.addComponentCurrentRow(endZ.relocateX(rect, this.inputComponentsList.nextStart(4)));
                ResizableEditBox lifetime = new ResizableEditBox(font, 0, 30, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.lifetime"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                ResizableEditBox interpolation = new ResizableEditBox(font, 0, 30, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.interpolation"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                lifetime.setResponder(input -> {
                    int i = StringUtil.isNullOrEmpty((String)input) ? 0 : Integer.valueOf(input);
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    trailTag.put("lifetime", (Tag)IntTag.valueOf((int)i));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                lifetime.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
                interpolation.setResponder(input -> {
                    int i = StringUtil.isNullOrEmpty((String)input) ? 0 : Integer.valueOf(input);
                    CompoundTag trailTag = ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).getCompound("trail");
                    trailTag.put("interpolations", (Tag)IntTag.valueOf((int)i));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                interpolation.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.lifetime"));
                this.inputComponentsList.addComponentCurrentRow(lifetime.relocateX(rect, this.inputComponentsList.nextStart(8)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.interpolations"));
                this.inputComponentsList.addComponentCurrentRow(interpolation.relocateX(rect, this.inputComponentsList.nextStart(8)));
                ResizableEditBox texturePath = new ResizableEditBox(font, 0, 15, 0, 15, (Component)Component.translatable((String)"datapack_edit.item_capability.trail.end_pos.z"), ResizableComponent.HorizontalSizing.LEFT_RIGHT, null);
                texturePath.setResponder(input -> {
                    CompoundTag trailTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "trail", new CompoundTag());
                    trailTag.putString("texture_path", ResourceLocation.parse((String)input).toString());
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                texturePath.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ResourceLocation.isValidNamespace((String)context) && ResourceLocation.isValidPath((String)context));
                texturePath.setMaxLength(100);
                texturePath.setValue("epicfight:textures/particle/swing_trail.png");
                texturePath.moveCursorToStart(true);
                PopupBox.RegistryPopupBox particlePopup = new PopupBox.RegistryPopupBox((Screen)DatapackEditScreen.this, font, 0, 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.hit_particle"), BuiltInRegistries.PARTICLE_TYPE, pair -> {
                    CompoundTag trailTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "trail", new CompoundTag());
                    trailTag.putString("particle_type", ParseUtil.getRegistryName((ParticleType)pair.getSecond(), BuiltInRegistries.PARTICLE_TYPE));
                    TrailInfo trailInfo = TrailInfo.deserialize(trailTag);
                    this.modelPreviewer.setTrailInfo(trailInfo);
                });
                particlePopup._setValue((ParticleType)EpicFightParticles.SWING_TRAIL.get());
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.texture_path"));
                this.inputComponentsList.addComponentCurrentRow(texturePath.relocateX(rect, this.inputComponentsList.nextStart(8)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(20), 80, 0, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.particle_type"));
                this.inputComponentsList.addComponentCurrentRow(particlePopup.relocateX(rect, this.inputComponentsList.nextStart(8)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(this.modelPreviewer.relocateX(rect, this.inputComponentsList.nextStart(8)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
            } else if (itemType == ItemType.ARMOR) {
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static(DatapackEditScreen.this.parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.attributes"));
                this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new WeaponAttributeScreen(DatapackEditScreen.this, ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", new CompoundTag()), itemType)).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            }
            this.inputComponentsList.setX(164);
        }

        @Override
        public void packGridRowpositionChanged(int rowposition, Map<String, Object> values) {
            CapabilityItem.Builder<?> builder;
            Function<Item, CapabilityItem.Builder<?>> builderProvider;
            CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(rowposition)).getValue();
            this.inputComponentsList.importTag(tag);
            ResourceLocation rl = ResourceLocation.parse((String)ParseUtil.nullParam(values.get("pack_item")));
            if (this.registry.containsKey(rl)) {
                this.modelPreviewer.setItemToRender((Item)this.registry.get(rl));
            }
            if ((builderProvider = DatapackEditScreen.getWeaponType(tag.getString("type"))) != null && (builder = builderProvider.apply((Item)this.registry.get((ResourceLocation)((PackEntry)this.packList.get(rowposition)).getKey()))) instanceof WeaponCapability.Builder) {
                WeaponCapability.Builder weaponBuilder = (WeaponCapability.Builder)builder;
                this.modelPreviewer.clearAnimations();
                List allAnimations = weaponBuilder.getComboAnimations().entrySet().stream().reduce(Lists.newArrayList(), (list, entry) -> {
                    list.addAll((Collection)entry.getValue());
                    return list;
                }, (list1, list2) -> {
                    list1.addAll(list2);
                    return list1;
                });
                allAnimations.stream().forEach(this.modelPreviewer::addAnimationToPlay);
                boolean hasCustomCollider = false;
                if (tag.contains("collider")) {
                    try {
                        ColliderPreset.deserializeSimpleCollider(tag.getCompound("collider"));
                        hasCustomCollider = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!hasCustomCollider) {
                    this.modelPreviewer.setCollider(weaponBuilder.getCollider());
                }
            }
        }

        @Override
        public void validateBeforeExport() {
            for (PackEntry packEntry : this.packList) {
                try {
                    String sItemType = ((CompoundTag)packEntry.getValue()).getString("item_type");
                    if (StringUtil.isNullOrEmpty((String)sItemType)) {
                        throw new IllegalStateException("Item type not specified");
                    }
                    if (sItemType != ItemType.WEAPON.toString() || ((CompoundTag)packEntry.getValue()).contains("type")) continue;
                    throw new IllegalStateException("Weapon type not specified");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to export item capability " + String.valueOf(packEntry.getKey()) + " :\n" + e.getMessage());
                }
            }
        }

        @Override
        public void importEntries(PackResources packResources) {
            packResources.getNamespaces(PackType.SERVER_DATA).stream().distinct().forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, this.directory, (resourceLocation, streamSupplier) -> {
                block6: {
                    if (resourceLocation.toString().contains("/types/")) {
                        return;
                    }
                    try {
                        InputStream itemSkinInputStream;
                        ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceAll(String.format("%s/%s/", this.directory, ItemType.WEAPON.directoryName), "").replaceAll(String.format("%s/%s/", this.directory, ItemType.ARMOR.directoryName), "").replaceAll(".json", ""));
                        ItemType itemType = resourceLocation.getPath().contains(ItemType.WEAPON.directoryName) ? ItemType.WEAPON : ItemType.ARMOR;
                        this.importJson(registryName, itemType, (InputStream)streamSupplier.get());
                        ResourceLocation itemSkin = ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)("item_skins/" + registryName.getPath() + ".json"));
                        IoSupplier itemSkinStreamSupplier = packResources.getResource(PackType.CLIENT_RESOURCES, itemSkin);
                        if (itemSkinStreamSupplier == null || (itemSkinInputStream = (InputStream)itemSkinStreamSupplier.get()) == null) break block6;
                        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(itemSkinInputStream, StandardCharsets.UTF_8));
                        jsonReader.setLenient(true);
                        CompoundTag comp = null;
                        try {
                            comp = TagParser.parseTag((String)Streams.parse((JsonReader)jsonReader).getAsJsonObject().toString());
                        }
                        finally {
                            jsonReader.close();
                        }
                        ((CompoundTag)((PackEntry)this.packList.get(this.packList.size() - 1)).getValue()).put("trail", comp.get("trail"));
                    }
                    catch (Exception e) {
                        EpicFightMod.LOGGER.info("Failed to import " + String.valueOf(resourceLocation) + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }));
        }

        public void importJson(ResourceLocation registryName, ItemType itemType, InputStream inputStream) throws Exception {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                jsonReader.setLenient(true);
                JsonObject jsonObject = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                CompoundTag compTag = TagParser.parseTag((String)jsonObject.toString());
                if (itemType != null) {
                    compTag.putString("item_type", itemType.toString());
                }
                if (itemType == ItemType.WEAPON) {
                    if (compTag.contains("attributes", 10)) {
                        LinkedHashMap weaponAttributeEditors = Maps.newLinkedHashMap();
                        weaponAttributeEditors.put("armor_negation", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                        weaponAttributeEditors.put("impact", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                        weaponAttributeEditors.put("max_strikes", Condition.ParameterEditor.of(value -> IntTag.valueOf((int)Integer.parseInt(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                        weaponAttributeEditors.put("damage_bonus", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                        weaponAttributeEditors.put("speed_bonus", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                        CompoundTag attrComp = compTag.getCompound("attributes");
                        for (Map.Entry e : attrComp.tags.entrySet()) {
                            CompoundTag comp = (CompoundTag)e.getValue();
                            for (Map.Entry attrEntry : comp.tags.entrySet()) {
                                if (((Tag)attrEntry.getValue()).getId() != 8) continue;
                                Condition.ParameterEditor paramEditor = (Condition.ParameterEditor)weaponAttributeEditors.get(attrEntry.getKey());
                                if (ParseUtil.isParsable(((Tag)attrEntry.getValue()).getAsString(), Double::parseDouble)) {
                                    comp.put((String)attrEntry.getKey(), paramEditor.toTag.apply(((Tag)attrEntry.getValue()).getAsString()));
                                    continue;
                                }
                                comp.remove((String)attrEntry.getKey());
                            }
                        }
                    }
                } else if (itemType == ItemType.ARMOR && compTag.contains("attributes", 10)) {
                    LinkedHashMap armorAttributeEditors = Maps.newLinkedHashMap();
                    armorAttributeEditors.put("stun_armor", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                    armorAttributeEditors.put("weight", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), null));
                    CompoundTag comp = compTag.getCompound("attributes");
                    for (Map.Entry attrEntry : comp.tags.entrySet()) {
                        if (((Tag)attrEntry.getValue()).getId() != 8) continue;
                        Condition.ParameterEditor paramEditor = (Condition.ParameterEditor)armorAttributeEditors.get(attrEntry.getKey());
                        if (ParseUtil.isParsable(((Tag)attrEntry.getValue()).getAsString(), Double::parseDouble)) {
                            comp.put((String)attrEntry.getKey(), paramEditor.toTag.apply(((Tag)attrEntry.getValue()).getAsString()));
                            continue;
                        }
                        comp.remove((String)attrEntry.getKey());
                    }
                }
                this.packList.add(PackEntry.ofValue(registryName, compTag));
                this.packListGrid.addRowWithDefaultValues("pack_item", registryName.toString());
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.info("Failed to import " + String.valueOf(registryName) + ": " + e.getMessage());
                throw e;
            }
            finally {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void exportEntries(ZipOutputStream out) throws Exception {
            for (PackEntry packEntry : this.packList) {
                String sItemType = ((CompoundTag)packEntry.getValue()).getString("item_type");
                try {
                    ItemType itemType = ItemType.valueOf(sItemType);
                    ((CompoundTag)packEntry.getValue()).remove("item_type");
                    ZipEntry zipEntry = new ZipEntry(String.format("data/%s/" + this.directory + "/%s/%s.json", ((ResourceLocation)packEntry.getKey()).getNamespace(), itemType.directoryName, ((ResourceLocation)packEntry.getKey()).getPath()));
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    CompoundTag tag = (CompoundTag)packEntry.getValue();
                    if (tag.contains("trail")) {
                        TrailInfo result = TrailInfo.ANIMATION_DEFAULT_TRAIL.overwrite(TrailInfo.deserialize(tag.getCompound("trail")));
                        if (result.playable()) {
                            ZipEntry asItemSkin = new ZipEntry(String.format("assets/%s/item_skins/%s.json", ((ResourceLocation)packEntry.getKey()).getNamespace(), ((ResourceLocation)packEntry.getKey()).getPath()));
                            CompoundTag itemSkinsTag = new CompoundTag();
                            itemSkinsTag.put("trail", (Tag)tag.getCompound("trail"));
                            out.putNextEntry(asItemSkin);
                            out.write(gson.toJson((JsonElement)ParseUtil.convertToJsonObject(itemSkinsTag)).getBytes());
                            out.closeEntry();
                        }
                        tag.remove("trail");
                    }
                    if (tag.contains("collider")) {
                        try {
                            ColliderPreset.deserializeSimpleCollider(tag.getCompound("collider"));
                        }
                        catch (Exception e) {
                            tag.remove("collider");
                        }
                    }
                    out.putNextEntry(zipEntry);
                    out.write(gson.toJson((JsonElement)ParseUtil.convertToJsonObject(tag)).getBytes());
                    out.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failded to export " + String.valueOf(packEntry.getKey()) + ". " + e.getMessage());
                }
                finally {
                    ((CompoundTag)packEntry.getValue()).putString("item_type", sItemType);
                }
            }
        }

        static enum ItemType {
            ARMOR("armors"),
            WEAPON("weapons");

            String directoryName;

            private ItemType(String directoryName) {
                this.directoryName = directoryName;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class MobCapabilityTab
    extends DatapackTab<EntityType<?>> {
        private final ModelPreviewer modelPreviewer;
        private final ComboBox<EntityType<?>> presetCombo;
        private final Consumer<EntityType<?>> presetResponder;
        private final CheckBox disableCheckBox;
        private final Consumer<Boolean> disableResponder;
        private final CheckBox isHumanoidCheckbox;
        private final Consumer<Boolean> isHumanoidResponder;
        private final Map<String, Condition.ParameterEditor> attributeEditors;
        private PopupBox.MeshPopupBox meshPopupBox;
        private PopupBox.ArmaturePopupBox armaturePopupBox;

        public MobCapabilityTab() {
            super((Component)Component.translatable((String)"gui.epicfight.tab.datapack.mob_patch"), "epicfight_mobpatch", BuiltInRegistries.ENTITY_TYPE, entityType -> entityType.getCategory() != MobCategory.MISC && entityType != EntityType.ENDER_DRAGON);
            this.presetCombo = new ComboBox<EntityType>(DatapackEditScreen.this, DatapackEditScreen.this.font, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.translatable((String)"datapack_edit.mob_patch.preset"), EpicFightCapabilities.ENTITY_PATCH_PROVIDER.getPatchedEntities(), entityType -> entityType == null ? "none" : EntityType.getKey((EntityType)entityType).toString(), null);
            this.presetResponder = entityType -> {
                CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                if (entityType == null) {
                    tag.remove("preset");
                } else {
                    tag.putString("preset", EntityType.getKey((EntityType)entityType).toString());
                }
                this.rearrangeComponents(false, entityType != null, tag.getBoolean("isHumanoid"));
                if (entityType == null) {
                    this.bindTag(tag);
                }
            };
            this.disableCheckBox = new CheckBox(DatapackEditScreen.this.font, 0, 60, 0, 10, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, false, (Component)Component.literal((String)""), null);
            this.disableResponder = value -> {
                CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                tag.putBoolean("disabled", value.booleanValue());
                boolean preset = tag.contains("preset", 8) && !StringUtil.isNullOrEmpty((String)tag.getString("preset"));
                boolean isHumanoid = tag.getBoolean("isHumanoid");
                this.rearrangeComponents((boolean)value, preset, isHumanoid);
                if (!value.booleanValue()) {
                    this.bindTag(tag);
                }
            };
            this.isHumanoidCheckbox = new CheckBox(DatapackEditScreen.this.font, 0, 60, 0, 10, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, false, (Component)Component.literal((String)""), null);
            this.isHumanoidResponder = value -> {
                CompoundTag tag = (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue();
                tag.putBoolean("isHumanoid", value.booleanValue());
                this.rearrangeComponents(false, false, (boolean)value);
                this.bindTag(tag);
            };
            this.attributeEditors = Maps.newLinkedHashMap();
            this.inputComponentsList = new InputComponentList<CompoundTag>((Screen)DatapackEditScreen.this, 0, 0, 0, 30){

                @Override
                public void importTag(CompoundTag tag) {
                    boolean preset;
                    boolean disabled = tag.getBoolean("disabled");
                    boolean bl = preset = tag.contains("preset", 8) && !StringUtil.isNullOrEmpty((String)tag.getString("preset"));
                    if (!tag.contains("isHumanoid")) {
                        tag.putBoolean("isHumanoid", false);
                    }
                    boolean isHumanoid = tag.getBoolean("isHumanoid");
                    MobCapabilityTab.this.rearrangeComponents(disabled, preset, isHumanoid);
                    this.setComponentsActive(true);
                    if (preset) {
                        MobCapabilityTab.this.presetCombo._setResponder((Consumer<EntityType<?>>)null);
                        this.setDataBindingComponenets(new Object[]{EntityType.byString((String)tag.getString("preset")).orElse(null)});
                        MobCapabilityTab.this.presetCombo._setResponder(MobCapabilityTab.this.presetResponder);
                    } else if (!disabled) {
                        MobCapabilityTab.this.bindTag(tag);
                    }
                }
            };
            this.modelPreviewer = new ModelPreviewer(9, 15, 0, 140, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, Armatures.BIPED, Meshes.BIPED);
            this.modelPreviewer.setColliderJoint(((HumanoidArmature)Armatures.BIPED.get()).toolR);
            this.meshPopupBox = new PopupBox.MeshPopupBox(DatapackEditScreen.this, DatapackEditScreen.this.font, 0, 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.model"), pair -> {
                if (this.armaturePopupBox._getValue() != null && ((AssetAccessor)this.armaturePopupBox._getValue()).isPresent() && pair.getSecond() != null && ((AssetAccessor)pair.getSecond()).isPresent() && ((SkinnedMesh)((AssetAccessor)pair.getSecond()).get()).getMaxJointCount() > ((Armature)((AssetAccessor)this.armaturePopupBox._getValue()).get()).getJointNumber()) {
                    this.meshPopupBox._setValue(null);
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    ((Armature)((AssetAccessor)this.armaturePopupBox._getValue()).get()).rootJoint.iterSubJoints(joint -> sb.append(joint.getName() + ", "));
                    sb.replace(sb.length() - 2, sb.length(), "");
                    sb.append("]");
                    throw new IllegalArgumentException(MessageFormat.format("The model requires {0} joints, but the armature only has {1}. {2}", ((SkinnedMesh)((AssetAccessor)this.meshPopupBox._getValue()).get()).getMaxJointCount(), ((Armature)((AssetAccessor)this.armaturePopupBox._getValue()).get()).getJointNumber(), sb.toString()));
                }
                ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("model", (String)pair.getFirst());
            });
            this.armaturePopupBox = new PopupBox.ArmaturePopupBox(DatapackEditScreen.this, DatapackEditScreen.this.font, 0, 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.armature"), pair -> {
                if (this.meshPopupBox._getValue() != null && ((AssetAccessor)this.meshPopupBox._getValue()).isPresent() && pair.getSecond() != null && ((AssetAccessor)pair.getSecond()).isPresent() && ((SkinnedMesh)((AssetAccessor)this.meshPopupBox._getValue()).get()).getMaxJointCount() > ((Armature)((AssetAccessor)pair.getSecond()).get()).getJointNumber()) {
                    this.armaturePopupBox._setValue(null);
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    ((Armature)((AssetAccessor)pair.getSecond()).get()).rootJoint.iterSubJoints(joint -> sb.append(joint.getName() + ", "));
                    sb.replace(sb.length() - 2, sb.length(), "");
                    sb.append("]");
                    throw new IllegalArgumentException(MessageFormat.format("The model requires {0} joints, but the armature only has {1}. {2}", ((SkinnedMesh)((AssetAccessor)this.meshPopupBox._getValue()).get()).getMaxJointCount(), ((Armature)((AssetAccessor)pair.getSecond()).get()).getJointNumber(), sb.toString()));
                }
                ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("armature", (String)pair.getFirst());
            });
            ResizableEditBox impactEditBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"impact"), null, null);
            ResizableEditBox armorNegationEditBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"armor_negation"), null, null);
            ResizableEditBox maxStrikesEditBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"max_strikes"), null, null);
            ResizableEditBox chasingSpeedEditBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"chasing_speed"), null, null);
            ResizableEditBox scaleEditBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"scale"), null, null);
            ResizableEditBox stunArmorBox = new ResizableEditBox(DatapackEditScreen.this.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"stun_armor"), null, null);
            impactEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            armorNegationEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            maxStrikesEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Integer::parseInt));
            chasingSpeedEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            scaleEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
            stunArmorBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
            this.attributeEditors.put("impact", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)impactEditBox));
            this.attributeEditors.put("armor_negation", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)armorNegationEditBox));
            this.attributeEditors.put("max_strikes", Condition.ParameterEditor.of(value -> IntTag.valueOf((int)Integer.parseInt(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)maxStrikesEditBox));
            this.attributeEditors.put("chasing_speed", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)chasingSpeedEditBox));
            this.attributeEditors.put("scale", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)scaleEditBox));
            this.attributeEditors.put("stun_armor", Condition.ParameterEditor.of(value -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), tag -> ParseUtil.valueOfOmittingType(tag.getAsString()), (AbstractWidget)stunArmorBox));
        }

        private void rearrangeComponents(boolean disable, boolean usePreset, boolean isHumanoid) {
            DatapackEditScreen parentScreen = DatapackEditScreen.this;
            ScreenRectangle screen = DatapackEditScreen.this.getRectangle();
            this.inputComponentsList.clearComponents();
            if (disable) {
                this.disableCheckBox._setResponder((Consumer<Boolean>)null);
                this.disableCheckBox._setValue(true);
                this.disableCheckBox._setResponder(this.disableResponder);
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.disabled"));
                this.inputComponentsList.addComponentCurrentRow(this.disableCheckBox.relocateX(screen, this.inputComponentsList.nextStart(5)));
            } else if (usePreset) {
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.preset"));
                this.inputComponentsList.addComponentCurrentRow(this.presetCombo.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.presetCombo._setResponder(this.presetResponder);
            } else {
                this.disableCheckBox._setResponder((Consumer<Boolean>)null);
                this.disableCheckBox._setValue(false);
                this.disableCheckBox._setResponder(this.disableResponder);
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.disabled"));
                this.inputComponentsList.addComponentCurrentRow(this.disableCheckBox.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.preset"));
                this.inputComponentsList.addComponentCurrentRow(this.presetCombo.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.presetCombo._setResponder(this.presetResponder);
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.model"));
                this.inputComponentsList.addComponentCurrentRow(this.meshPopupBox.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.armature"));
                this.inputComponentsList.addComponentCurrentRow(this.armaturePopupBox.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.renderer"));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.RendererPopupBox(parentScreen, DatapackEditScreen.this.font, this.inputComponentsList.nextStart(5), 15, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.renderer"), pair -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("renderer", (String)pair.getFirst())));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.humanoid"));
                this.inputComponentsList.addComponentCurrentRow(this.isHumanoidCheckbox.relocateX(screen, this.inputComponentsList.nextStart(5)));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.faction"));
                this.inputComponentsList.addComponentCurrentRow(new ComboBox<Faction>(parentScreen, parentScreen.getMinecraft().font, this.inputComponentsList.nextStart(5), 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.translatable((String)"datapack_edit.mob_patch.faction"), Faction.ENUM_MANAGER.universalValues(), faction -> ParseUtil.snakeToSpacedCamel(faction), faction -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("faction", ParseUtil.nullOrToString(faction, value -> value.toString().toLowerCase(Locale.ROOT)))));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.swing_sound"));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.SoundPopupBox(parentScreen, parentScreen.getMinecraft().font, this.inputComponentsList.nextStart(5), 15, 0, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.mob_patch.swing_sound"), soundevent -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("swing_sound", ParseUtil.getRegistryName((SoundEvent)soundevent.getSecond(), BuiltInRegistries.SOUND_EVENT))));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.hit_sound"));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.SoundPopupBox(parentScreen, parentScreen.getMinecraft().font, this.inputComponentsList.nextStart(5), 15, 0, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.mob_patch.hit_sound"), soundevent -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("hit_sound", ParseUtil.getRegistryName((SoundEvent)soundevent.getSecond(), BuiltInRegistries.SOUND_EVENT))));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.hit_particle"));
                this.inputComponentsList.addComponentCurrentRow(new PopupBox.RegistryPopupBox((Screen)parentScreen, DatapackEditScreen.this.font, this.inputComponentsList.nextStart(5), 15, 0, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.translatable((String)"datapack_edit.weapon_type.hit_particle"), BuiltInRegistries.PARTICLE_TYPE, pair -> ((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue()).putString("hit_particle", ParseUtil.getRegistryName((ParticleType)pair.getSecond(), BuiltInRegistries.PARTICLE_TYPE))));
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.attributes"));
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(Grid.builder(parentScreen, parentScreen.getMinecraft()).xy1(this.inputComponentsList.nextStart(5), 0).xy2(15, 90).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("attribute", List.copyOf(this.attributeEditors.values())).toDisplayText(editor -> ParseUtil.nullOrToString(editor, editor$1 -> ParseUtil.snakeToSpacedCamel(editor.editWidget.getMessage().getString()))).valueChanged(event -> {
                    CompoundTag attributesTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", CompoundTag::new);
                    if (event.prevValue != null) {
                        attributesTag.remove(((Condition.ParameterEditor)event.prevValue).editWidget.getMessage().getString());
                    } else {
                        attributesTag.remove("");
                    }
                    attributesTag.putString(ParseUtil.nullParam(((Condition.ParameterEditor)event.postValue).editWidget.getMessage().getString()), "");
                }).width(100)).addColumn(Grid.wildcard("amount").editWidgetProvider(row -> {
                    Condition.ParameterEditor editor = (Condition.ParameterEditor)row.getValue("attribute");
                    return editor == null ? null : editor.editWidget;
                }).valueChanged(event -> {
                    CompoundTag attributesTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", CompoundTag::new);
                    Condition.ParameterEditor editor = (Condition.ParameterEditor)event.grid.getValue(event.rowposition, "attribute");
                    if (!StringUtil.isNullOrEmpty((String)ParseUtil.nullParam(event.postValue))) {
                        attributesTag.put(editor.editWidget.getMessage().getString(), editor.toTag.apply(event.postValue));
                    } else {
                        attributesTag.remove(editor.editWidget.getMessage().getString());
                    }
                }).width(150)).pressAdd((grid, button) -> {
                    CompoundTag attributeTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", new CompoundTag());
                    attributeTag.putString("", "");
                    int rowposition = grid.addRow();
                    grid.setGridFocus(rowposition, "attribute");
                }).pressRemove((grid, button) -> {
                    int rowposition = grid.getRowposition();
                    if (rowposition > -1) {
                        CompoundTag attributeTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "attributes", new CompoundTag());
                        attributeTag.remove(ParseUtil.nullParam(grid.getValue(rowposition, "attribute")));
                        grid.removeRow(rowposition);
                    }
                }).build());
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.default_livingmotions"));
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(Grid.builder(DatapackEditScreen.this).xy1(this.inputComponentsList.nextStart(5), 0).xy2(15, 90).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("living_motion", List.of(LivingMotions.IDLE, LivingMotions.WALK, LivingMotions.CHASE, LivingMotions.MOUNT, LivingMotions.FALL, LivingMotions.FLOAT, LivingMotions.DEATH, LivingMotions.RELOAD, LivingMotions.AIM)).valueChanged(event -> {
                    CompoundTag livingMotionTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "default_livingmotions", CompoundTag::new);
                    livingMotionTag.remove(ParseUtil.nullParam(event.prevValue));
                    livingMotionTag.putString(ParseUtil.nullOrToString((LivingMotions)event.postValue, livingmotion -> livingmotion.name().toLowerCase(Locale.ROOT)), "");
                }).editable(true).width(100)).addColumn(Grid.popup("animation", PopupBox.AnimationPopupBox::new).filter(accessor -> !accessor.checkType(MainFrameAnimation.class) || accessor.checkType(LongHitAnimation.class)).editWidgetCreated(popupBox -> popupBox.setModel((AssetAccessor)this.armaturePopupBox._getValue(), (AssetAccessor)this.meshPopupBox._getValue())).valueChanged(event -> {
                    CompoundTag livingMotionTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "default_livingmotions", CompoundTag::new);
                    livingMotionTag.putString(ParseUtil.nullOrToString((LivingMotions)event.grid.getValue(event.rowposition, "living_motion"), livingmotion -> livingmotion.name().toLowerCase(Locale.ROOT)), ParseUtil.nullOrToString((AssetAccessor)event.postValue, animation -> animation.registryName().toString()));
                }).toDisplayText(item -> item == null ? "" : item.registryName().toString()).width(150)).pressAdd((grid, button) -> {
                    CompoundTag attributeTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "default_livingmotions", new CompoundTag());
                    attributeTag.putString("", "");
                    int rowposition = grid.addRow();
                    grid.setGridFocus(rowposition, "living_motion");
                }).pressRemove((grid, button) -> {
                    int rowposition = grid.getRowposition();
                    if (rowposition > -1) {
                        CompoundTag livingMotionTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "default_livingmotions", new CompoundTag());
                        livingMotionTag.remove(ParseUtil.nullParam(grid.getValue(rowposition, "living_motion")).toLowerCase(Locale.ROOT));
                        grid.removeRow(rowposition);
                    }
                }).build());
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 100, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.stun_animations"));
                this.inputComponentsList.newRow();
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(Grid.builder(DatapackEditScreen.this).xy1(this.inputComponentsList.nextStart(5), 0).xy2(15, 90).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).addColumn(Grid.combo("stun_type", List.of(StunType.values())).toDisplayText(stunType -> ParseUtil.nullOrToString(stunType, type -> ParseUtil.snakeToSpacedCamel(type.name()))).valueChanged(event -> {
                    CompoundTag attributesTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "stun_animations", CompoundTag::new);
                    attributesTag.remove(ParseUtil.nullParam(event.prevValue));
                    attributesTag.putString(ParseUtil.nullOrToString((StunType)((Object)((Object)event.postValue)), stunType -> stunType.name().toLowerCase(Locale.ROOT)), "");
                }).editable(true).width(100)).addColumn(Grid.popup("animation", PopupBox.AnimationPopupBox::new).filter(animation -> animation instanceof HitAnimation || animation instanceof LongHitAnimation).editWidgetCreated(popupBox -> popupBox.setModel((AssetAccessor)this.armaturePopupBox._getValue(), (AssetAccessor)this.meshPopupBox._getValue())).valueChanged(event -> {
                    CompoundTag stunTypeTag = ParseUtil.getOrSupply((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "stun_animations", CompoundTag::new);
                    stunTypeTag.putString(ParseUtil.nullOrToString((StunType)((Object)((Object)event.grid.getValue(event.rowposition, "stun_type"))), stunType -> stunType.name().toLowerCase(Locale.ROOT)), ParseUtil.nullOrToString((AssetAccessor)event.postValue, animation -> animation.registryName().toString()));
                }).toDisplayText(item -> item == null ? "" : item.registryName().toString()).width(150)).pressAdd((grid, button) -> {
                    CompoundTag attributeTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "stun_animations", new CompoundTag());
                    attributeTag.putString("", "");
                    int rowposition = grid.addRow();
                    grid.setGridFocus(rowposition, "stun_type");
                }).pressRemove((grid, button) -> {
                    int rowposition = grid.getRowposition();
                    if (rowposition > -1) {
                        CompoundTag stunTypeTag = ParseUtil.getOrDefaultTag((CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), "stun_animations", new CompoundTag());
                        stunTypeTag.remove(ParseUtil.nullOrToString((StunType)((Object)((Object)grid.getValue(rowposition, "stun_type"))), stunType -> stunType.name().toLowerCase(Locale.ROOT)));
                        grid.removeRow(rowposition);
                    }
                }).build());
                this.inputComponentsList.newRow();
                if (isHumanoid) {
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 140, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.humanoid_weapon_motions"));
                    this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> {
                        if (this.armaturePopupBox._getValue() == null || this.meshPopupBox._getValue() == null) {
                            return new MessageScreen("", "Define model and armature first.", DatapackEditScreen.this, button2 -> DatapackEditScreen.this.getMinecraft().setScreen((Screen)DatapackEditScreen.this), 180, 60);
                        }
                        return new HumanoidWeaponMotionScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), (AssetAccessor)this.armaturePopupBox._getValue(), (AssetAccessor)this.meshPopupBox._getValue());
                    }).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
                }
                this.inputComponentsList.newRow();
                this.inputComponentsList.addComponentCurrentRow(new Static((Screen)parentScreen, this.inputComponentsList.nextStart(4), 140, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.mob_patch.combat_behavior"));
                this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> {
                    if (this.armaturePopupBox._getValue() == null || this.meshPopupBox._getValue() == null) {
                        return new MessageScreen("", "Define model and armature first.", DatapackEditScreen.this, button2 -> DatapackEditScreen.this.getMinecraft().setScreen((Screen)DatapackEditScreen.this), 180, 60);
                    }
                    if (isHumanoid) {
                        return new HumanoidCombatBehaviorScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), (AssetAccessor)this.armaturePopupBox._getValue(), (AssetAccessor)this.meshPopupBox._getValue());
                    }
                    return new CombatBehaviorScreen(DatapackEditScreen.this, (CompoundTag)((PackEntry)this.packList.get(this.packListGrid.getRowposition())).getValue(), (AssetAccessor)this.armaturePopupBox._getValue(), (AssetAccessor)this.meshPopupBox._getValue(), false);
                }).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
            }
            this.inputComponentsList.setX(164);
        }

        private void bindTag(CompoundTag tag) {
            this.presetCombo._setResponder((Consumer<EntityType<?>>)null);
            this.disableCheckBox._setResponder((Consumer<Boolean>)null);
            this.isHumanoidCheckbox._setResponder((Consumer<Boolean>)null);
            Grid.PackImporter attributePackImporter = new Grid.PackImporter();
            Grid.PackImporter livingmotionPackImporter = new Grid.PackImporter();
            Grid.PackImporter stunPackImporter = new Grid.PackImporter();
            for (Map.Entry attributesTag : tag.getCompound((String)"attributes").tags.entrySet()) {
                Condition.ParameterEditor editor = this.attributeEditors.get(attributesTag.getKey());
                attributePackImporter.newRow();
                attributePackImporter.newValue("attribute", editor);
                attributePackImporter.newValue("amount", ParseUtil.valueOfOmittingType(((Tag)attributesTag.getValue()).getAsString()));
            }
            for (Map.Entry livingmotionTag : tag.getCompound((String)"default_livingmotions").tags.entrySet()) {
                LivingMotion livingMotion = LivingMotion.ENUM_MANAGER.get(((String)livingmotionTag.getKey()).toUpperCase(Locale.ROOT));
                livingmotionPackImporter.newRow();
                livingmotionPackImporter.newValue("living_motion", livingMotion);
                livingmotionPackImporter.newValue("animation", DatapackEditScreen.animationByKey(((Tag)livingmotionTag.getValue()).getAsString()));
            }
            for (Map.Entry stunTag : tag.getCompound((String)"stun_animations").tags.entrySet()) {
                StunType stunType = ParseUtil.enumValueOfOrNull(StunType.class, ((String)stunTag.getKey()).toUpperCase(Locale.ROOT));
                stunPackImporter.newRow();
                stunPackImporter.newValue("stun_type", (Object)stunType);
                stunPackImporter.newValue("animation", DatapackEditScreen.animationByKey(((Tag)stunTag.getValue()).getAsString()));
            }
            this.inputComponentsList.setDataBindingComponenets(new Object[]{false, EntityType.byString((String)tag.getString("preset")).orElse(null), DatapackEditScreen.getMesh(tag.getString("model")), DatapackEditScreen.getArmature(tag.getString("armature")), StringUtil.isNullOrEmpty((String)tag.getString("renderer")) ? null : ResourceLocation.parse((String)tag.getString("renderer")), tag.getBoolean("isHumanoid"), ParseUtil.nullOrApply(tag.get("faction"), jsonElement -> Faction.ENUM_MANAGER.getOrThrow(jsonElement.getAsString())), BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("swing_sound"))), BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)tag.getString("hit_sound"))), BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)tag.getString("hit_particle"))), attributePackImporter, livingmotionPackImporter, stunPackImporter});
            this.presetCombo._setResponder(this.presetResponder);
            this.disableCheckBox._setResponder(this.disableResponder);
            this.isHumanoidCheckbox._setResponder(this.isHumanoidResponder);
        }

        @Override
        public void packGridRowpositionChanged(int rowposition, Map<String, Object> values) {
            this.inputComponentsList.importTag((CompoundTag)((PackEntry)this.packList.get(rowposition)).getValue());
        }

        @Override
        public void validateBeforeExport() {
            for (PackEntry packEntry : this.packList) {
                try {
                    Optional type = EntityType.byString((String)((ResourceLocation)packEntry.getKey()).toString());
                    if (type.isEmpty()) {
                        throw new IllegalStateException("Invalid entity type");
                    }
                    MobPatchReloadListener.deserializeMobPatchProvider((EntityType)type.get(), (CompoundTag)packEntry.getValue(), true, Minecraft.getInstance().getResourceManager());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to export mobpatch " + String.valueOf(packEntry.getKey()) + " :\n" + e.getMessage());
                }
            }
        }

        @Override
        public void importEntries(PackResources packResources) {
            packResources.getNamespaces(PackType.SERVER_DATA).stream().distinct().forEach(namespace -> packResources.listResources(PackType.SERVER_DATA, namespace, this.directory, (resourceLocation, streamSupplier) -> {
                ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)resourceLocation.getPath().replaceAll(String.format("%s/", this.directory), "").replaceAll(".json", ""));
                try {
                    this.importJson(rl, (InputStream)streamSupplier.get());
                }
                catch (Exception e) {
                    EpicFightMod.LOGGER.info("Failed to import " + String.valueOf(resourceLocation) + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void importJson(ResourceLocation registryName, InputStream inputStream) throws Exception {
            InputStreamReader reader = new InputStreamReader(inputStream);
            StringBuilder sb = new StringBuilder();
            Throwable exception = null;
            try {
                ListTag combatBehaviorList;
                int data = reader.read();
                while (data != -1) {
                    sb.append((char)data);
                    data = reader.read();
                }
                CompoundTag compTag = TagParser.parseTag((String)sb.toString());
                if (compTag.getBoolean("isHumanoid") && !(combatBehaviorList = compTag.getList("combat_behavior", 10)).isEmpty()) {
                    compTag.remove("combat_behavior");
                    compTag.put("combat_behavior_humanoid", (Tag)combatBehaviorList);
                }
                this.packList.add(PackEntry.of(registryName, () -> compTag));
                this.packListGrid.addRowWithDefaultValues("pack_item", registryName.toString());
            }
            catch (CommandSyntaxException | IOException e) {
                exception = e;
            }
            finally {
                reader.close();
            }
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public void exportEntries(ZipOutputStream out) throws Exception {
            for (PackEntry packEntry : this.packList) {
                try {
                    CompoundTag packCompound = (CompoundTag)packEntry.getValue();
                    if (packCompound.getBoolean("disabled")) {
                        packCompound.tags.clear();
                        packCompound.putBoolean("disabled", true);
                    } else if (packCompound.contains("preset")) {
                        String preset = packCompound.getString("preset");
                        packCompound.tags.clear();
                        packCompound.putString("preset", preset);
                    } else {
                        packCompound.remove("disabled");
                    }
                    if (packCompound.getBoolean("isHumanoid")) {
                        ListTag humanoidCombatBehavior = packCompound.getList("combat_behavior_humanoid", 10);
                        packCompound.remove("combat_behavior_humanoid");
                        packCompound.put("combat_behavior", (Tag)humanoidCombatBehavior);
                    }
                    ZipEntry zipEntry = new ZipEntry(String.format("data/%s/" + this.directory + "/%s.json", ((ResourceLocation)packEntry.getKey()).getNamespace(), ((ResourceLocation)packEntry.getKey()).getPath()));
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    out.putNextEntry(zipEntry);
                    out.write(gson.toJson((JsonElement)ParseUtil.convertToJsonObject(packCompound)).getBytes());
                    out.closeEntry();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failded to export " + String.valueOf(packEntry.getKey()) + ". " + e.getMessage());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    abstract class DatapackTab<T>
    extends GridLayoutTab
    implements TickableComponent {
        protected Grid packListGrid;
        protected InputComponentList<CompoundTag> inputComponentsList;
        protected final Registry<T> registry;
        protected final Set<ResourceLocation> namesSet;
        protected final List<PackEntry<ResourceLocation, CompoundTag>> packList;
        protected final String directory;

        public DatapackTab(Component title, @Nullable String directory, Registry<T> registry) {
            this(title, directory, registry, item -> true);
        }

        public DatapackTab(Component title, @Nullable String directory, Registry<T> registry, Predicate<T> filter) {
            super(title);
            this.namesSet = Sets.newHashSet();
            this.packList = Lists.newLinkedList();
            this.directory = directory;
            ScreenRectangle screenRect = DatapackEditScreen.this.getRectangle();
            this.packListGrid = Grid.builder(DatapackEditScreen.this).xy1(8, screenRect.top() + 14).xy2(150, screenRect.height() - screenRect.top() - 7).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).rowpositionChanged(this::packGridRowpositionChanged).addColumn(Grid.editbox("pack_item").editWidgetCreated(editbox -> editbox.setFilter(str -> ResourceLocation.isValidNamespace((String)str) && ResourceLocation.isValidPath((String)str))).valueChanged(event -> this.packList.get(event.rowposition).setPackKey(ResourceLocation.parse((String)((String)event.postValue)))).defaultVal(EpicFightMod.prefix("")).editable(registry == null).width(180)).pressAdd((grid, button) -> {
                if (registry != null) {
                    DatapackEditScreen.this.minecraft.setScreen(new SelectFromRegistryScreen<Object>(DatapackEditScreen.this, registry, (registryName, selItem) -> {
                        grid.setValueChangeEnabled(false);
                        int rowposition = grid.addRowWithDefaultValues("pack_item", registryName);
                        this.packList.add(rowposition, PackEntry.of(ResourceLocation.parse((String)registryName), CompoundTag::new));
                        grid.setGridFocus(rowposition, "pack_item");
                        grid.setValueChangeEnabled(true);
                    }, (registryName, selItem) -> {}, filter));
                } else {
                    grid.setValueChangeEnabled(false);
                    int rowposition = grid.addRowWithDefaultValues("pack_item", EpicFightMod.prefix(""));
                    this.packList.add(rowposition, PackEntry.of(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)""), CompoundTag::new));
                    grid.setGridFocus(rowposition, "pack_item");
                    grid.setValueChangeEnabled(true);
                }
                DatapackEditScreen.this.setFocused((GuiEventListener)grid);
            }).pressRemove((grid, button) -> {
                grid.removeRow(removedRow -> this.packList.remove(removedRow));
                if (this.packList.size() == 0) {
                    this.inputComponentsList.setComponentsActive(false);
                }
            }).build();
            this.registry = registry;
        }

        public void doLayout(ScreenRectangle screenRectangle) {
            this.layout.arrangeElements();
            this.layout.setY(screenRectangle.top());
            this.packListGrid.updateSizeAndPosition(150, screenRectangle.height() - screenRectangle.top() - 7, screenRectangle.top() + 14);
            this.inputComponentsList.updateSizeAndPosition(screenRectangle.width() - 172, screenRectangle.height() - screenRectangle.top() - 7, screenRectangle.top() + 14);
            this.packListGrid.setX(8);
            this.inputComponentsList.setX(164);
        }

        @Override
        public void _tick() {
            this.inputComponentsList.tick();
        }

        public void clear() {
            this.packList.clear();
            this.packListGrid.reset();
            this.inputComponentsList.resetComponents();
            this.inputComponentsList.setComponentsActive(false);
        }

        public void packGridRowpositionChanged(int rowposition, Map<String, Object> values) {
            this.inputComponentsList.importTag(this.packList.get(rowposition).getValue());
        }

        public abstract void validateBeforeExport();

        public abstract void importEntries(PackResources var1) throws Exception;

        public abstract void exportEntries(ZipOutputStream var1) throws Exception;
    }
}

