/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import yesman.epicfight.api.client.online.EpicFightServerConnectionHelper;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.screen.config.EpicFightControlOptionScreen;
import yesman.epicfight.client.gui.screen.config.EpicFightGraphicOptionScreen;

@OnlyIn(value=Dist.CLIENT)
public class IngameConfigurationScreen
extends Screen {
    protected final Screen parentScreen;

    public IngameConfigurationScreen(ModContainer mod, Screen screen) {
        super((Component)Component.translatable((String)"gui.epicfight.configurations"));
        this.parentScreen = screen;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.epicfight.button.graphics"), button -> Minecraft.getInstance().setScreen((Screen)new EpicFightGraphicOptionScreen(this))).pos(this.width / 2 - 165, 42).size(160, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.epicfight.button.controls"), button -> Minecraft.getInstance().setScreen((Screen)new EpicFightControlOptionScreen(this))).pos(this.width / 2 + 5, 42).size(160, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.epicfight.button.datapack_edit"), button -> Minecraft.getInstance().setScreen((Screen)new DatapackEditScreen(this))).pos(this.width / 2 - 165, 68).size(160, 20).build());
        if (ClientEngine.getInstance().getAuthHelper().valid()) {
            Button skinConfigScreen = Button.builder((Component)Component.translatable((String)"gui.epicskins.button.skin_configuration"), button -> {
                if (Minecraft.getInstance().level == null) {
                    Minecraft.getInstance().setScreen(ClientEngine.getInstance().getAuthHelper().getAvatarEditorScreen(this));
                } else {
                    Minecraft.getInstance().setScreen(new MessageScreen("Warning", "You may not open avatar screen while in the world", this, button2 -> Minecraft.getInstance().setScreen((Screen)this), 300, 70).autoCalculateHeight());
                }
            }).pos(this.width / 2 + 5, 68).size(160, 20).build();
            skinConfigScreen.active = EpicFightServerConnectionHelper.supported();
            this.addRenderableWidget((GuiEventListener)skinConfigScreen);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(this.parentScreen)).bounds(this.width / 2 - 100, this.height - 40, 200, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }
}

