/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.shader.compute.backend.buffers;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.Closeable;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.function.BiConsumer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.IArrayBufferProxy;

@OnlyIn(value=Dist.CLIENT)
public class DynamicSSBO<T>
implements Closeable,
IArrayBufferProxy {
    public final T[] src;
    public final short srcSize;
    public final int glSSBO;
    public final DataMode mode;
    public final BiConsumer<T, FloatBuffer> uploader;
    private final FloatBuffer buffer;
    private int lastBinding = -1;

    public DynamicSSBO(T[] src, short srcSize, DataMode DataMode2, BiConsumer<T, FloatBuffer> uploader) {
        this.src = src;
        this.mode = DataMode2;
        this.srcSize = srcSize;
        this.uploader = uploader;
        this.glSSBO = GlStateManager._glGenBuffers();
        GlStateManager._glBindBuffer((int)37074, (int)this.glSSBO);
        GlStateManager._glBufferData((int)37074, (long)((long)src.length * (long)srcSize * 4L), (int)this.mode.glMode);
        GlStateManager._glBindBuffer((int)37074, (int)0);
        this.buffer = BufferUtils.createByteBuffer((int)(src.length * srcSize * 4)).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    @Override
    public void updateAll() {
        GlStateManager._glBindBuffer((int)37074, (int)this.glSSBO);
        for (T s : this.src) {
            this.uploader.accept(s, this.buffer);
        }
        this.buffer.position(0);
        GL15C.glBufferSubData((int)37074, (long)0L, (FloatBuffer)this.buffer);
        GlStateManager._glBindBuffer((int)37074, (int)0);
    }

    @Override
    public void updateFromTo(int from, int to) {
        GlStateManager._glBindBuffer((int)37074, (int)this.glSSBO);
        for (int i = from; i < to; ++i) {
            this.uploader.accept(this.src[i], this.buffer);
        }
        this.buffer.position(0);
        GL15C.glBufferSubData((int)37074, (long)((long)this.srcSize * 4L * (long)from), (FloatBuffer)this.buffer);
        GlStateManager._glBindBuffer((int)37074, (int)0);
    }

    @Override
    public void bindBufferBase(int binding) {
        this.unbind();
        this.lastBinding = binding;
        GL30C.glBindBufferBase((int)37074, (int)binding, (int)this.glSSBO);
    }

    @Override
    public void unbind() {
        if (this.lastBinding >= 0) {
            GL30C.glBindBufferBase((int)37074, (int)this.lastBinding, (int)0);
        }
    }

    @Override
    public void close() {
        if (this.glSSBO != 0) {
            GlStateManager._glDeleteBuffers((int)this.glSSBO);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum DataMode {
        STATIC(35044),
        DYNAMIC(35048),
        STREAM(35040);

        public final int glMode;

        private DataMode(int glMode) {
            this.glMode = glMode;
        }
    }
}

