/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.renderer.entity.layers.VampirePlayerHeadLayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PPlayerRenderer;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.mixin.teamlapen.MixinVampirePlayerHeadLayer;

public class VampirismCompat
implements ICompatModule {
    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onGameEventBus(IEventBus eventBus) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus eventBus) {
        eventBus.addListener(event -> {
            PatchedEntityRenderer patt0$temp = event.get(EntityType.PLAYER);
            if (patt0$temp instanceof PPlayerRenderer) {
                PPlayerRenderer playerrenderer = (PPlayerRenderer)patt0$temp;
                playerrenderer.addPatchedLayerAlways(VampirePlayerHeadLayer.class, new EpicFightVampirePlayerHeadLayer());
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onGameEventBusClient(IEventBus eventBus) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EpicFightVampirePlayerHeadLayer
    extends ModelRenderLayer<AbstractClientPlayer, AbstractClientPlayerPatch<AbstractClientPlayer>, PlayerModel<AbstractClientPlayer>, VampirePlayerHeadLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>, HumanoidMesh> {
        public EpicFightVampirePlayerHeadLayer() {
            super(Meshes.BIPED);
        }

        @Override
        protected void renderLayer(AbstractClientPlayerPatch<AbstractClientPlayer> entitypatch, AbstractClientPlayer entityliving, VampirePlayerHeadLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> vanillaLayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
            if (!((Boolean)VampirismConfig.CLIENT.renderVampireEyes.get()).booleanValue() || !entityliving.isAlive()) {
                return;
            }
            VampirismPlayerAttributes atts = VampirismPlayerAttributes.get((Player)entityliving);
            if (atts.vampireLevel > 0 && !atts.getVampSpecial().disguised && !entityliving.isInvisible()) {
                MixinVampirePlayerHeadLayer accessor = (MixinVampirePlayerHeadLayer)vanillaLayer;
                int eyeType = Math.max(0, Math.min(atts.getVampSpecial().eyeType, accessor.getEyeOverlays().length - 1));
                int fangType = Math.max(0, Math.min(atts.getVampSpecial().fangType, accessor.getFangOverlays().length - 1));
                int packerOverlay = LivingEntityRenderer.getOverlayCoords((LivingEntity)entityliving, (float)0.0f);
                RenderType eyeRenderType = EpicFightRenderTypes.getTriangulated(atts.getVampSpecial().glowingEyes ? RenderType.eyes((ResourceLocation)accessor.getEyeOverlays()[eyeType]) : RenderType.entityCutoutNoCull((ResourceLocation)accessor.getEyeOverlays()[eyeType]));
                ((HumanoidMesh)this.mesh.get()).draw(poseStack, buffer, eyeRenderType, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, packerOverlay, entitypatch.getArmature(), poses);
                RenderType fangRenderType = EpicFightRenderTypes.getTriangulated(RenderType.entityCutoutNoCull((ResourceLocation)accessor.getFangOverlays()[fangType]));
                ((HumanoidMesh)this.mesh.get()).draw(poseStack, buffer, fangRenderType, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, packerOverlay, entitypatch.getArmature(), poses);
            }
        }
    }
}

