/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.server.commands.arguments.AnimationArgument;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AnimatorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"epicfight").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animator").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"play").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument((String)"animation", (ArgumentType)AnimationArgument.animation()).executes(commandContext -> AnimatorCommand.playAnimation(EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), AnimationArgument.getAnimation((CommandContext<CommandSourceStack>)commandContext, "animation"), 0.0f))).then(Commands.argument((String)"transitionTimeModifier", (ArgumentType)FloatArgumentType.floatArg()).executes(commandContext -> AnimatorCommand.playAnimation(EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), AnimationArgument.getAnimation((CommandContext<CommandSourceStack>)commandContext, "animation"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"transitionTimeModifier")))))))).then(Commands.literal((String)"soft_pause").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"paused", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> AnimatorCommand.softPause(EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"paused"))))))).then(Commands.literal((String)"hard_pause").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"paused", (ArgumentType)BoolArgumentType.bool()).executes(commandContext -> AnimatorCommand.hardPause(EntityArgument.getEntities((CommandContext)commandContext, (String)"targets"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"paused"))))))));
    }

    public static int playAnimation(Collection<? extends Entity> targetEntities, AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.playAnimationSynchronized(animation, transitionTimeModifier);
        }
        return successEntityNum;
    }

    public static int softPause(Collection<? extends Entity> targetEntities, boolean paused) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.pauseAnimator(AbstractAnimatorControl.Action.SOFT_PAUSE, paused);
        }
        return successEntityNum;
    }

    public static int hardPause(Collection<? extends Entity> targetEntities, boolean paused) {
        int successEntityNum = 0;
        for (Entity entity : targetEntities) {
            LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if (entitypatch == null) continue;
            ++successEntityNum;
            entitypatch.pauseAnimator(AbstractAnimatorControl.Action.HARD_PAUSE, paused);
        }
        return successEntityNum;
    }
}

