/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.registry.entries.EpicFightSynchedAnimationVariableKeys;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class SteelWhirlwindSkill
extends WeaponInnateSkill
implements ChargeableSkill {
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> chargingAnimation = Animations.STEEL_WHIRLWIND_CHARGING;
    private AnimationManager.AnimationAccessor<? extends AttackAnimation> attackAnimation = Animations.STEEL_WHIRLWIND;

    public SteelWhirlwindSkill(WeaponInnateSkill.Builder<?> builder) {
        super(builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    public void movementInputUpdateEvent(MovementInputUpdateEvent event, SkillContainer skillContainer) {
        if (skillContainer.getExecutor().isHoldingSkill(this)) {
            LocalPlayer clientPlayer = (LocalPlayer)skillContainer.getClientExecutor().getOriginal();
            clientPlayer.setSprinting(false);
            clientPlayer.sprintTriggerTime = -1;
            Minecraft mc = Minecraft.getInstance();
            ControlEngine.setKeyBind(mc.options.keySprint, false);
            event.getInput().forwardImpulse *= 1.0f - 0.8f * (float)skillContainer.getExecutor().getSkillChargingTicks() / 30.0f;
        }
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        AttackAnimation anim = (AttackAnimation)this.attackAnimation.get();
        for (AttackAnimation.Phase phase : anim.phases) {
            phase.addProperties(((Map)this.properties.get(0)).entrySet());
        }
        return this;
    }

    @Override
    public int getAllowedMaxChargingTicks() {
        return 60;
    }

    @Override
    public int getMaxChargingTicks() {
        return 30;
    }

    @Override
    public int getMinChargingTicks() {
        return 6;
    }

    @Override
    public void startHolding(SkillContainer container) {
        AssetAccessor<? extends StaticAnimation> currentPlaying = ((Animator)container.getExecutor().getAnimator()).getPlayerFor(null).getRealAnimation();
        if (currentPlaying.get().isMainFrameAnimation()) {
            container.getExecutor().stopPlaying(currentPlaying);
        }
        container.getExecutor().playAnimationSynchronized(this.chargingAnimation, 0.0f);
    }

    @Override
    public void resetHolding(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            ((Animator)container.getExecutor().getAnimator()).stopPlaying(this.chargingAnimation);
        } else {
            container.getExecutor().stopPlaying(this.chargingAnimation);
        }
    }

    @Override
    public void onStopHolding(SkillContainer container, SPSkillFeedback feedback) {
        ((Animator)container.getExecutor().getAnimator()).getVariables().put((AnimationVariables.IndependentVariableKey)EpicFightSynchedAnimationVariableKeys.CHARGING_TICKS.get(), this.attackAnimation, container.getExecutor().getAccumulatedChargeTicks());
        container.getExecutor().playAnimationSynchronized(this.attackAnimation, 0.0f);
        this.cancelOnServer(container, null);
    }

    @Override
    public void holdTick(SkillContainer container) {
        ChargeableSkill.super.holdTick(container);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeyMapping() {
        return EpicFightKeyMappings.WEAPON_INNATE_SKILL;
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }
}

