/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public interface BossPatch<T extends Entity> {
    public BossEvent getBossEvent();

    public T getOriginal();

    default public void recordBossEventOwner(ServerPlayer trackingPlayer) {
        SPEntityPairingPacket packet = new SPEntityPairingPacket(this.getOriginal().getId(), EntityPairingPacketTypes.SET_BOSS_EVENT_OWNER);
        packet.buffer().writeBoolean(true);
        packet.buffer().writeUUID(this.getBossEvent().getId());
        EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new CustomPacketPayload[0]);
    }

    default public void removeBossEventOwner(ServerPlayer trackingPlayer) {
        SPEntityPairingPacket packet = new SPEntityPairingPacket(this.getOriginal().getId(), EntityPairingPacketTypes.SET_BOSS_EVENT_OWNER);
        packet.buffer().writeBoolean(false);
        packet.buffer().writeUUID(this.getBossEvent().getId());
        EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new CustomPacketPayload[0]);
    }

    default public <P extends LivingEntityPatch<?>> P cast() {
        return (P)((LivingEntityPatch)((Object)this));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void processOwnerRecordPacket(FriendlyByteBuf buffer) {
        boolean addOperation = buffer.readBoolean();
        UUID eventUUID = buffer.readUUID();
        if (addOperation) {
            RenderEngine.getInstance().addBossEventOwner(eventUUID, this);
        } else {
            RenderEngine.getInstance().removeBossEventOwner(eventUUID, this);
        }
    }
}

