/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.physics.PhysicsSimulator;
import yesman.epicfight.api.physics.SimulationTypes;
import yesman.epicfight.api.physics.ik.InverseKinematicsProvider;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulatable;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulator;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.data.loot.function.SetSkillFunction;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.DragonArmature;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.registry.entries.EpicFightSkills;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.BossPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonAirstrikePhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonCrystalLinkPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PhaseManagerPatch;
import yesman.epicfight.world.damagesource.StunType;

public class EnderDragonPatch
extends MobPatch<EnderDragon>
implements InverseKinematicsSimulatable,
BossPatch<EnderDragon> {
    public static final TargetingConditions DRAGON_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight();
    private final Map<LivingMotions, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotions = Maps.newHashMap();
    private final Object2IntMap<Player> contributors = new Object2IntOpenHashMap();
    private boolean groundPhase;
    public LivingMotion prevMotion = LivingMotions.FLY;
    private float xRoot;
    private float xRootO;
    private float zRoot;
    private float zRootO;
    private final InverseKinematicsSimulator ikSimulator = new InverseKinematicsSimulator();

    public EnderDragonPatch(EnderDragon entity) {
        super(entity);
        this.livingMotions.put(LivingMotions.IDLE, Animations.DRAGON_IDLE);
        this.livingMotions.put(LivingMotions.WALK, Animations.DRAGON_WALK);
        this.livingMotions.put(LivingMotions.FLY, Animations.DRAGON_FLY);
        this.livingMotions.put(LivingMotions.CHASE, Animations.DRAGON_AIRSTRIKE);
        this.livingMotions.put(LivingMotions.DEATH, Animations.DRAGON_DEATH);
        this.currentLivingMotion = LivingMotions.FLY;
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.getBossEvent() != null) {
            this.recordBossEventOwner(trackingPlayer);
        }
    }

    @Override
    public void onStopTracking(ServerPlayer trackingPlayer) {
        if (this.getBossEvent() != null) {
            this.removeBossEventOwner(trackingPlayer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType() == EntityPairingPacketTypes.SET_BOSS_EVENT_OWNER) {
            this.processOwnerRecordPacket(packet.buffer());
        }
    }

    @Override
    public void onJoinWorld(EnderDragon enderdragon, EntityJoinLevelEvent event) {
        super.onJoinWorld(enderdragon, event);
        DragonPhaseInstance currentPhase = ((EnderDragon)this.original).phaseManager.getCurrentPhase();
        EnderDragonPhase startPhase = currentPhase == null || !(currentPhase instanceof PatchedDragonPhase) ? PatchedPhases.FLYING : ((EnderDragon)this.original).phaseManager.getCurrentPhase().getPhase();
        ((EnderDragon)this.original).phaseManager = new PhaseManagerPatch((EnderDragon)this.original, this);
        ((EnderDragon)this.original).phaseManager.setPhase(startPhase);
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.ENDER_DRAGON, EpicFightAttributes.IMPACT, 8.0);
        event.add(EntityType.ENDER_DRAGON, EpicFightAttributes.MAX_STRIKES, Double.MAX_VALUE);
        event.add(EntityType.ENDER_DRAGON, Attributes.ATTACK_DAMAGE, 10.0);
        event.add(EntityType.ENDER_DRAGON, Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        for (Map.Entry<LivingMotions, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingmotionEntry : this.livingMotions.entrySet()) {
            animator.addLivingAnimation(livingmotionEntry.getKey(), (AssetAccessor<? extends StaticAnimation>)livingmotionEntry.getValue());
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((EnderDragon)this.original).getHealth() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            DragonPhaseInstance phase = ((EnderDragon)this.original).getPhaseManager().getCurrentPhase();
            this.currentLivingMotion = !this.groundPhase ? (phase.getPhase() == PatchedPhases.AIRSTRIKE && ((DragonAirstrikePhase)phase).isActuallyAttacking() ? LivingMotions.CHASE : LivingMotions.FLY) : (phase.getPhase() == PatchedPhases.GROUND_BATTLE ? (((EnderDragon)this.original).getTarget() != null ? LivingMotions.WALK : LivingMotions.IDLE) : LivingMotions.IDLE);
        }
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        super.preTick(event);
        if (((EnderDragon)this.original).getPhaseManager().getCurrentPhase().isSitting()) {
            ((EnderDragon)this.original).nearestCrystal = null;
        }
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        if (animation instanceof InverseKinematicsProvider) {
            InverseKinematicsProvider inverseKinematicsProvider = (InverseKinematicsProvider)((Object)animation);
            if (animation.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).isEmpty()) {
                return;
            }
            float x = (float)((EnderDragon)this.getOriginal()).getX();
            float y = (float)((EnderDragon)this.getOriginal()).getY();
            float z = (float)((EnderDragon)this.getOriginal()).getZ();
            float xo = (float)((EnderDragon)this.getOriginal()).xo;
            float yo = (float)((EnderDragon)this.getOriginal()).yo;
            float zo = (float)((EnderDragon)this.getOriginal()).zo;
            OpenMatrix4f toModelPos = OpenMatrix4f.mul(OpenMatrix4f.translate(new Vec3f(xo + (x - xo) * partialTicks, yo + (y - yo) * partialTicks, zo + (z - zo) * partialTicks), new OpenMatrix4f(), null), this.getModelMatrix(partialTicks), null).invert();
            if (pose.hasTransform("Root")) {
                inverseKinematicsProvider.correctRootRotation(pose.get("Root"), this, partialTicks);
            }
            animation.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).ifPresent(ikDefinitions -> {
                for (InverseKinematicsSimulator.BakedInverseKinematicsDefinition bakedIKInfo : ikDefinitions) {
                    if (!this.ikSimulator.isRunning(bakedIKInfo.endJoint())) continue;
                    for (String jointName : bakedIKInfo.pathToEndJoint()) {
                        pose.putJointData(jointName, animation.getTransfroms().get(jointName).getKeyframes()[bakedIKInfo.initialPoseFrame()].transform().copy());
                    }
                    InverseKinematicsSimulator.InverseKinematicsObject ikObject = (InverseKinematicsSimulator.InverseKinematicsObject)this.ikSimulator.getRunningObject(bakedIKInfo.endJoint()).get();
                    JointTransform jt = ikObject.getTipTransform(partialTicks);
                    Vec3f jointModelpos = OpenMatrix4f.transform3v(toModelPos, jt.translation(), null);
                    inverseKinematicsProvider.applyFabrikToJoint(jointModelpos.multiply(-1.0f, 1.0f, -1.0f), pose, this.getArmature(), bakedIKInfo.startJoint(), bakedIKInfo.endJoint(), jt.rotation());
                }
            });
        }
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        ((EnderDragon)this.original).hurtTime = 2;
        ((EnderDragon)this.original).getSensing().tick();
        this.updateMotion(true);
        if (this.prevMotion != this.currentLivingMotion && !this.animator.getEntityState().inaction()) {
            if (this.livingMotions.containsKey(this.currentLivingMotion)) {
                this.animator.playAnimation((AssetAccessor<? extends StaticAnimation>)this.livingMotions.get(this.currentLivingMotion), 0.0f);
            }
            this.prevMotion = this.currentLivingMotion;
        }
        this.ikSimulator.tick(null);
        this.setIKHeightAndRootRotation();
        PartEntity bodyPart = ((EnderDragon)this.original).getParts()[2];
        AABB bodyBoundingBox = bodyPart.getBoundingBox();
        List list = ((EnderDragon)this.original).level().getEntities(this.original, bodyBoundingBox, EntitySelector.pushableBy((Entity)this.original));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                double d1;
                Entity entity = (Entity)list.get(l);
                double d0 = entity.getX() - ((EnderDragon)this.original).getX();
                double d2 = Mth.absMax((double)d0, (double)(d1 = entity.getZ() - ((EnderDragon)this.original).getZ()));
                if (!(d2 >= 0.01)) continue;
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 = d0 * d3 * 0.2;
                d1 = d1 * d3 * 0.2;
                if (entity.isVehicle()) continue;
                entity.push(d0, 0.0, d1);
                entity.hurtMarked = true;
            }
        }
        this.contributors.object2IntEntrySet().removeIf(entry -> ((EnderDragon)this.original).tickCount - entry.getIntValue() > 600 || !((Player)entry.getKey()).isAlive());
    }

    @Override
    public void preTickClient(EntityTickEvent.Pre event) {
        this.xRootO = this.xRoot;
        this.zRootO = this.zRoot;
        super.preTickClient(event);
        this.ikSimulator.tick(null);
        this.setIKHeightAndRootRotation();
    }

    @Override
    public void setStunShield(float value) {
        DragonPhaseInstance currentPhase;
        super.setStunShield(value);
        if (value <= 0.0f && (currentPhase = ((EnderDragon)this.original).getPhaseManager().getCurrentPhase()).getPhase() == PatchedPhases.CRYSTAL_LINK && ((DragonCrystalLinkPhase)currentPhase).getChargingCount() > 0) {
            ((EnderDragon)this.original).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 5.0f, 1.0f);
            ((EnderDragon)this.original).getPhaseManager().setPhase(PatchedPhases.NEUTRALIZED);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        Entity entity;
        boolean isConsumingCrystal;
        boolean bl = isConsumingCrystal = ((EnderDragon)this.original).getPhaseManager().getCurrentPhase().getPhase() == PatchedPhases.CRYSTAL_LINK;
        if (!isConsumingCrystal && amount > 0.0f && (entity = damageSource.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            this.contributors.put((Object)player, ((EnderDragon)this.original).tickCount);
        }
        return super.tryHurt(damageSource, isConsumingCrystal ? 0.0f : amount);
    }

    @Override
    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.getX() - ((EnderDragon)this.original).getX();
        double d1 = target.getZ() - ((EnderDragon)this.original).getZ();
        float degree = 180.0f - (float)Math.toDegrees(Mth.atan2((double)d0, (double)d1));
        super.rotateTo(degree, limit, partialSync);
    }

    @Override
    public float getYRotDeltaTo(Entity target) {
        double d0 = target.getX() - ((EnderDragon)this.original).getX();
        double d1 = target.getZ() - ((EnderDragon)this.original).getZ();
        float degree = 180.0f - (float)Math.toDegrees(Mth.atan2((double)d0, (double)d1));
        return Mth.clamp((float)Mth.wrapDegrees((float)(degree - Mth.wrapDegrees((float)((EnderDragon)this.getOriginal()).getYRot()))), (float)(-this.getYRotLimit()), (float)this.getYRotLimit());
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        for (Player player : this.contributors.keySet()) {
            ItemStack skillbook = new ItemStack((ItemLike)EpicFightItems.SKILLBOOK.get());
            ItemStack modified = (ItemStack)SetSkillFunction.builder(EpicFightSkills.DEMOLITION_LEAP.getRegisteredName()).build().apply((Object)skillbook, (Object)new LootContext.Builder(new LootParams.Builder(((ServerPlayer)player).serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)this.original).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.ADVANCEMENT_ENTITY)).create(null));
            if (modified.is(Items.AIR)) continue;
            player.addItem(modified);
        }
    }

    public void setIKHeightAndRootRotation() {
        this.ikSimulator.getAllRunningObjects().stream().map(pair -> (InverseKinematicsSimulator.InverseKinematicsObject)pair.getRight()).filter(InverseKinematicsSimulator.InverseKinematicsObject::isOnWorking).forEach(InverseKinematicsSimulator.InverseKinematicsObject::tick);
        if (this.ikSimulator.isRunning(((DragonArmature)Armatures.DRAGON.get()).legFrontL3) && this.ikSimulator.isRunning(((DragonArmature)Armatures.DRAGON.get()).legFrontR3) && this.ikSimulator.isRunning(((DragonArmature)Armatures.DRAGON.get()).legBackL3) && this.ikSimulator.isRunning(((DragonArmature)Armatures.DRAGON.get()).legBackR3)) {
            InverseKinematicsSimulator.InverseKinematicsObject frontL = (InverseKinematicsSimulator.InverseKinematicsObject)this.ikSimulator.getRunningObject(((DragonArmature)Armatures.DRAGON.get()).legFrontL3).get();
            InverseKinematicsSimulator.InverseKinematicsObject frontR = (InverseKinematicsSimulator.InverseKinematicsObject)this.ikSimulator.getRunningObject(((DragonArmature)Armatures.DRAGON.get()).legFrontR3).get();
            InverseKinematicsSimulator.InverseKinematicsObject backL = (InverseKinematicsSimulator.InverseKinematicsObject)this.ikSimulator.getRunningObject(((DragonArmature)Armatures.DRAGON.get()).legBackL3).get();
            InverseKinematicsSimulator.InverseKinematicsObject backR = (InverseKinematicsSimulator.InverseKinematicsObject)this.ikSimulator.getRunningObject(((DragonArmature)Armatures.DRAGON.get()).legBackR3).get();
            float entityPosY = (float)((EnderDragon)this.original).position().y;
            float yFrontL = frontL != null && frontL.isTouchingGround() ? frontL.getDestination().y : entityPosY;
            float yFrontR = frontR != null && frontR.isTouchingGround() ? frontR.getDestination().y : entityPosY;
            float yBackL = backL != null && backL.isTouchingGround() ? backL.getDestination().y : entityPosY;
            float yBackR = backR != null && backR.isTouchingGround() ? backR.getDestination().y : entityPosY;
            float xdiff = (yFrontL + yBackL) * 0.5f - (yFrontR + yBackR) * 0.5f;
            float zdiff = (yFrontL + yFrontR) * 0.5f - (yBackL + yBackR) * 0.5f;
            float xdistance = 4.0f;
            float zdistance = 5.7f;
            this.xRoot += Mth.clamp((float)((float)Math.toDegrees(Math.atan2(zdiff, zdistance)) - this.xRoot), (float)-1.0f, (float)1.0f);
            this.zRoot += Mth.clamp((float)((float)Math.toDegrees(Math.atan2(xdiff, xdistance)) - this.zRoot), (float)-1.0f, (float)1.0f);
            float averageY = (yFrontL + yFrontR + yBackL + yBackR) * 0.25f;
            if (!this.isLogicalClient()) {
                float dy = averageY - entityPosY;
                ((EnderDragon)this.original).move(MoverType.SELF, new Vec3(0.0, (double)dy, 0.0));
            }
        }
    }

    public int getNearbyCrystals() {
        return ((EnderDragon)this.original).getDragonFight() != null ? ((EnderDragon)this.original).getDragonFight().getCrystalsAlive() : 0;
    }

    public void setFlyingPhase() {
        this.groundPhase = false;
        ((EnderDragon)this.original).horizontalCollision = false;
        ((EnderDragon)this.original).verticalCollision = false;
    }

    public void setGroundPhase() {
        this.groundPhase = true;
    }

    public boolean isGroundPhase() {
        return this.groundPhase;
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isOutlineVisible(LocalPlayerPatch player) {
        return false;
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((EnderDragon)this.original).yRotO, ((EnderDragon)this.original).getYRot(), partialTick, -1.0f, 1.0f, -1.0f);
    }

    @Override
    public double getAngleTo(Entity entityIn) {
        Vec3 a = ((EnderDragon)this.original).getLookAngle().scale(-1.0);
        Vec3 b = new Vec3(entityIn.getX() - ((EnderDragon)this.original).getX(), entityIn.getY() - ((EnderDragon)this.original).getY(), entityIn.getZ() - ((EnderDragon)this.original).getZ()).normalize();
        double cosTheta = a.x * b.x + a.y * b.y + a.z * b.z;
        return Math.toDegrees(Math.acos(cosTheta));
    }

    @Override
    public double getAngleToHorizontal(Entity entityIn) {
        Vec3 a = ((EnderDragon)this.original).getLookAngle().scale(-1.0);
        Vec3 b = new Vec3(entityIn.getX() - ((EnderDragon)this.original).getX(), 0.0, entityIn.getZ() - ((EnderDragon)this.original).getZ()).normalize();
        double cos = a.x * b.x + a.y * b.y + a.z * b.z;
        return Math.toDegrees(Math.acos(cos));
    }

    @Override
    public <SIM extends PhysicsSimulator<?, ?, ?, ?, ?>> Optional<SIM> getSimulator(SimulationTypes<?, ?, ?, ?, ?, SIM> simulationType) {
        if (simulationType == SimulationTypes.INVERSE_KINEMATICS) {
            Optional.of(this.ikSimulator);
        }
        return Optional.empty();
    }

    @Override
    public InverseKinematicsSimulator getIKSimulator() {
        return this.ikSimulator;
    }

    @Override
    public Entity toEntity() {
        return this.getOriginal();
    }

    @Override
    public float getRootXRot() {
        return this.xRoot;
    }

    @Override
    public float getRootXRotO() {
        return this.xRootO;
    }

    @Override
    public float getRootZRot() {
        return this.zRoot;
    }

    @Override
    public float getRootZRotO() {
        return this.zRootO;
    }

    @Override
    public BossEvent getBossEvent() {
        ServerLevel serverlevel;
        EndDragonFight enddragonfight;
        if (((EnderDragon)this.original).getDragonFight() == null && !((EnderDragon)this.original).level().isClientSide && (enddragonfight = (serverlevel = (ServerLevel)((EnderDragon)this.original).level()).getDragonFight()) != null && ((EnderDragon)this.original).getUUID().equals(enddragonfight.getDragonUUID())) {
            ((EnderDragon)this.original).setDragonFight(enddragonfight);
        }
        return ((EnderDragon)this.original).getDragonFight() == null ? null : ((EnderDragon)this.original).getDragonFight().dragonEvent;
    }
}

