/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPAnimatorControl;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.network.client.CPSetStamina;
import yesman.epicfight.network.common.AnimatorControlPacket;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayerPatch
extends AbstractClientPlayerPatch<LocalPlayer> {
    private static final UUID ACTION_EVENT_UUID = UUID.fromString("d1a1e102-1621-11ed-861d-0242ac120002");
    private Minecraft minecraft;
    private LivingEntity rayTarget;
    private boolean targetLockedOn;
    private float staminaO;
    private int prevChargingAmount;
    private float lockOnXRot;
    private float lockOnXRotO;
    private float lockOnYRot;
    private float lockOnYRotO;
    private float fpvXRotO;
    private float fpvXRot;
    private float fpvYRotO;
    private float fpvYRot;
    private int fpvLerpTick;
    private FirstPersonLayer firstPersonLayer = new FirstPersonLayer();
    private AnimationSubFileReader.PovSettings povSettings;

    @Override
    public void onConstructed(LocalPlayer entity) {
        super.onConstructed(entity);
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void onJoinWorld(LocalPlayer player, EntityJoinLevelEvent event) {
        super.onJoinWorld(player, event);
        this.eventListeners.addEventListener(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, ACTION_EVENT_UUID, playerEvent -> ClientEngine.getInstance().controlEngine.unlockHotkeys());
    }

    public void onRespawnLocalPlayer(ClientPlayerNetworkEvent.Clone event) {
        this.onJoinWorld(event.getNewPlayer(), new EntityJoinLevelEvent((Entity)event.getNewPlayer(), event.getNewPlayer().m_9236_()));
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        this.staminaO = this.getStamina();
        this.prevChargingAmount = this.isHoldingAny() && this.getHoldingSkill() instanceof ChargeableSkill ? this.getChargingAmount() : 0;
        super.tick(event);
    }

    private EntityHitResult pickEntity() {
        double distance = ((LocalPlayer)this.original).getBlockReach() * 2.0;
        double entityReach = ((LocalPlayer)this.original).getEntityReach() * 2.0;
        double pickRange = Math.max(distance, entityReach);
        Vec3 vec3 = ((LocalPlayer)this.original).m_20299_(1.0f);
        Vec3 vec31 = ((LocalPlayer)this.original).m_20252_(1.0f);
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * pickRange, vec31.f_82480_ * pickRange, vec31.f_82481_ * pickRange);
        BlockHitResult blockHitResulst = ((LocalPlayer)this.getOriginal()).m_9236_().m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.original));
        if (blockHitResulst.m_6662_() != HitResult.Type.MISS) {
            pickRange = blockHitResulst.m_82450_().m_82557_(vec3);
        }
        AABB aabb = ((LocalPlayer)this.original).m_20191_().m_82369_(vec31.m_82490_(distance)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)this.original, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, p_234237_ -> !p_234237_.m_5833_() && p_234237_.m_6087_(), (double)pickRange);
        return entityhitresult;
    }

    @Override
    public void clientTick(LivingEvent.LivingTickEvent event) {
        boolean isLerping;
        Entity hit;
        this.staminaO = this.getStamina();
        super.clientTick(event);
        EntityHitResult cameraHitResult = this.pickEntity();
        if (cameraHitResult != null && (hit = cameraHitResult.m_82443_()) != this.rayTarget && hit != this.original) {
            if (hit instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)hit;
                if (!(hit instanceof ArmorStand) && !this.targetLockedOn) {
                    this.rayTarget = livingentity;
                }
            } else if (hit instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)hit;
                Entity parent = partEntity.getParent();
                if (parent instanceof LivingEntity) {
                    LivingEntity parentLivingEntity = (LivingEntity)parent;
                    if (!this.targetLockedOn) {
                        this.rayTarget = parentLivingEntity;
                    }
                }
            } else {
                this.rayTarget = null;
            }
            if (this.rayTarget != null) {
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(this.getTarget().m_19879_()));
            }
        }
        this.lockOnXRotO = this.lockOnXRot;
        this.lockOnYRotO = this.lockOnYRot;
        if (this.rayTarget != null) {
            if (this.targetLockedOn && !this.isLerpingFpv()) {
                Vec3 playerPosition = ((LocalPlayer)this.original).m_146892_();
                Vec3 targetPosition = this.rayTarget.m_146892_();
                Vec3 toTarget = targetPosition.m_82546_(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                CameraType cameraType = this.minecraft.f_91066_.m_92176_();
                float lockOnXRotDst = pitch + (cameraType.m_90612_() ? 0.0f : 30.0f);
                lockOnXRotDst = Mth.m_14036_((float)lockOnXRotDst, (float)0.0f, (float)60.0f);
                if (cameraType.m_90613_()) {
                    lockOnXRotDst = -lockOnXRotDst;
                }
                float lockOnYRotDst = yaw + (cameraType.m_90613_() ? 180.0f : 0.0f);
                float xDiff = Mth.m_14177_((float)(lockOnXRotDst - this.lockOnXRotO));
                float yDiff = Mth.m_14177_((float)(lockOnYRotDst - this.lockOnYRotO));
                float xLerp = Mth.m_14036_((float)(xDiff * 0.4f), (float)-30.0f, (float)30.0f);
                float yLerp = Mth.m_14036_((float)(yDiff * 0.4f), (float)-30.0f, (float)30.0f);
                this.lockOnXRot = this.lockOnXRotO + xLerp;
                this.lockOnYRot = this.lockOnYRotO + yLerp;
                if (!this.getEntityState().turningLocked() || this.getEntityState().lockonRotate()) {
                    Vec3 playerEye = ((LocalPlayer)this.original).m_146892_();
                    Vec3 targetEye = this.rayTarget.m_146892_();
                    double eyeYDiff = Math.abs(playerEye.f_82480_ - targetEye.f_82480_);
                    double dist = playerEye.m_82554_(targetEye);
                    double xDegree = Math.tan(eyeYDiff / dist) * 57.29577951308232;
                    xDegree = Mth.m_14008_((double)xDegree, (double)-60.0, (double)60.0);
                    ((LocalPlayer)this.original).m_146926_((float)xDegree);
                    ((LocalPlayer)this.original).m_146922_(lockOnYRotDst);
                }
            } else {
                this.lockOnXRot = ((LocalPlayer)this.original).m_146909_();
                this.lockOnYRot = ((LocalPlayer)this.original).m_146908_();
            }
            if (this.rayTarget.m_213877_() || this.rayTarget.m_20177_((Player)this.original) || ((LocalPlayer)this.getOriginal()).m_20280_((Entity)this.rayTarget) > 400.0 || this.getAngleTo((Entity)this.rayTarget) > 80.0 && !this.targetLockedOn) {
                if (this.targetLockedOn) {
                    ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
                    ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
                    this.targetLockedOn = false;
                }
                this.rayTarget = null;
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(-1));
            }
        } else {
            this.lockOnXRot = ((LocalPlayer)this.original).m_146909_();
            this.lockOnYRot = ((LocalPlayer)this.original).m_146908_();
            this.targetLockedOn = false;
        }
        CapabilityItem mainhandItemCap = this.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandItemCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        CapabilityItem.ZoomInType rangeWeaponZoomInType = mainhandItemCap.isEmpty() || mainhandItemCap.getZoomInType() == CapabilityItem.ZoomInType.NONE ? offhandItemCap.getZoomInType() : mainhandItemCap.getZoomInType();
        switch (rangeWeaponZoomInType) {
            case ALWAYS: {
                ClientEngine.getInstance().renderEngine.zoomIn();
                break;
            }
            case USE_TICK: {
                if (((LocalPlayer)this.original).m_21212_() > 0) {
                    ClientEngine.getInstance().renderEngine.zoomIn();
                    break;
                }
                ClientEngine.getInstance().renderEngine.zoomOut(40);
                break;
            }
            case AIMING: {
                if (this.getClientAnimator().isAiming()) {
                    ClientEngine.getInstance().renderEngine.zoomIn();
                    break;
                }
                ClientEngine.getInstance().renderEngine.zoomOut(40);
                break;
            }
            case CUSTOM: {
                break;
            }
            default: {
                ClientEngine.getInstance().renderEngine.zoomOut(0);
            }
        }
        AssetAccessor<? extends StaticAnimation> currentPlaying = this.firstPersonLayer.animationPlayer.getRealAnimation();
        boolean noPovAnimation = this.getClientAnimator().iterVisibleLayersUntilFalse(layer -> {
            if (layer.isOff()) {
                return true;
            }
            Optional<DirectStaticAnimation> optPovAnimation = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_ANIMATION);
            Optional<AnimationSubFileReader.PovSettings> optPovSettings = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            optPovAnimation.ifPresent(povAnimation -> {
                if (!povAnimation.equals(currentPlaying.get())) {
                    this.firstPersonLayer.playAnimation((AssetAccessor<? extends StaticAnimation>)povAnimation, layer.animationPlayer.getRealAnimation(), this, 0.0f);
                    this.povSettings = (AnimationSubFileReader.PovSettings)optPovSettings.get();
                }
            });
            return !optPovAnimation.isPresent();
        });
        if (noPovAnimation && !currentPlaying.equals(Animations.EMPTY_ANIMATION)) {
            this.firstPersonLayer.off();
        }
        this.firstPersonLayer.update(this);
        if (this.firstPersonLayer.animationPlayer.getAnimation().equals(Animations.EMPTY_ANIMATION)) {
            this.povSettings = null;
        }
        if (isLerping = this.isLerpingFpv()) {
            --this.fpvLerpTick;
        }
        if (isLerping && !this.isLerpingFpv()) {
            ((LocalPlayer)this.original).m_146926_(this.fpvXRot);
            ((LocalPlayer)this.original).m_146922_(this.fpvYRot);
        }
    }

    @Override
    public boolean overrideRender() {
        if (((LocalPlayer)this.original).m_7306_((Entity)this.minecraft.f_91074_) && this.minecraft.f_91066_.m_92176_().m_90612_() && !ClientConfig.enableAnimatedFirstPersonModel) {
            return false;
        }
        return super.overrideRender();
    }

    @Override
    public LivingEntity getTarget() {
        return this.rayTarget;
    }

    @Override
    public void toVanillaMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.VANILLA) {
            ClientEngine.getInstance().renderEngine.downSlideSkillUI();
            if (ClientConfig.authSwitchCamera) {
                this.minecraft.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.VANILLA));
            }
        }
        super.toVanillaMode(synchronize);
    }

    @Override
    public void toEpicFightMode(boolean synchronize) {
        if (this.playerMode != PlayerPatch.PlayerMode.EPICFIGHT) {
            ClientEngine.getInstance().renderEngine.upSlideSkillUI();
            if (ClientConfig.authSwitchCamera) {
                this.minecraft.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.EPICFIGHT));
            }
        }
        super.toEpicFightMode(synchronize);
    }

    @Override
    public boolean isFirstPerson() {
        return this.minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON;
    }

    @Override
    public boolean shouldBlockMoving() {
        return ControlEngine.isKeyDown(this.minecraft.f_91066_.f_92087_);
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        if (!this.isLogicalClient()) {
            return false;
        }
        return actionAnimation.shouldPlayerMove(this);
    }

    public float getStaminaO() {
        return this.staminaO;
    }

    public int getPrevChargingAmount() {
        return this.prevChargingAmount;
    }

    public float getLerpedLockOnX(double partial) {
        return Mth.m_14189_((float)((float)partial), (float)this.lockOnXRotO, (float)this.lockOnXRot);
    }

    public float getLerpedLockOnY(double partial) {
        return Mth.m_14189_((float)((float)partial), (float)this.lockOnYRotO, (float)this.lockOnYRot);
    }

    public boolean isTargetLockedOn() {
        return this.targetLockedOn;
    }

    public void setLockOn(boolean targetLockedOn) {
        if (this.targetLockedOn && this.rayTarget != null) {
            ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
            ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
        }
        this.targetLockedOn = targetLockedOn;
    }

    public void toggleLockOn() {
        this.setLockOn(!this.targetLockedOn);
    }

    public FirstPersonLayer getFirstPersonLayer() {
        return this.firstPersonLayer;
    }

    public AnimationSubFileReader.PovSettings getPovSettings() {
        return this.povSettings;
    }

    public boolean hasCameraAnimation() {
        return this.povSettings != null && this.povSettings.cameraTransform() != null;
    }

    @Override
    public void setStamina(float value) {
        EpicFightNetworkManager.sendToServer(new CPSetStamina(value, true));
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
        ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(amount));
        }
    }

    public float getModelYRot() {
        return this.modelYRot;
    }

    public void setModelYRotInGui(float rotDeg) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRotInGui(float originalDeg) {
        this.useModelYRot = false;
        this.modelYRot = originalDeg;
    }

    public void fixFpvRotation(float xRot, float yRot) {
        this.fpvXRot = Mth.m_14177_((float)xRot);
        this.fpvXRotO = Mth.m_14177_((float)((LocalPlayer)this.original).m_146909_());
        this.fpvYRot = Mth.m_14177_((float)yRot);
        this.fpvYRotO = Mth.m_14177_((float)((LocalPlayer)this.original).m_146908_());
        this.fpvLerpTick = 5;
    }

    public float getLerpedFpvXRot(float partialTicks) {
        float delta = (float)this.fpvLerpTick / 5.0f + (1.0f - partialTicks) * 0.2f;
        return this.isLerpingFpv() ? Mth.m_14189_((float)delta, (float)this.fpvXRot, (float)this.fpvXRotO) : ((LocalPlayer)this.original).m_146909_();
    }

    public float getLerpedFpvYRot(float partialTicks) {
        float delta = (float)this.fpvLerpTick / 5.0f + (1.0f - partialTicks) * 0.2f;
        return this.isLerpingFpv() ? Mth.m_14189_((float)delta, (float)this.fpvYRot, (float)this.fpvYRotO) : ((LocalPlayer)this.original).m_146908_();
    }

    public boolean isLerpingFpv() {
        return this.fpvLerpTick > -1;
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot());
        }
    }

    @Override
    public double checkXTurn(double xRot) {
        float xRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (xRot == 0.0) {
            return xRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.f_91066_.m_92176_().m_90612_() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && ((xRotDest = ((LocalPlayer)this.original).m_146909_() + (float)xRot * 0.15f) <= viewLimit.xRotMin() || xRotDest >= viewLimit.xRotMax())) {
            return 0.0;
        }
        return xRot;
    }

    @Override
    public double checkYTurn(double yRot) {
        float yRotClamped;
        float yRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (yRot == 0.0) {
            return yRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.f_91066_.m_92176_().m_90612_() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && (yRotDest = ((LocalPlayer)this.original).m_146908_() + (float)yRot * 0.15f) != (yRotClamped = Mth.m_14036_((float)yRotDest, (float)(this.getYRot() + viewLimit.yRotMin()), (float)(this.getYRot() + viewLimit.yRotMax())))) {
            return 0.0;
        }
        return yRot;
    }

    @Override
    public void beginAction(ActionAnimation animation) {
        if (!this.useModelYRot || animation.getProperty(AnimationProperty.ActionAnimationProperty.SYNC_CAMERA).orElse(false).booleanValue()) {
            this.modelYRot = ((LocalPlayer)this.getOriginal()).m_146908_();
        }
        if (this.targetLockedOn) {
            if (this.rayTarget != null && !this.rayTarget.m_213877_()) {
                Vec3 playerPosition = ((LocalPlayer)this.original).m_20182_();
                Vec3 targetPosition = this.rayTarget.m_20182_();
                Vec3 toTarget = targetPosition.m_82546_(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                ((LocalPlayer)this.original).m_146922_(yaw);
                ((LocalPlayer)this.original).m_146926_(pitch);
            } else {
                ((LocalPlayer)this.original).m_146922_(this.lockOnYRot);
                ((LocalPlayer)this.original).m_146926_(this.lockOnXRot);
            }
        }
    }

    @Override
    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.reserveAnimation(animation);
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.RESERVE, animation, 0.0f, false, false, false));
    }

    @Override
    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.playAnimationInstantly(animation);
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.PLAY_INSTANTLY, animation, 0.0f, false, false, false));
    }

    @Override
    public void playShootingAnimation() {
        this.animator.playShootingAnimation();
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.SHOT, -1, 0.0f, false, true, false));
    }

    @Override
    public void stopPlaying(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.stopPlaying(animation);
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.STOP, animation, -1.0f, false, false, false));
    }

    @Override
    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.PLAY, animation, transitionTimeModifier, false, false, true));
    }

    @Override
    public void playAnimationInClientSide(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(AnimatorControlPacket.Action.PLAY, animation, transitionTimeModifier, false, true, false));
    }

    @Override
    public void pauseAnimator(AnimatorControlPacket.Action action, boolean pause) {
        super.pauseAnimator(action, pause);
        EpicFightNetworkManager.sendToServer(new CPAnimatorControl(action, -1, 0.0f, pause, false, false));
    }

    @Override
    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
        if (itemstack.m_41782_() && itemstack.m_41783_().m_128441_("skill")) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillBookScreen((Player)this.original, itemstack, hand));
        }
    }

    @Override
    public void resetHolding() {
        if (this.holdingSkill != null) {
            ClientEngine.getInstance().controlEngine.releaseAllServedKeys();
        }
        super.resetHolding();
    }

    public boolean canPlayAttackAnimation() {
        Entity hitEntity;
        if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.ENTITY && !((hitEntity = ((EntityHitResult)this.minecraft.f_91077_).m_82443_()) instanceof LivingEntity) && !(hitEntity instanceof PartEntity)) {
            return false;
        }
        if (this.targetLockedOn) {
            return true;
        }
        if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).m_21205_().m_41720_())) {
            if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && this.minecraft.f_91073_ != null) {
                BlockPos bp = ((BlockHitResult)this.minecraft.f_91077_).m_82425_();
                BlockState bs = this.minecraft.f_91073_.m_8055_(bp);
                return !((LocalPlayer)this.original).m_21205_().m_41720_().m_6777_(bs, ((LocalPlayer)this.original).m_9236_(), bp, (Player)this.original) || !((LocalPlayer)this.original).m_21205_().m_41735_(bs);
            }
        } else {
            return this.minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK;
        }
        return true;
    }

    public boolean shouldHighlightTarget(Entity entity) {
        if (!ClientConfig.enableTargetEntityGuide) {
            return false;
        }
        if (entity == this.rayTarget) {
            if (!EpicFightCapabilities.getUnparameterizedEntityPatch(entity, EntityPatch.class).map(entitypatch -> entitypatch.isOutlineVisible(this)).orElse(false).booleanValue()) {
                return false;
            }
            if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).m_21205_().m_41720_())) {
                if (this.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && this.minecraft.f_91073_ != null) {
                    BlockPos bp = ((BlockHitResult)this.minecraft.f_91077_).m_82425_();
                    BlockState bs = this.minecraft.f_91073_.m_8055_(bp);
                    return !((LocalPlayer)this.original).m_21205_().m_41720_().m_6777_(bs, ((LocalPlayer)this.original).m_9236_(), bp, (Player)this.original) || !((LocalPlayer)this.original).m_21205_().m_41735_(bs);
                }
                return true;
            }
            return this.minecraft.f_91076_ == entity;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class FirstPersonLayer
    extends Layer {
        private TransformSheet linkCameraTransform;

        public FirstPersonLayer() {
            super(null);
            this.linkCameraTransform = new TransformSheet(List.of(new Keyframe(0.0f, JointTransform.empty()), new Keyframe(Float.MAX_VALUE, JointTransform.empty())));
        }

        public void playAnimation(AssetAccessor<? extends StaticAnimation> nextFirstPersonAnimation, AssetAccessor<? extends StaticAnimation> originalAnimation, LivingEntityPatch<?> entitypatch, float transitionTimeModifier) {
            boolean hasNextCameraAnimation;
            Optional<AnimationSubFileReader.PovSettings> povSettings = originalAnimation.get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            boolean hasPrevCameraAnimation = LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null;
            boolean bl = hasNextCameraAnimation = povSettings.isPresent() && povSettings.get().cameraTransform() != null;
            if (hasPrevCameraAnimation || hasNextCameraAnimation) {
                if (hasPrevCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                } else {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(JointTransform.empty());
                }
                if (hasNextCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(povSettings.get().cameraTransform().getKeyframes()[0].transform());
                } else {
                    this.linkCameraTransform.getKeyframes()[1].transform().clearTransform();
                }
                this.linkCameraTransform.getKeyframes()[1].setTime(nextFirstPersonAnimation.get().getTransitionTime());
            }
            super.playAnimation(nextFirstPersonAnimation, entitypatch, transitionTimeModifier);
        }

        public void off() {
            if (LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null) {
                this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(JointTransform.empty());
                this.linkCameraTransform.getKeyframes()[1].setTime(0.15f);
            }
            super.off(LocalPlayerPatch.this);
        }

        @Override
        protected Pose getCurrentPose(LivingEntityPatch<?> entitypatch) {
            return this.animationPlayer.isEmpty() ? super.getCurrentPose(entitypatch) : this.animationPlayer.getCurrentPose(entitypatch, 0.0f);
        }

        public TransformSheet getLinkCameraTransform() {
            return this.linkCameraTransform;
        }
    }
}

