/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions;

import java.util.NoSuchElementException;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.HealthPoint;
import yesman.epicfight.data.conditions.entity.OffhandItemCategory;
import yesman.epicfight.data.conditions.entity.PlayerName;
import yesman.epicfight.data.conditions.entity.PlayerSkillActivated;
import yesman.epicfight.data.conditions.entity.RandomChance;
import yesman.epicfight.data.conditions.entity.TargetInDistance;
import yesman.epicfight.data.conditions.entity.TargetInEyeHeight;
import yesman.epicfight.data.conditions.entity.TargetInPov;
import yesman.epicfight.data.conditions.itemstack.TagValueCondition;

public class EpicFightConditions {
    public static final DeferredRegister<Supplier<Condition<?>>> CONDITIONS = DeferredRegister.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"conditions"), (String)"epicfight");
    public static final Supplier<IForgeRegistry<Supplier<Condition<?>>>> REGISTRY = CONDITIONS.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<Supplier<Condition<?>>> OFFHAND_ITEM_CATEGORY = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"offhand_item_category").m_135815_(), () -> OffhandItemCategory::new);
    public static final RegistryObject<Supplier<Condition<?>>> PLAYER_SKILL_ACTIVATED = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"skill_active").m_135815_(), () -> PlayerSkillActivated::new);
    public static final RegistryObject<Supplier<Condition<?>>> PLAYER_NAME = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"player_name").m_135815_(), () -> PlayerName::new);
    public static final RegistryObject<Supplier<Condition<?>>> HEALTH_POINT = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"health").m_135815_(), () -> HealthPoint::new);
    public static final RegistryObject<Supplier<Condition<?>>> RANDOM = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"random_chance").m_135815_(), () -> RandomChance::new);
    public static final RegistryObject<Supplier<Condition<?>>> TARGET_IN_DISTANCE = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"within_distance").m_135815_(), () -> TargetInDistance::new);
    public static final RegistryObject<Supplier<Condition<?>>> TARGET_IN_EYE_HEIGHT = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"within_eye_height").m_135815_(), () -> TargetInEyeHeight::new);
    public static final RegistryObject<Supplier<Condition<?>>> TARGET_IN_POV = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"within_angle").m_135815_(), () -> TargetInPov::new);
    public static final RegistryObject<Supplier<Condition<?>>> TARGET_IN_POV_HORIZONTAL = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"within_angle_horizontal").m_135815_(), () -> TargetInPov.TargetInPovHorizontal::new);
    public static final RegistryObject<Supplier<Condition<?>>> TAG_VALUE = CONDITIONS.register(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"tag_value").m_135815_(), () -> TagValueCondition::new);

    public static <T extends Condition<?>> Supplier<T> getConditionOrThrow(ResourceLocation key) throws NoSuchElementException, ClassCastException {
        if (!REGISTRY.get().containsKey(key)) {
            throw new NoSuchElementException("No condition named " + key);
        }
        return EpicFightConditions.getConditionOrNull(key);
    }

    public static <T extends Condition<?>> Supplier<T> getConditionOrNull(ResourceLocation key) throws ClassCastException {
        return (Supplier)REGISTRY.get().getValue(key);
    }

    @Deprecated
    public static String convertOldNames(String string) {
        if ("epicfight:offhand_category".equals(string)) {
            return OFFHAND_ITEM_CATEGORY.getId().toString();
        }
        return string;
    }
}

