/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.SynchedAnimationVariableKey;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.network.common.AnimationVariablePacket;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SPAnimationVariablePacket<T>
extends AnimationVariablePacket<T> {
    protected int entityId;

    public SPAnimationVariablePacket(LivingEntityPatch<?> entitypatch, SynchedAnimationVariableKey<T> animationVariableKey, @Nullable AssetAccessor<? extends StaticAnimation> animation, T value, AnimationVariablePacket.Action action) {
        super(animationVariableKey, animation, value, action);
        this.entityId = ((LivingEntity)entitypatch.getOriginal()).m_19879_();
    }

    public SPAnimationVariablePacket(int entityId, SynchedAnimationVariableKey<T> animationVariableKey, @Nullable AssetAccessor<? extends StaticAnimation> animation, T value, AnimationVariablePacket.Action action) {
        super(animationVariableKey, animation, value, action);
        this.entityId = entityId;
    }

    public static <T> SPAnimationVariablePacket<T> fromBytes(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        SynchedAnimationVariableKey variableKey = SynchedAnimationVariableKey.byId(buf.readInt());
        AnimationManager.AnimationAccessor animation = AnimationManager.byId(buf.readInt());
        AnimationVariablePacket.Action action = AnimationVariablePacket.Action.values()[buf.readInt()];
        return new SPAnimationVariablePacket<Object>(entityId, (SynchedAnimationVariableKey<Object>)variableKey, (AssetAccessor<StaticAnimation>)animation, (action == AnimationVariablePacket.Action.PUT ? (T)variableKey.getPacketBufferCodec().decode(buf) : null), action);
    }

    public static <T> void toBytes(SPAnimationVariablePacket<T> msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.animationVariableKey.getId());
        buf.writeInt(((StaticAnimation)msg.animation.get()).getId());
        buf.writeInt(msg.action.ordinal());
        if (msg.action == AnimationVariablePacket.Action.PUT) {
            msg.animationVariableKey.getPacketBufferCodec().encode(msg.value, buf);
        }
    }

    public static <T> void handle(SPAnimationVariablePacket<T> msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> EpicFightCapabilities.getUnparameterizedEntityPatch(Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(msg.entityId), LivingEntityPatch.class).ifPresent(msg::process));
        ctx.get().setPacketHandled(true);
    }
}

