/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class LiechtenauerSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("244c57c0-a837-11eb-bcbc-0242ac130002");
    private int returnDuration;

    public LiechtenauerSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.returnDuration = parameters.m_128451_("return_duration");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            if (this.isActivated(container) && !this.isDisabled(container) && event.getAttackDamage() > event.getTarget().m_21223_()) {
                this.setDurationSynchronize(container, Math.min(this.maxDuration, container.getRemainDuration() + this.returnDuration));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            int phaseLevel = ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().getLevel();
            if (event.getDamage() > 0.0f && this.isActivated(container) && !this.isDisabled(container) && phaseLevel > 0 && phaseLevel < 3 && this.canExecute(container) && LiechtenauerSkill.isBlockableSource(event.getDamageSource())) {
                DamageSource damageSource = event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    Entity patt4191$temp;
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                    ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    ((HitParticleType)((Object)((Object)EpicFightParticles.HIT_BLUNT.get()))).spawnParticleWithArgument(playerentity.m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    float knockback = 0.25f;
                    if (damageSource instanceof EpicFightDamageSource) {
                        EpicFightDamageSource epicfightSource = (EpicFightDamageSource)damageSource;
                        knockback += Math.min(epicfightSource.calculateImpact() * 0.1f, 1.0f);
                    }
                    if ((patt4191$temp = damageSource.m_7640_()) instanceof LivingEntity) {
                        LivingEntity livingentity = (LivingEntity)patt4191$temp;
                        knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingentity) * 0.1f;
                    }
                    EpicFightCapabilities.getUnparameterizedEntityPatch(event.getDamageSource().m_7639_(), LivingEntityPatch.class).ifPresent(attackerpatch -> attackerpatch.setLastAttackEntity((Entity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
                    ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                }
            }
        }, 0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (this.isActivated(container)) {
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                ControlEngine.setKeyBind(Minecraft.m_91087_().f_91066_.f_92091_, false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, 0);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        container.getExecutor().playSound(SoundEvents.f_11677_, 0.0f, 0.0f);
        if (this.isActivated(container)) {
            this.cancelOnServer(container, args);
        } else {
            super.executeOnServer(container, args);
            container.activate();
            container.getServerExecutor().modifyLivingMotionByCurrentItem(false);
            container.getExecutor().playAnimationSynchronized(Animations.BIPED_LIECHTENAUER_READY, 0.0f);
        }
    }

    @Override
    public void cancelOnServer(SkillContainer container, FriendlyByteBuf args) {
        container.deactivate();
        super.cancelOnServer(container, args);
        container.getServerExecutor().modifyLivingMotionByCurrentItem(false);
    }

    @Override
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnClient(container, args);
        container.activate();
    }

    @Override
    public void cancelOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.cancelOnClient(container, args);
        container.deactivate();
    }

    @Override
    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return EpicFightCapabilities.getItemStackCapability(itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).m_20202_() == null;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    private static boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(DamageTypeTags.f_268415_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemstack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        ArrayList tooltipArgs = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        tooltipArgs.add(this.maxDuration / 20);
        tooltipArgs.add(this.returnDuration / 20);
        list.add(Component.m_237115_((String)traslatableText).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)String.format("[%.0f]", Float.valueOf(this.consumption))).m_130940_(ChatFormatting.AQUA)));
        list.add(Component.m_237110_((String)(traslatableText + ".tooltip"), (Object[])tooltipArgs.toArray(new Object[0])).m_130940_(ChatFormatting.DARK_GRAY));
        return list;
    }

    public static enum Stance {
        VOM_TAG,
        PFLUG,
        OCHS;

    }
}

