/*
 * Decompiled with CFR 0.152.
 */
package com.twentyeightisme.echolib.api;

import com.twentyeightisme.echolib.api.EchoLibCategory;
import com.twentyeightisme.echolib.api.EchoLibEntry;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class EchoLibScreen
extends class_437 {
    private final class_437 parent;
    private final List<EchoLibCategory> categories = new ArrayList<EchoLibCategory>();
    private final List<ConfigEntry> configEntries = new ArrayList<ConfigEntry>();
    private Runnable saveAction;
    private int currentCategoryIndex = 0;
    private int scrollOffset = 0;
    private static final int MARGIN = 10;
    private static final int ENTRY_HEIGHT = 24;
    private static final int CATEGORY_TAB_HEIGHT = 20;
    private static final int HEADER_HEIGHT = 60;
    private static final int FOOTER_HEIGHT = 30;
    private static final int COLOR_WHITE = -1;
    private static final int COLOR_GRAY = -6710887;
    private static final int COLOR_DARK_GRAY = -12566464;
    private static final int COLOR_BACKGROUND = 0;
    private static final int COLOR_SELECTED = -11184641;

    public EchoLibScreen(class_437 parent, class_2561 title) {
        super(title);
        this.parent = parent;
    }

    public EchoLibScreen setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction;
        return this;
    }

    public EchoLibCategory addCategory(String name) {
        EchoLibCategory category = new EchoLibCategory(name);
        this.categories.add(category);
        return category;
    }

    protected void method_25426() {
        super.method_25426();
        this.scrollOffset = 0;
        this.rebuildEntries();
        this.rebuildCategoryTabs();
        int buttonWidth = 60;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int startX = (this.field_22789 - totalButtonWidth) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done").method_27692(class_124.field_1068), button -> {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.method_25419();
        }).method_46434(startX, this.field_22790 - 25, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel").method_27692(class_124.field_1080), button -> this.method_25419()).method_46434(startX + buttonWidth + buttonSpacing, this.field_22790 - 25, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset All").method_27692(class_124.field_1061), button -> this.resetCurrentCategory()).method_46434(startX + (buttonWidth + buttonSpacing) * 2, this.field_22790 - 25, buttonWidth, 20).method_46431());
    }

    private void rebuildCategoryTabs() {
        if (this.categories.isEmpty()) {
            return;
        }
        int tabWidth = Math.min(120, (this.field_22789 - 20) / this.categories.size());
        for (int i = 0; i < this.categories.size(); ++i) {
            int categoryIndex = i;
            EchoLibCategory category = this.categories.get(i);
            class_4185 tabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)category.name), button -> {
                this.currentCategoryIndex = categoryIndex;
                this.scrollOffset = 0;
                this.rebuildEntries();
            }).method_46434(10 + i * tabWidth, 35, tabWidth - 2, 20).method_46431();
            this.method_37063((class_364)tabButton);
        }
    }

    private void rebuildEntries() {
        this.configEntries.forEach(entry -> {
            if (entry.widget != null) {
                this.method_37066((class_364)entry.widget);
            }
            if (entry.resetButton != null) {
                this.method_37066((class_364)entry.resetButton);
            }
        });
        this.configEntries.clear();
        if (this.currentCategoryIndex >= this.categories.size()) {
            return;
        }
        EchoLibCategory category = this.categories.get(this.currentCategoryIndex);
        int yPos = 70;
        for (EchoLibEntry<?> entry2 : category.entries) {
            int adjustedY = yPos + this.scrollOffset;
            if (adjustedY + 24 < 60 || adjustedY > this.field_22790 - 30) {
                yPos += 26;
                continue;
            }
            ConfigEntry configEntry = new ConfigEntry(entry2, this.currentCategoryIndex);
            int valueWidth = 100;
            int valueX = this.field_22789 - 10 - 55 - valueWidth;
            configEntry.widget = entry2.createWidget(valueX, adjustedY, valueWidth, 18, this.field_22793);
            this.method_37063((class_364)configEntry.widget);
            configEntry.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset").method_27692(class_124.field_1080), button -> {
                entry2.reset();
                this.rebuildEntries();
            }).method_46434(this.field_22789 - 10 - 50, adjustedY, 45, 18).method_46431();
            this.method_37063((class_364)configEntry.resetButton);
            this.configEntries.add(configEntry);
            yPos += 26;
        }
    }

    private void resetCurrentCategory() {
        if (this.currentCategoryIndex < this.categories.size()) {
            EchoLibCategory category = this.categories.get(this.currentCategoryIndex);
            for (EchoLibEntry<?> entry : category.entries) {
                entry.reset();
            }
            this.rebuildEntries();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0);
        context.method_25294(0, 0, this.field_22789, 60, 0);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        if (this.currentCategoryIndex < this.categories.size() && !this.categories.isEmpty()) {
            int tabWidth = Math.min(120, (this.field_22789 - 20) / this.categories.size());
            int highlightX = 10 + this.currentCategoryIndex * tabWidth;
            context.method_25294(highlightX, 35, highlightX + tabWidth - 2, 55, -11184641);
        }
        context.method_25294(10, 60, this.field_22789 - 10, this.field_22790 - 30, 0x60000000);
        if (this.currentCategoryIndex < this.categories.size()) {
            EchoLibCategory category = this.categories.get(this.currentCategoryIndex);
            int yPos = 70;
            for (EchoLibEntry<?> entry : category.entries) {
                int adjustedY = yPos + this.scrollOffset;
                if (adjustedY + 24 >= 60 && adjustedY <= this.field_22790 - 30) {
                    context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)entry.name).method_27692(class_124.field_1068), 18, adjustedY + 5, -1);
                }
                yPos += 26;
            }
        }
        context.method_25294(0, this.field_22790 - 30, this.field_22789, this.field_22790, 0);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderTooltips(context, mouseX, mouseY);
    }

    private String getEntryDescription(EchoLibEntry<?> entry) {
        try {
            return entry.getDescription();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void renderTooltips(class_332 context, int mouseX, int mouseY) {
        for (ConfigEntry configEntry : this.configEntries) {
            if (configEntry.widget == null || !configEntry.widget.method_25405((double)mouseX, (double)mouseY)) continue;
            String description = this.getEntryDescription(configEntry.entry);
            if (description == null) break;
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)description), mouseX, mouseY);
            break;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int visibleArea;
        int maxEntries;
        int totalHeight;
        if (mouseY >= 60.0 && mouseY <= (double)(this.field_22790 - 30) && (totalHeight = (maxEntries = this.currentCategoryIndex < this.categories.size() ? this.categories.get((int)this.currentCategoryIndex).entries.size() : 0) * 26) > (visibleArea = this.field_22790 - 60 - 30 - 20)) {
            this.scrollOffset += (int)(verticalAmount * 10.0);
            int maxScroll = 0;
            int minScroll = -(totalHeight - visibleArea);
            this.scrollOffset = Math.max(minScroll, Math.min(maxScroll, this.scrollOffset));
            this.rebuildEntries();
            return true;
        }
        return false;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public static EchoLibScreen create(class_437 parent, String title) {
        return new EchoLibScreen(parent, (class_2561)class_2561.method_43470((String)title));
    }

    private static class ConfigEntry {
        final EchoLibEntry<?> entry;
        final int categoryIndex;
        class_339 widget;
        class_4185 resetButton;

        ConfigEntry(EchoLibEntry<?> entry, int categoryIndex) {
            this.entry = entry;
            this.categoryIndex = categoryIndex;
        }
    }
}

