/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.HordsConfig;
import com.example.hords.HordsMod;
import com.example.hords.PlayerBroadcastSettings;
import com.twentyeightisme.echolib.api.EchoLibAPI;
import com.twentyeightisme.echolib.api.EchoLibCategory;
import com.twentyeightisme.echolib.api.EchoLibScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class HordsEchoLibConfigScreen {
    public static class_437 create(class_437 parent) {
        HordsConfig config = HordsMod.getConfig();
        EchoLibScreen screen = EchoLibAPI.createScreen((class_437)parent, (String)"Hords Configuration").setSaveAction(() -> HordsMod.saveConfig());
        EchoLibCategory spawnSettings = screen.addCategory("Spawn Settings");
        spawnSettings.addBooleanEntry("Enable Horde Spawning", () -> HordsMod.getConfig().spawnSettings.hordesEnabled, value -> {
            HordsMod.getConfig().spawnSettings.hordesEnabled = value;
        }, true);
        spawnSettings.addIntEntry("Spawn Chance", () -> config.spawnSettings.spawnChance, value -> {
            config.spawnSettings.spawnChance = Math.max(100, Math.min(36000, value));
        }, 1000);
        spawnSettings.addIntEntry("Min Horde Size", () -> config.spawnSettings.minHordSize, value -> {
            config.spawnSettings.minHordSize = Math.max(3, Math.min(50, value));
        }, 5);
        spawnSettings.addIntEntry("Max Horde Size", () -> config.spawnSettings.maxHordSize, value -> {
            config.spawnSettings.maxHordSize = Math.max(5, Math.min(100, value));
        }, 15);
        spawnSettings.addIntEntry("Min Player Distance", () -> config.spawnSettings.minPlayerDistance, value -> {
            config.spawnSettings.minPlayerDistance = Math.max(10, Math.min(100, value));
        }, 24);
        spawnSettings.addIntEntry("Max Player Distance", () -> config.spawnSettings.maxPlayerDistance, value -> {
            config.spawnSettings.maxPlayerDistance = Math.max(20, Math.min(200, value));
        }, 48);
        spawnSettings.addBooleanEntry("Require Night Time", () -> config.spawnSettings.requireNightTime, value -> {
            config.spawnSettings.requireNightTime = value;
        }, true);
        spawnSettings.addBooleanEntry("Ocean Hordes Require Night Time", () -> config.spawnSettings.oceanHordesRequireNight, value -> {
            config.spawnSettings.oceanHordesRequireNight = value;
        }, false);
        EchoLibCategory performance = screen.addCategory("Performance");
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            performance.addBooleanEntry("Receive Horde Notifications", () -> PlayerBroadcastSettings.isBroadcastEnabled(client.field_1724.method_5667()), value -> PlayerBroadcastSettings.setBroadcastEnabled(client.field_1724.method_5667(), value), true);
        }
        performance.addIntEntry("Max Active Hordes", () -> config.performance.maxActiveHordes, value -> {
            config.performance.maxActiveHordes = Math.max(1, Math.min(10, value));
        }, 3);
        performance.addLongEntry("Despawn Time (Minutes)", () -> config.performance.despawnTimeMinutes, value -> {
            config.performance.despawnTimeMinutes = Math.max(1L, Math.min(60L, value));
        }, 10L);
        performance.addIntEntry("Cooldown (Minutes)", () -> config.performance.cooldownMinutes, value -> {
            config.performance.cooldownMinutes = Math.max(0, Math.min(60, value));
        }, 5);
        EchoLibCategory broadcast = screen.addCategory("Server Notifications");
        broadcast.addBooleanEntry("Enable Spawn Messages (Server-wide)", () -> config.broadcast.enabled, value -> {
            config.broadcast.enabled = value;
        }, true);
        broadcast.addIntEntry("Message Radius", () -> config.broadcast.radius, value -> {
            config.broadcast.radius = Math.max(10, Math.min(500, value));
        }, 100);
        EchoLibCategory hordeTypes = screen.addCategory("Horde Types");
        hordeTypes.addBooleanEntry("Zombie Hordes", () -> config.hordeTypes.zombieHordsEnabled, value -> {
            config.hordeTypes.zombieHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Skeleton Hordes", () -> config.hordeTypes.skeletonHordsEnabled, value -> {
            config.hordeTypes.skeletonHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Mixed Hordes", () -> config.hordeTypes.mixedHordsEnabled, value -> {
            config.hordeTypes.mixedHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Zombified Piglin Hordes", () -> config.hordeTypes.zombifiedHordsEnabled, value -> {
            config.hordeTypes.zombifiedHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("End Hordes", () -> config.hordeTypes.endHordsEnabled, value -> {
            config.hordeTypes.endHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Ocean Hordes", () -> config.hordeTypes.oceanHordsEnabled, value -> {
            config.hordeTypes.oceanHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Piglin Hordes", () -> config.hordeTypes.piglinHordsEnabled, value -> {
            config.hordeTypes.piglinHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Magma Cube Hordes", () -> config.hordeTypes.magmacubeHordsEnabled, value -> {
            config.hordeTypes.magmacubeHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Nether Fortress Hordes", () -> config.hordeTypes.netherFortressHordsEnabled, value -> {
            config.hordeTypes.netherFortressHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Nether Mixed Hordes", () -> config.hordeTypes.netherMixedHordsEnabled, value -> {
            config.hordeTypes.netherMixedHordsEnabled = value;
        }, true);
        hordeTypes.addBooleanEntry("Soul Sand Valley Hordes", () -> config.hordeTypes.soulSandHordsEnabled, value -> {
            config.hordeTypes.soulSandHordsEnabled = value;
        }, true);
        return screen;
    }
}

