/*
 * Decompiled with CFR 0.152.
 */
package com.example.hords;

import com.example.hords.BossDeathHandler;
import com.example.hords.HordsCommand;
import com.example.hords.HordsConfig;
import com.example.hords.HordsSpawner;
import com.example.hords.PlayerBroadcastSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;

public class HordsMod
implements ModInitializer {
    public static final String MOD_ID = "hords";
    private static HordsConfig config;
    private static final Gson GSON;
    private static final Path CONFIG_FILE;

    public void onInitialize() {
        System.out.println("[HORDS] Initializing Hords Mod");
        HordsMod.loadConfig();
        PlayerBroadcastSettings.init();
        ServerTickEvents.END_SERVER_TICK.register(HordsSpawner::onServerTick);
        BossDeathHandler.registerEvents();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> HordsCommand.register((CommandDispatcher<class_2168>)dispatcher));
        System.out.println("[HORDS] Hords Mod initialized successfully");
    }

    public static HordsConfig getConfig() {
        if (config == null) {
            config = new HordsConfig();
        }
        return config;
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            System.out.println("[HORDS] Config saved");
        }
        catch (IOException e) {
            System.err.println("[HORDS] Failed to save config: " + e.getMessage());
        }
    }

    public static void loadConfig() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
                    config = (HordsConfig)GSON.fromJson((Reader)reader, HordsConfig.class);
                }
            } else {
                config = new HordsConfig();
                HordsMod.saveConfig();
            }
            if (config == null) {
                config = new HordsConfig();
            }
            if (HordsMod.config.spawnSettings == null) {
                HordsMod.config.spawnSettings = new HordsConfig.SpawnSettings();
            }
            if (HordsMod.config.performance == null) {
                HordsMod.config.performance = new HordsConfig.Performance();
            }
            if (HordsMod.config.broadcast == null) {
                HordsMod.config.broadcast = new HordsConfig.Broadcast();
            }
        }
        catch (Exception e) {
            System.err.println("[HORDS] Config error, using defaults");
            config = new HordsConfig();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("hords.json");
    }
}

