/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LanderOverlay {
    public static final ResourceLocation WARNING = Stellaris.texture("overlay/warning");

    public static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        LanderEntity lander;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Entity vehicle = player.getVehicle();
        if (!(!(vehicle instanceof LanderEntity) || (lander = (LanderEntity)vehicle).isInWall() || lander.isInWater() || lander.isInLava() || lander.isLanded())) {
            float sin = (float)Math.sin(((float)mc.level.getDayTime() + deltaTracker.getGameTimeDeltaPartialTick(true)) / 6.0f);
            float flash = Mth.clamp((float)sin, (float)0.0f, (float)4.0f);
            RenderSystem.setShaderColor((float)flash, (float)flash, (float)flash, (float)flash);
            graphics.blit(RenderType::guiTextured, WARNING, graphics.guiWidth() / 2 - 58, 50, 0.0f, 0.0f, 116, 21, 116, 21);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            double speed = (double)Math.round(100.0 * lander.getDeltaMovement().y()) / 100.0;
            MutableComponent message = Component.translatable((String)"message.stellaris.speed", (Object[])new Object[]{speed});
            graphics.drawString(Minecraft.getInstance().font, (Component)message, graphics.guiWidth() / 2 - 29, 80, -3407872);
        }
    }
}

