/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;

public class RocketBarOverlay {
    public static final ResourceLocation ROCKET = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/planet_bar/rocket.png");

    public static void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (player.getVehicle() instanceof RocketEntity || player.getVehicle() instanceof LanderEntity)) {
            double min = player.level().getMinY();
            for (int i = player.level().getMinY(); i < player.level().getMaxY(); ++i) {
                if (player.level().getBlockState(new BlockPos(player.getBlockX(), i, player.getBlockZ())).getBlock() == Blocks.AIR) continue;
                min = i;
            }
            double yHeight = (player.getY() - min) / (600.0 - min) * 113.0;
            ResourceLocation planet = PlanetUtil.getPlanetBar(player.level().dimension().location());
            graphics.blit(RenderType::guiTextured, planet, 0, graphics.guiHeight() / 2 - 64, 0.0f, 0.0f, 16, 128, 16, 128);
            graphics.blit(RenderType::guiTextured, ROCKET, 4, (int)((double)graphics.guiHeight() / 2.0 + 51.5 - yHeight), 0.0f, 0.0f, 8, 11, 8, 11);
        }
    }
}

