/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.alien;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerLikeModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.VillagerDataHolderRenderState;
import net.minecraft.client.resources.metadata.animation.VillagerMetadataSection;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;

public class AlienProfessionLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final Int2ObjectOpenHashMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectOpenHashMap)Util.make((Object)new Int2ObjectOpenHashMap(), int2ObjectOpenHashMap -> {
        int2ObjectOpenHashMap.put(1, (Object)ResourceLocation.withDefaultNamespace((String)"stone"));
        int2ObjectOpenHashMap.put(2, (Object)ResourceLocation.withDefaultNamespace((String)"iron"));
        int2ObjectOpenHashMap.put(3, (Object)ResourceLocation.withDefaultNamespace((String)"gold"));
        int2ObjectOpenHashMap.put(4, (Object)ResourceLocation.withDefaultNamespace((String)"emerald"));
        int2ObjectOpenHashMap.put(5, (Object)ResourceLocation.withDefaultNamespace((String)"diamond"));
    });
    public static final ResourceLocation ALIEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/entity/alien/alien.png");
    private final Object2ObjectMap<VillagerType, VillagerMetadataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetadataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ResourceManager resourceManager;

    public AlienProfessionLayer(RenderLayerParent<S, M> renderer, ResourceManager resourceManager) {
        super(renderer);
        this.resourceManager = resourceManager;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S renderState, float yRot, float xRot) {
        VillagerData villagerData;
        if (!((LivingEntityRenderState)renderState).isInvisible && (villagerData = ((VillagerDataHolderRenderState)renderState).getVillagerData()) != null) {
            Holder villagerProfession = villagerData.profession();
            VillagerMetadataSection.Hat hat2 = this.getHatData(this.professionHatCache, BuiltInRegistries.VILLAGER_PROFESSION, (VillagerProfession)villagerProfession.value());
            EntityModel entityModel = this.getParentModel();
            ((VillagerLikeModel)entityModel).hatVisible(hat2 == VillagerMetadataSection.Hat.NONE || hat2 == VillagerMetadataSection.Hat.PARTIAL);
            AlienProfessionLayer.renderColoredCutoutModel((EntityModel)entityModel, (ResourceLocation)ALIEN_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, renderState, (int)-1);
            ((VillagerLikeModel)entityModel).hatVisible(true);
            if (villagerProfession != VillagerProfession.NONE && !((LivingEntityRenderState)renderState).isBaby) {
                ResourceLocation resourceLocation2 = this.getResourceLocation(BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)((VillagerProfession)villagerProfession.value())));
                AlienProfessionLayer.renderColoredCutoutModel((EntityModel)entityModel, (ResourceLocation)resourceLocation2, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, renderState, (int)-1);
                if (villagerProfession != VillagerProfession.NITWIT) {
                    ResourceLocation resourceLocation3 = this.getResourceLocation((ResourceLocation)LEVEL_LOCATIONS.get(Mth.clamp((int)villagerData.level(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    AlienProfessionLayer.renderColoredCutoutModel((EntityModel)entityModel, (ResourceLocation)resourceLocation3, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, renderState, (int)-1);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(ResourceLocation location) {
        return location.withPath(string2 -> "textures/entity/alien/" + string2 + ".png");
    }

    public <K> VillagerMetadataSection.Hat getHatData(Object2ObjectMap<K, VillagerMetadataSection.Hat> cache, DefaultedRegistry<K> villagerTypeRegistry, K key) {
        return (VillagerMetadataSection.Hat)cache.computeIfAbsent(key, object2 -> this.resourceManager.getResource(this.getResourceLocation(villagerTypeRegistry.getKey(key))).flatMap(resource -> {
            try {
                return resource.metadata().getSection(VillagerMetadataSection.TYPE).map(VillagerMetadataSection::hat);
            }
            catch (IOException var2) {
                return Optional.empty();
            }
        }).orElse(VillagerMetadataSection.Hat.NONE));
    }
}

