/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.martianraptor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.client.renderers.entities.martianraptor.MartianRaptorRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MartianRaptorModel
extends EntityModel<MartianRaptorRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"martian_raptor"), "main");
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final boolean Eat = false;
    private final float Anim = 0.0f;
    private final boolean AttackCheck = false;

    public MartianRaptorModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(14, 69).addBox(-2.0f, 11.7065f, -5.0813f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)9.0f, (float)4.0f));
        PartDefinition cube_r1 = leg1.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(36, 64).addBox(-2.5f, -7.0f, -2.5f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)7.7065f, (float)2.4187f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = leg1.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 58).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.2935f, (float)2.4187f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(14, 69).mirror().addBox(-3.0f, 11.7065f, -5.0813f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)9.0f, (float)4.0f));
        PartDefinition cube_r3 = leg2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(36, 64).mirror().addBox(-2.5f, -7.0f, -2.5f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.7065f, (float)2.4187f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = leg2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 58).mirror().addBox(-2.5f, -6.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)-0.2935f, (float)2.4187f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -24.0f, -6.0f, 8.0f, 10.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-19.0f, (float)-3.0f));
        PartDefinition bone2 = head.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(34, 34).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-8.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition bone = bone2.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.25f, (float)-6.75f, (float)6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = bone.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 42).addBox(-6.0f, -5.5f, -4.5f, 10.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2012f, (float)0.0f, (float)-0.1198f, (float)-0.0436f, (float)0.6981f, (float)0.0f));
        PartDefinition cube_r6 = bone.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(-4.0f, -5.5f, -4.5f, 10.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.7988f, (float)0.0f, (float)-0.1198f, (float)-0.0436f, (float)-0.6981f, (float)0.0f));
        PartDefinition mouth1 = bone2.addOrReplaceChild("mouth1", CubeListBuilder.create(), PartPose.offset((float)-2.1711f, (float)4.4542f, (float)3.0357f));
        PartDefinition cube_r7 = mouth1.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(52, 71).addBox(-1.5789f, -1.5855f, -2.25f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition mouth2 = bone2.addOrReplaceChild("mouth2", CubeListBuilder.create(), PartPose.offset((float)1.8289f, (float)4.4542f, (float)3.0357f));
        PartDefinition cube_r8 = mouth2.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(52, 71).mirror().addBox(-1.0789f, -1.4145f, -2.25f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-19.0f, (float)9.0f));
        PartDefinition cube_r9 = tail.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(20, 50).addBox(-2.0f, -2.0f, -5.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.1366f, (float)17.1501f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = tail.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(31, 0).addBox(-3.0f, -2.5f, -5.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.8909f, (float)9.0849f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = tail.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(63, 7).addBox(-2.5f, -1.0f, -1.5f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.4973f, (float)16.5505f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = tail.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(61, 31).addBox(-3.5f, -1.0f, -2.5f, 7.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.7473f, (float)12.5505f, (float)1.6144f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = tail.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(24, 26).addBox(-10.5f, -2.0f, -5.5f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)2.7065f, (float)5.4187f, (float)1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = tail.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(53, 0).addBox(-10.5f, -2.0f, -5.5f, 8.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.5f, (float)3.7065f, (float)9.4187f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = tail.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(0, 25).addBox(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.4079f, (float)1.7286f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(MartianRaptorRenderState state) {
        float i = state.attackAnim;
        float f = 1.0f - Mth.abs((float)(10.0f - 2.0f * i)) / 10.0f;
        this.body.getChild((String)"head").getChild((String)"bone2").getChild((String)"mouth1").zRot = Mth.lerp((float)f, (float)0.0f, (float)-1.1490659f);
        this.body.getChild((String)"head").getChild((String)"bone2").getChild((String)"mouth2").zRot = -Mth.lerp((float)f, (float)0.0f, (float)-1.1490659f);
        this.leg1.xRot = Mth.cos((float)state.walkAnimationPos) * -1.0f * state.walkAnimationSpeed;
        this.leg2.xRot = Mth.cos((float)state.walkAnimationPos) * 1.0f * state.walkAnimationSpeed;
        this.body.getChild((String)"head").yRot = state.yRot / 57.295776f;
        this.body.getChild((String)"head").xRot = state.xRot / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg1.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

