/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.mogler;

import com.st0x0ef.stellaris.client.renderers.entities.mogler.MoglerModel;
import com.st0x0ef.stellaris.client.renderers.entities.mogler.MoglerRenderState;
import com.st0x0ef.stellaris.common.entities.mobs.Mogler;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoglerRenderer
extends MobRenderer<Mogler, MoglerRenderState, MoglerModel> {
    private static final ResourceLocation LAYER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/entity/mogler.png");

    public MoglerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MoglerModel(context.bakeLayer(MoglerModel.LAYER_LOCATION)), 0.7f);
    }

    public MoglerRenderState createRenderState() {
        return new MoglerRenderState();
    }

    protected boolean isShaking(MoglerRenderState mogler) {
        return super.isShaking((LivingEntityRenderState)mogler) || mogler.isConverting;
    }

    public void extractRenderState(Mogler livingEntity, MoglerRenderState livingEntityRenderState, float f) {
        super.extractRenderState((LivingEntity)livingEntity, (LivingEntityRenderState)livingEntityRenderState, f);
        livingEntityRenderState.attackAnim = livingEntity.getAttackAnim(f);
        livingEntityRenderState.isConverting = livingEntity.isConverting();
    }

    public ResourceLocation getTextureLocation(MoglerRenderState renderState) {
        return LAYER_LOCATION;
    }
}

