/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.pygro;

import com.st0x0ef.stellaris.client.renderers.entities.pygro.PygroAnim;
import com.st0x0ef.stellaris.client.renderers.entities.pygro.PygroRenderState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PygroModel
extends HumanoidModel<PygroRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"pygro"), "main");
    public final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public PygroModel(ModelPart root) {
        super(root);
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.bodyDefault = this.body.storePose();
        this.headDefault = this.head.storePose();
        this.leftArmDefault = this.leftArm.storePose();
        this.rightArmDefault = this.rightArm.storePose();
    }

    public static MeshDefinition createMesh(CubeDeformation p_170812_) {
        MeshDefinition meshdefinition = PlayerModel.createMesh((CubeDeformation)p_170812_, (boolean)false);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170812_), PartPose.ZERO);
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, p_170812_).texOffs(31, 1).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, p_170812_).texOffs(2, 4).addBox(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_170812_).texOffs(2, 0).addBox(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, p_170812_), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(39, 6).addBox(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_170812_), PartPose.offsetAndRotation((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        partdefinition1.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(39, 6).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, p_170812_), PartPose.offsetAndRotation((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition eyes = partdefinition1.addOrReplaceChild("eyesg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        eyes.addOrReplaceChild("eyes", CubeListBuilder.create().texOffs(46, 0).addBox(-4.5f, -4.5f, -0.75f, 9.0f, 7.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-7.5f, (float)-4.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition fang = partdefinition1.addOrReplaceChild("noseg1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        fang.addOrReplaceChild("nose1", CubeListBuilder.create().texOffs(33, 2).addBox(-1.25f, -1.35f, -0.5f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-25.0f, (float)-4.5f, (float)0.0631f, (float)0.3435f, (float)0.1855f));
        PartDefinition fang2 = partdefinition1.addOrReplaceChild("noseg2", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)24.0f, (float)0.0f));
        fang2.addOrReplaceChild("nose2", CubeListBuilder.create().texOffs(33, 2).addBox(-2.15f, -1.45f, -0.35f, 3.0f, 3.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-25.0f, (float)-4.5f, (float)0.0631f, (float)-0.3435f, (float)-0.1855f));
        return meshdefinition;
    }

    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.create((MeshDefinition)PygroModel.createMesh(CubeDeformation.NONE), (int)64, (int)64);
    }

    public void setupAnim(PygroRenderState state) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(state.yRot, state.xRot);
        this.animateWalk(PygroAnim.walk, state.walkAnimationPos, state.walkAnimationSpeed, 2.0f, 2.5f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }
}

