/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum RocketModel implements StringRepresentable
{
    TINY(0),
    SMALL(1),
    NORMAL(2),
    BIG(3);

    public static final Codec<RocketModel> CODEC;
    private final int id;

    private RocketModel(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "tiny";
            case 1 -> "small";
            case 2 -> "normal";
            case 3 -> "big";
        };
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public static RocketModel fromString(String name) {
        return switch (name) {
            case "tiny" -> TINY;
            case "normal" -> NORMAL;
            case "small" -> SMALL;
            case "big" -> BIG;
            default -> TINY;
        };
    }

    public int getMaxPlayerNumber() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(RocketModel::values);
    }
}

