/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.tiny;

import com.st0x0ef.stellaris.client.renderers.entities.vehicle.AbstractVehicleRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.VehicleRenderState;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.tiny.TinyRocketModel;
import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.vehicle_upgrade.ModelUpgrade;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class TinyRocketRenderer
extends AbstractVehicleRenderer<RocketEntity, VehicleRenderState, TinyRocketModel> {
    public ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/vehicle/rocket_skin/tiny/standard.png");

    public TinyRocketRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new TinyRocketModel(renderManagerIn.bakeLayer(TinyRocketModel.LAYER_LOCATION)), 0.5f);
    }

    public VehicleRenderState createRenderState() {
        return new VehicleRenderState();
    }

    public void extractRenderState(RocketEntity entity, VehicleRenderState entityRenderState, float f) {
        super.extractRenderState((Entity)entity, (EntityRenderState)entityRenderState, f);
        entityRenderState.entity = entity;
        entityRenderState.partialTick = f;
    }

    @Override
    public ResourceLocation getTextureLocation(IVehicleEntity entity) {
        RocketEntity rocket = (RocketEntity)entity;
        rocket.MODEL_UPGRADE = new ModelUpgrade(RocketModel.TINY);
        return rocket.getFullSkinTexture();
    }

    @Override
    protected boolean isShaking(IVehicleEntity rocket) {
        return (Boolean)rocket.getEntityData().get(RocketEntity.ROCKET_START);
    }
}

