/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle.rover;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.VehicleRenderState;
import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.base.AbstractRoverBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractRoverRenderer<T extends AbstractRoverBase, S extends VehicleRenderState, M extends EntityModel<S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    protected final M model;
    protected final List<RenderLayer<S, M>> layers = Lists.newArrayList();

    public AbstractRoverRenderer(EntityRendererProvider.Context context, M model, float shadowRadius) {
        super(context);
        this.model = model;
        this.shadowRadius = shadowRadius;
    }

    public M getModel() {
        return this.model;
    }

    public void render(S renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Entity entity;
        poseStack.pushPose();
        boolean shouldSit = ((VehicleRenderState)((Object)renderState)).entity.isPassenger() && ((VehicleRenderState)((Object)renderState)).entity.getVehicle() != null;
        float f = Mth.rotLerp((float)((VehicleRenderState)((Object)renderState)).partialTick, (float)((VehicleRenderState)((Object)renderState)).entity.yRotO, (float)((VehicleRenderState)((Object)renderState)).entity.getYRot());
        float f1 = Mth.rotLerp((float)((VehicleRenderState)((Object)renderState)).partialTick, (float)((VehicleRenderState)((Object)renderState)).entity.yRotO, (float)((VehicleRenderState)((Object)renderState)).entity.getYRot());
        float f2 = f1 - f;
        if (shouldSit && (entity = ((VehicleRenderState)((Object)renderState)).entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)((VehicleRenderState)((Object)renderState)).partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)((VehicleRenderState)((Object)renderState)).partialTick, (float)((VehicleRenderState)((Object)renderState)).entity.xRotO, (float)((VehicleRenderState)((Object)renderState)).entity.getXRot());
        float f7 = this.getBob(((VehicleRenderState)((Object)renderState)).entity, ((VehicleRenderState)((Object)renderState)).partialTick);
        this.setupRotations(((VehicleRenderState)((Object)renderState)).entity, poseStack, f7, f, ((VehicleRenderState)((Object)renderState)).partialTick);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        this.model.setupAnim(renderState);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible(((VehicleRenderState)((Object)renderState)).entity);
        boolean flag1 = !flag && !((VehicleRenderState)((Object)renderState)).entity.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)((VehicleRenderState)((Object)renderState)).entity);
        RenderType rendertype = this.getRenderType(((VehicleRenderState)((Object)renderState)).entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = bufferSource.getBuffer(rendertype);
            int i = AbstractRoverRenderer.getOverlayCoords(((VehicleRenderState)((Object)renderState)).entity, this.getWhiteOverlayProgress(((VehicleRenderState)((Object)renderState)).entity, ((VehicleRenderState)((Object)renderState)).partialTick));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, i, -1);
        }
        if (!((VehicleRenderState)((Object)renderState)).entity.isSpectator()) {
            for (RenderLayer<S, M> renderlayer : this.layers) {
                renderlayer.render(poseStack, bufferSource, packedLight, renderState, f2, f6);
            }
        }
        poseStack.popPose();
        super.render(renderState, poseStack, bufferSource, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(IVehicleEntity entity, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation(entity);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (p_115323_) {
            return this.model.renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    protected boolean isBodyVisible(IVehicleEntity entity) {
        return !entity.isInvisible();
    }

    protected boolean isShaking(IVehicleEntity entity) {
        return false;
    }

    public static int getOverlayCoords(IVehicleEntity entity, float p_115340_) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)p_115340_), (int)OverlayTexture.v((boolean)false));
    }

    protected float getWhiteOverlayProgress(IVehicleEntity entity, float p_115335_) {
        return 0.0f;
    }

    protected void setupRotations(IVehicleEntity entity, PoseStack poseStack, float p_115319_, float p_115320_, float p_115321_) {
        if (this.isShaking(entity) && !Minecraft.getInstance().isPaused()) {
            double shakeDirection1 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            double shakeDirection2 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            double shakeDirection3 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            poseStack.translate(shakeDirection1, shakeDirection2, shakeDirection3);
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - p_115320_));
    }

    protected float getBob(IVehicleEntity entity, float p_115306_) {
        return (float)entity.tickCount + p_115306_;
    }

    protected ResourceLocation getTextureLocation(IVehicleEntity rocket) {
        return null;
    }
}

