/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle.rover;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.VehicleRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RoverModel
extends EntityModel<VehicleRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"rover"), "main");
    private final ModelPart rover;
    private final ModelPart antenna;

    public RoverModel(ModelPart root) {
        super(root);
        this.rover = root.getChild("Frame");
        this.antenna = root.getChild("Antenna");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Frame = partdefinition.addOrReplaceChild("Frame", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, -11.0f, -26.0f, 30.0f, 2.0f, 48.0f, new CubeDeformation(0.0f)).texOffs(108, 0).addBox(9.0f, -9.0f, -23.0f, 4.0f, 2.0f, 42.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-11.0f, -11.0f, -35.0f, 22.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(51, 106).addBox(14.0f, -12.0f, -25.0f, 2.0f, 2.0f, 47.0f, new CubeDeformation(0.0f)).texOffs(132, 98).addBox(-16.0f, -12.0f, 22.0f, 32.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(132, 92).addBox(-16.0f, -12.0f, -28.0f, 32.0f, 3.0f, 3.0f, new CubeDeformation(0.01f)).texOffs(0, 104).addBox(-16.0f, -12.0f, -25.0f, 2.0f, 2.0f, 47.0f, new CubeDeformation(0.0f)).texOffs(102, 106).addBox(-13.0f, -9.0f, -23.0f, 4.0f, 2.0f, 42.0f, new CubeDeformation(0.0f)).texOffs(132, 80).addBox(-11.0f, -13.0f, -14.0f, 22.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(66, 50).addBox(-11.0f, -19.0f, -24.0f, 22.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 104).addBox(3.0f, -21.0f, -17.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 45).addBox(6.0f, -20.0f, -18.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(132, 65).addBox(-12.0f, -15.0f, -15.0f, 24.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-14.0f, -22.0f, 2.0f, 9.0f, 11.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(40, 80).addBox(6.0f, -21.0f, 24.0f, 4.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(74, 78).addBox(4.0f, -28.0f, 24.0f, 8.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 80).addBox(-12.0f, -28.0f, 24.0f, 8.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 24).addBox(-10.0f, -21.0f, 24.0f, 4.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)2.0f));
        PartDefinition cube_r1 = Frame.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 50).addBox(-4.0f, 0.0f, -26.0f, 7.0f, 2.0f, 52.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)19.0f, (float)-10.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition cube_r2 = Frame.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 50).addBox(-6.0f, -11.0f, -7.0f, 13.0f, 13.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-13.0f, (float)9.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition cube_r3 = Frame.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(132, 50).addBox(-12.0f, -1.0f, 0.0f, 24.0f, 3.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)-5.0f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = Frame.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 50).addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-16.0f, (float)-20.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = Frame.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(74, 62).addBox(-10.0f, -17.0f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(74, 66).addBox(-10.0f, -17.0f, 18.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r6 = Frame.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(74, 70).addBox(-5.0503f, -2.1508f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-14.0f, (float)-4.0f, (float)-21.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r7 = Frame.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(68, 87).addBox(-2.0f, -2.0f, 2.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(20, 80).addBox(-16.0f, -2.0f, 2.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-8.0f, (float)-35.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = Frame.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(86, 93).addBox(-0.55f, 0.0f, -0.85f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)11.0f, (float)-11.0f, (float)-34.0f, (float)0.0f, (float)-0.5672f, (float)0.0f));
        PartDefinition cube_r9 = Frame.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(66, 52).addBox(-3.0f, 0.0f, -26.0f, 7.0f, 2.0f, 52.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)-19.0f, (float)-10.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r10 = Frame.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(66, 95).addBox(-7.45f, 0.0f, -0.85f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-11.0f, (float)-11.0f, (float)-34.0f, (float)0.0f, (float)0.5672f, (float)0.0f));
        PartDefinition cube_r11 = Frame.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(74, 74).addBox(-1.0f, -17.0f, 18.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 76).addBox(-1.0f, -17.0f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r12 = Frame.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(26, 76).addBox(-5.9497f, -2.1508f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)14.0f, (float)-4.0f, (float)-21.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition Wheels = Frame.addOrReplaceChild("Wheels", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)-2.0f));
        PartDefinition Wheel1 = Wheels.addOrReplaceChild("Wheel1", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(96, 72).addBox(-1.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(42, 36).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(122, 0).addBox(-2.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(-2.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(-2.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)), PartPose.offset((float)19.0f, (float)-5.0f, (float)-19.0f));
        PartDefinition cube_r13 = Wheel1.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = Wheel1.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = Wheel1.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)).texOffs(36, 38).addBox(0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(102, 118).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r16 = Wheel1.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Wheel2 = Wheels.addOrReplaceChild("Wheel2", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(88, 81).addBox(-1.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(31, 0).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(122, 0).addBox(-2.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(-2.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(-2.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)), PartPose.offset((float)19.0f, (float)-5.0f, (float)0.0f));
        PartDefinition cube_r17 = Wheel2.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r18 = Wheel2.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = Wheel2.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)).texOffs(31, 4).addBox(0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(61, 118).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = Wheel2.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Wheel3 = Wheels.addOrReplaceChild("Wheel3", CubeListBuilder.create().texOffs(108, 0).addBox(-3.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(0, 89).addBox(-2.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(42, 22).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(122, 0).addBox(-3.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(-3.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(-3.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)), PartPose.offset((float)20.0f, (float)-5.0f, (float)19.0f));
        PartDefinition cube_r21 = Wheel3.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r22 = Wheel3.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r23 = Wheel3.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)).texOffs(32, 38).addBox(0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(71, 118).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r24 = Wheel3.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(108, 0).addBox(-2.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Wheel4 = Wheels.addOrReplaceChild("Wheel4", CubeListBuilder.create().texOffs(108, 0).addBox(0.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(0.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(0.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(0.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(28, 88).addBox(1.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(6, 8).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-20.0f, (float)-5.0f, (float)-19.0f));
        PartDefinition cube_r25 = Wheel4.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(4, 8).addBox(-1.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(85, 116).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r26 = Wheel4.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r27 = Wheel4.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r28 = Wheel4.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Wheel5 = Wheels.addOrReplaceChild("Wheel5", CubeListBuilder.create().texOffs(31, 0).addBox(1.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(6, 0).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(122, 0).addBox(0.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(0.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(0.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(0.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)), PartPose.offset((float)-20.0f, (float)-5.0f, (float)0.0f));
        PartDefinition cube_r29 = Wheel5.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r30 = Wheel5.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r31 = Wheel5.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)).texOffs(0, 0).addBox(-1.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(39, 50).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r32 = Wheel5.addOrReplaceChild("cube_r32", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Wheel6 = Wheels.addOrReplaceChild("Wheel6", CubeListBuilder.create().texOffs(108, 0).addBox(1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)).texOffs(14, 88).addBox(2.0f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(122, 0).addBox(1.0f, -2.0f, 3.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(122, 0).addBox(1.0f, -2.0f, -5.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.12f)).texOffs(108, 0).addBox(1.0f, 3.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.12f)), PartPose.offset((float)-21.0f, (float)-5.0f, (float)19.0f));
        PartDefinition cube_r33 = Wheel6.addOrReplaceChild("cube_r33", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)-2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r34 = Wheel6.addOrReplaceChild("cube_r34", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r35 = Wheel6.addOrReplaceChild("cube_r35", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)).texOffs(0, 2).addBox(-1.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(85, 108).addBox(-0.5f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r36 = Wheel6.addOrReplaceChild("cube_r36", CubeListBuilder.create().texOffs(108, 0).addBox(-1.0f, -5.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.121f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition Antenna = partdefinition.addOrReplaceChild("Antenna", CubeListBuilder.create().texOffs(0, 0).addBox(8.0f, -29.0f, -2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(39, 0).addBox(14.0f, -28.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 45).addBox(0.0f, -27.5f, -1.0f, 14.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 8).addBox(8.0f, -35.0f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(100, 62).addBox(4.0f, -28.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(66, 62).addBox(-1.0f, -28.0f, -1.0f, 2.0f, 29.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.0f, (float)9.0f, (float)20.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(VehicleRenderState state) {
        this.rover.yRot = state.entity.getYHeadRot() / 57.295776f;
        float wheelRotation = (float)state.entity.getDeltaMovement().x / 5.0f;
        if (state.entity.getDirection() == Direction.NORTH || state.entity.getDirection() == Direction.SOUTH) {
            wheelRotation = (float)state.entity.getDeltaMovement().z / 5.0f;
        }
        if (state.entity.getMotionDirection().isFacingAngle(state.entity.getVisualRotationYInDegrees())) {
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel1").xRot += wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel2").xRot += wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel3").xRot += wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel4").xRot += wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel5").xRot += wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel6").xRot += wheelRotation;
        } else if (state.entity.getMotionDirection().getOpposite().isFacingAngle(state.entity.getVisualRotationYInDegrees())) {
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel1").xRot -= -wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel2").xRot -= -wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel3").xRot -= -wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel4").xRot -= -wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel5").xRot -= -wheelRotation;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel6").xRot -= -wheelRotation;
        } else {
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel1").xRot = 0.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel2").xRot = 0.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel3").xRot = 0.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel4").xRot = 0.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel5").xRot = 0.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel6").xRot = 0.0f;
        }
        if (state.entity.getXRot() > 0.0f) {
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel1").xRot += state.entity.getXRot() / 4.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel2").xRot += state.entity.getXRot() / 4.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel3").xRot += state.entity.getXRot() / 4.0f;
            this.rover.getChild((String)"Wheels").getChild((String)"Wheel4").xRot += state.entity.getXRot() / 4.0f;
        }
        this.antenna.yRot = state.ageInTicks / 20.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.rover.render(poseStack, buffer, packedLight, packedOverlay);
        this.antenna.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

