/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.globe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.st0x0ef.stellaris.client.renderers.globe.GlobeModel;
import com.st0x0ef.stellaris.common.blocks.GlobeBlock;
import com.st0x0ef.stellaris.common.blocks.entities.GlobeBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class GlobeBlockRenderer
implements BlockEntityRenderer<GlobeBlockEntity> {
    private final GlobeModel model;

    public GlobeBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new GlobeModel(context.bakeLayer(GlobeModel.LAYER_LOCATION));
    }

    public void render(GlobeBlockEntity blockEntity, float particleTicks, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, int overlay, Vec3 vec3) {
        if (blockEntity.getLevel() == null) {
            return;
        }
        BlockState state = blockEntity.getBlockState();
        if (!(state.getBlock() instanceof GlobeBlock)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Direction direction = (Direction)state.getValue(GlobeBlock.FACING);
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 1.5, 0.5);
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(direction.toYRot()));
        this.model.setupAnim(blockEntity, particleTicks);
        VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)((GlobeBlock)state.getBlock()).texture));
        this.model.renderToBuffer(matrixStackIn, vertexBuilder, combinedLight, OverlayTexture.NO_OVERLAY, -1);
        mc.renderBuffers().bufferSource().endBatch();
        matrixStackIn.popPose();
    }
}

