/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.globe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.client.renderers.globe.GlobeModel;
import com.st0x0ef.stellaris.common.items.GlobeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public record GlobeItemRenderer(ResourceLocation texture, GlobeModel model) implements SpecialModelRenderer<ResourceLocation>
{
    public void render(ResourceLocation texture, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)texture));
        if (level != null && !mc.isPaused() && mc.getFps() > 0) {
            this.model.globe.getChild((String)"planet").yRot = (float)(level.getGameTime() + (long)(1 / mc.getFps())) / -20.0f;
        }
        this.model.renderToBuffer(poseStack, vertexBuilder, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }

    @Nullable
    public ResourceLocation extractArgument(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof GlobeItem) {
            GlobeItem item2 = (GlobeItem)item;
            return item2.getTexture();
        }
        return this.texture;
    }

    public record Unbaked(ResourceLocation texture) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(Unbaked::texture)).apply((Applicative)instance, Unbaked::new));

        @NotNull
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new GlobeItemRenderer(this.texture, new GlobeModel(modelSet.bakeLayer(GlobeModel.LAYER_LOCATION)));
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

