/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.menus.MilkyWayMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MilkyWayScreen
extends AbstractContainerScreen<MilkyWayMenu> {
    public static final ResourceLocation MILKY_WAY_TEXTURE = Stellaris.texture("environment/milky_way");
    public static final ResourceLocation BACKGROUND_TEXTURE = Stellaris.guiTexture("planet_selection");
    public static float rotationAngle = 0.0f;
    public static boolean isPausePressed = false;
    public Component milkywayTranslatable = Component.translatable((String)"text.stellaris.milkywayscreen.milkyway");

    public MilkyWayScreen(MilkyWayMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 1200;
        this.imageHeight = 1600;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderMilkyWay(graphics, partialTicks);
    }

    protected void init() {
        super.init();
        isPausePressed = false;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 88) {
            isPausePressed = !isPausePressed;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void renderMilkyWay(GuiGraphics guiGraphics, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        int milkywayWidth = 192;
        int milkywayHeight = 192;
        int milkywayX = (this.width - milkywayWidth) / 2;
        int milkywayY = (this.height - milkywayHeight) / 2;
        if (!isPausePressed) {
            rotationAngle -= partialTicks * 0.005f;
        }
        ScreenHelper.drawTexturewithRotation(guiGraphics, MILKY_WAY_TEXTURE, milkywayX, milkywayY, 0, 0, milkywayWidth, milkywayHeight, milkywayWidth, milkywayHeight, rotationAngle);
        int nameWidth = font.width((FormattedText)this.milkywayTranslatable);
        guiGraphics.drawString(font, this.milkywayTranslatable.getString(), (this.width - nameWidth) / 2, 10, 0xFFFFFF);
    }
}

