/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.entities.vehicles.RoverEntity;
import com.st0x0ef.stellaris.common.menus.RoverMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RoverScreen
extends AbstractContainerScreen<RoverMenu> {
    private static final ResourceLocation TEXTURE = Stellaris.guiTexture("rover");
    private final RoverEntity rover = ((RoverMenu)this.getMenu()).getRover();
    private GaugeWidget fuelGauge;

    public RoverScreen(RoverMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.rover == null) {
            return;
        }
        this.fuelGauge = new GaugeWidget(this.leftPos + 48, this.topPos + 26, 12, 46, (Component)Component.translatable((String)"stellaris.screen.fuel"), this.rover.getRoverComponent().getFuelType().getFuelTexture(), GUISprites.FLUID_TANK_OVERLAY, this.rover.getRoverComponent().getTankCapacity(), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.fuelGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.rover == null) {
            return;
        }
        this.fuelGauge.updateAmount(this.rover.getFuel());
        this.fuelGauge.updateSprite(this.rover.getRoverComponent().getFuelTexture());
        this.fuelGauge.renderTooltip(graphics, mouseX, mouseY, this.font);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }
}

