/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.SolarPanelEntity;
import com.st0x0ef.stellaris.common.menus.SolarPanelMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    public static final ResourceLocation TEXTURE = Stellaris.guiTexture("solar_panel");
    private final SolarPanelEntity blockEntity = ((SolarPanelMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget energyGauge;

    public SolarPanelScreen(SolarPanelMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge = new GaugeWidget(this.leftPos + 67, this.topPos + 15, 46, 15, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, GUISprites.SIDEWAYS_BATTERY_OVERLAY, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.energyGauge.renderTooltips(guiGraphics, x, y, this.font, list -> list.add(Component.translatable((String)"gauge_text.stellaris.max_generation", (Object[])new Object[]{((SolarPanelMenu)this.getMenu()).getBlockEntity().getEnergyGeneratedPT()})));
    }
}

