/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.menus.WaitMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaitScreen
extends AbstractContainerScreen<WaitMenu> {
    public static final ResourceLocation BACKGROUND_TEXTURE = Stellaris.guiTexture("planet_selection");
    public final String playerChoosing;
    public int timeOnTheScreen = 0;

    public WaitScreen(WaitMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 1200;
        this.imageHeight = 1600;
        this.playerChoosing = menu.getFirstPlayerName();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderText(graphics, partialTicks);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void containerTick() {
        ++this.timeOnTheScreen;
        super.containerTick();
    }

    private void renderText(GuiGraphics guiGraphics, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"text.stellaris.waitscreen", (Object[])new Object[]{this.playerChoosing}), this.width / 2, this.height / 2, 15067135);
        if (this.timeOnTheScreen > 2500 && this.timeOnTheScreen < 3500) {
            guiGraphics.drawCenteredString(font, (Component)Component.literal((String)"He is taking very long..."), this.width / 2, this.height / 2 + 20, 15067135);
        } else if (this.timeOnTheScreen > 3500) {
            guiGraphics.drawCenteredString(font, (Component)Component.literal((String)"Is bro sleeping ?"), this.width / 2, this.height / 2 + 20, 15067135);
        }
    }

    public void onClose() {
        if (this.getPlayer().stellaris$isPlanetMenuOpen()) {
            return;
        }
        super.onClose();
    }

    public Player getPlayer() {
        return ((WaitMenu)this.menu).getPlayer();
    }
}

