/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GaugeChunkWidget
extends AbstractWidget {
    protected long capacity;
    protected long amount = 0L;
    protected ResourceLocation sprite;
    protected ResourceLocation overlay_sprite;
    protected final Direction4 DIRECTION;
    protected final int imageWidth;
    protected final int imageHeight;

    public GaugeChunkWidget(int x, int y, int imageWidth, int imageHeight, int width, int height, Component message, ResourceLocation sprite, @Nullable ResourceLocation overlay_sprite, long capacity, Direction4 direction) {
        super(x, y, width, height, message);
        this.sprite = sprite;
        this.overlay_sprite = overlay_sprite;
        this.capacity = capacity;
        this.DIRECTION = direction;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        switch (this.DIRECTION.ordinal()) {
            case 0: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.imageWidth, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.imageWidth * j, this.getY() + this.getHeight() - i, this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, x, this.getHeight(), 0, this.getHeight() - i, this.getX() + this.width - x, this.getY() + this.getHeight() - i, x, i);
                break;
            }
            case 1: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getHeight() - 1)));
                for (int j = 0; j < this.width / this.imageWidth; ++j) {
                    guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.imageWidth, this.getHeight(), 0, 0, this.getX() + this.imageWidth * j, this.getY(), this.imageWidth, i);
                }
                int x = this.width % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, x, this.getHeight(), 0, 0, this.getX() + this.width - x, this.getY(), x, i);
                break;
            }
            case 2: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.getWidth(), this.imageHeight, 0, 0, this.getX(), this.getY() + this.imageHeight * j, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.getWidth(), y, 0, 0, this.getX(), this.getY() + this.height - y, i, y);
                break;
            }
            case 3: {
                int i = Mth.ceil((double)(this.getProgress(this.amount, this.capacity) * (double)(this.getWidth() - 1)));
                for (int j = 0; j < this.height / this.imageHeight; ++j) {
                    guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.getWidth(), this.imageHeight, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.imageHeight * j, i, this.imageHeight);
                }
                int y = this.height % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.blitSprite(RenderType::guiTextured, this.sprite, this.getWidth(), y, this.getWidth() - i, 0, this.getX() + this.getWidth() - i, this.getY() + this.height - y, i, y);
            }
        }
        if (this.overlay_sprite != null) {
            guiGraphics.blitSprite(RenderType::guiTextured, this.overlay_sprite, this.getX(), this.getY(), this.width, this.height);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY, Font font) {
        this.renderTooltips(graphics, mouseX, mouseY, font, list -> {});
    }

    public void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY, Font font, Consumer<List<Component>> components) {
        String GaugeComponent = this.getMessage().getString() + " : " + this.amount + " / " + this.capacity;
        Component capacity = this.amount >= this.capacity ? Utils.getMessageComponent(GaugeComponent, "Lime") : (this.amount <= 0L ? Utils.getMessageComponent(GaugeComponent, "Red") : Utils.getMessageComponent(GaugeComponent, "Orange"));
        ArrayList<Component> components1 = new ArrayList<Component>();
        components.accept(components1);
        components1.addFirst(capacity);
        if (mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= this.getY() && mouseY <= this.getY() + this.height) {
            graphics.renderComponentTooltip(font, components1, mouseX, mouseY);
        }
    }

    public void updateAmount(long value) {
        this.amount = Math.clamp(value, 0L, this.capacity);
    }

    public void updateCapacity(long capacity) {
        this.capacity = capacity;
        this.amount = Math.min(this.amount, capacity);
    }

    public void updateSprite(ResourceLocation sprite) {
        this.sprite = sprite;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private double getProgress(Long amount, Long capacity) {
        return Mth.clamp((double)((double)amount.longValue() / (double)capacity.longValue()), (double)0.0, (double)1.0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public static enum Direction4 {
        DOWN_UP,
        UP_DOWN,
        LEFT_RIGHT,
        RIGHT_LEFT;

    }
}

