/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks;

import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RocketLaunchPad
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty STAGE = BlockStateProperties.LIT;
    public static final VoxelShape SHAPE_HIGH = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape SHAPE_NORMAL = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.187, (double)1.0);

    public RocketLaunchPad(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)STAGE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos blockPos2, BlockState blockState2, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, STAGE});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return !world.getBlockState(pos.below()).is(state.getBlock());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)STAGE)).booleanValue()) {
            return SHAPE_HIGH;
        }
        return SHAPE_NORMAL;
    }

    public void onPlace(BlockState p_60566_, Level p_60567_, BlockPos p_60568_, BlockState p_60569_, boolean p_60570_) {
        super.onPlace(p_60566_, p_60567_, p_60568_, p_60569_, p_60570_);
        p_60567_.scheduleTick(p_60568_, (Block)this, 1);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        BlockPos pos2;
        int f2;
        int i1;
        int y = pos.getY();
        int x = pos.getX() - 1;
        int z = pos.getZ() - 1;
        int x2 = pos.getX() - 2;
        int z2 = pos.getZ() - 2;
        ArrayList<Boolean> flag1 = new ArrayList<Boolean>();
        ArrayList<Boolean> flag2 = new ArrayList<Boolean>();
        for (i1 = x; i1 < x + 3; ++i1) {
            for (f2 = z; f2 < z + 3; ++f2) {
                pos2 = new BlockPos(i1, y, f2);
                flag1.add(level.getBlockState(pos2).is((Block)BlocksRegistry.ROCKET_LAUNCH_PAD.get()));
            }
        }
        for (i1 = x2; i1 < x2 + 5; ++i1) {
            for (f2 = z2; f2 < z2 + 5; ++f2) {
                pos2 = new BlockPos(i1, y, f2);
                if (!level.getBlockState(pos2).is((Block)BlocksRegistry.ROCKET_LAUNCH_PAD.get()) || pos2.equals((Object)pos)) continue;
                flag2.add((Boolean)level.getBlockState(pos2).getValue((Property)STAGE));
            }
        }
        if (!flag1.contains(false)) {
            if (!((Boolean)state.getValue((Property)STAGE)).booleanValue() && !flag2.contains(true)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (((Boolean)state.getValue((Property)STAGE)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Boolean.valueOf(false)), 2);
        }
        level.scheduleTick(new BlockPos(pos.getX(), pos.getY(), pos.getZ()), (Block)this, 1);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

